/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.event.ClusterEvent;
import com.sun.enterprise.admin.event.ClusterEventListener;
import com.sun.enterprise.admin.event.ElementChangeEvent;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.ee.admin.mbeanapi.ServerRuntimeMBean;
import com.sun.enterprise.ee.admin.mbeans.GMSClientMBean;
import com.sun.enterprise.ee.admin.proxy.InstanceProxy;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedSignal;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureSuspectedActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMSClientMBeanHelper
implements ClusterEventListener,
CallBack {
    private Logger _logger;
    private int seqNum = 0;
    private static final StringManager _strMgr = StringManager.getManager(GMSClientMBean.class);
    private static final long JOINWAIT = 3000L;
    private final Map<String, Map<String, List<Long>>> healthMap = new Hashtable<String, Map<String, List<Long>>>();
    private GMSClientMBean mbean;
    private static final String HEARTBEAT_ENABLED_KEY = "heartbeat-enabled";
    private static final String HEARTBEAT_ADDRESS_KEY = "heartbeat-address";
    private static final String HEARTBEAT_PORT_KEY = "heartbeat-port";

    public GMSClientMBeanHelper(GMSClientMBean mbean) {
        this.mbean = mbean;
    }

    void initGMSGroupForNamedCluster(String clusterName) {
        try {
            if (GMSFactory.getGMSModule((String)clusterName) != null) {
                return;
            }
        }
        catch (GMSException e) {
            try {
                if (AdminService.getAdminService().isDas()) {
                    String dasInstanceName = ApplicationServer.getServerContext().getInstanceName();
                    ConfigContext configContext = this.getConfigContext();
                    Cluster cluster = this.getClusterObject(configContext, clusterName);
                    if (cluster != null && cluster.isHeartbeatEnabled()) {
                        this.getLogger().log(Level.INFO, _strMgr.getString("gms.initializing", (Object)clusterName));
                        GMSFactory.setGMSEnabledState((String)clusterName, (Boolean)Boolean.TRUE);
                        Properties props = this.getGMSConfigProps(cluster, configContext);
                        GroupManagementService gms = (GroupManagementService)GMSFactory.startGMSModule((String)dasInstanceName, (String)clusterName, (GroupManagementService.MemberType)GroupManagementService.MemberType.SPECTATOR, (Properties)props);
                        gms.addActionFactory((FailureNotificationActionFactory)new FailureNotificationActionFactoryImpl((CallBack)this));
                        gms.addActionFactory((JoinNotificationActionFactory)new JoinNotificationActionFactoryImpl((CallBack)this));
                        gms.addActionFactory((PlannedShutdownActionFactory)new PlannedShutdownActionFactoryImpl((CallBack)this));
                        gms.addActionFactory((FailureSuspectedActionFactory)new FailureSuspectedActionFactoryImpl((CallBack)this));
                        String threadName = "GroupManagementService_" + dasInstanceName + '_' + clusterName;
                        gms.join();
                        this.initHealthMap(gms.getGroupHandle().getCurrentCoreMembersWithStartTimes(), clusterName, cluster);
                    }
                }
            }
            catch (ConfigException ex) {
                this.getLogger().log(Level.WARNING, ex.getLocalizedMessage());
            }
            catch (GMSException e1) {
                this.getLogger().log(Level.SEVERE, "Exception occured while initializing Group Management Service." + (Object)((Object)e1));
            }
        }
    }

    private Cluster getClusterObject(ConfigContext configContext, String clusterName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName((ConfigContext)configContext, (String)clusterName);
        return cluster;
    }

    private ConfigContext getConfigContext() {
        return AdminService.getAdminService().getAdminContext().getAdminConfigContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHealthMap(List<String> currentCoreMembersWithStartTimes, String groupName, Cluster cluster) {
        Hashtable instanceMap = new Hashtable();
        ArrayList<Long> stateAndTime = new ArrayList<Long>();
        if (currentCoreMembersWithStartTimes.isEmpty()) {
            ServerRef[] servers = cluster.getServerRef();
            if (servers.length > 0) {
                for (ServerRef server : servers) {
                    stateAndTime.add(0, 3L);
                    instanceMap.put(server.getRef(), stateAndTime);
                }
            }
        } else {
            for (String member : currentCoreMembersWithStartTimes) {
                String[] split = member.split("::");
                stateAndTime.add(0, 0L);
                stateAndTime.add(1, new Long(split[1]));
                instanceMap.put(split[0], stateAndTime);
            }
        }
        Map<String, Map<String, List<Long>>> map = this.healthMap;
        synchronized (map) {
            this.healthMap.put(groupName, instanceMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshHealthMap(String clusterName) {
        Hashtable<String, List<Long>> currHltMap = new Hashtable<String, List<Long>>();
        Map<String, Map<String, List<Long>>> map = this.healthMap;
        synchronized (map) {
            currHltMap.putAll(this.healthMap.get(clusterName));
        }
        if (currHltMap.isEmpty()) {
            try {
                this.initHealthMap(new ArrayList<String>(), clusterName, this.getClusterObject(this.getConfigContext(), clusterName));
            }
            catch (ConfigException e) {
                this.getLogger().log(Level.WARNING, e.getLocalizedMessage());
            }
        } else {
            Set currMembers = currHltMap.keySet();
            try {
                ServerRef[] servers = this.getClusterObject(this.getConfigContext(), clusterName).getServerRef();
                if (servers.length > currMembers.size()) {
                    for (ServerRef s : servers) {
                        if (currMembers.contains(s.getRef())) continue;
                        this.updateHealthStatus(3L, clusterName, s.getRef(), -1L);
                    }
                } else if (servers.length < currMembers.size()) {
                    ArrayList<String> serverNames = new ArrayList<String>();
                    for (ServerRef s : servers) {
                        serverNames.add(s.getRef());
                    }
                    for (String s : currMembers) {
                        if (serverNames.contains(s)) continue;
                        this.updateHealthStatus(-1L, clusterName, s, -1L);
                    }
                }
            }
            catch (ConfigException e) {
                this.getLogger().log(Level.WARNING, e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateHealthStatus(long state, String groupName, String memberToken, long timestamp) {
        Map<String, Map<String, List<Long>>> map = this.healthMap;
        synchronized (map) {
            Map<String, List<Long>> instanceMap = this.healthMap.get(groupName);
            if (state < 0L) {
                instanceMap.remove(memberToken);
            } else {
                ArrayList<Long> status = new ArrayList<Long>();
                status.add(0, state);
                if (timestamp >= 0L) {
                    status.add(1, timestamp);
                }
                instanceMap.put(memberToken, status);
            }
            this.healthMap.put(groupName, instanceMap);
        }
    }

    private Logger getLogger() {
        if (this._logger == null) {
            this._logger = GMSLogDomain.getLogger((String)"ShoalLogger");
        }
        return this._logger;
    }

    void leaveGMSGroupForNamedCluster(String clusterName, GMSConstants.shutdownType shutdownType2) {
        try {
            GroupManagementService gms = GMSFactory.getGMSModule((String)clusterName);
            if (gms != null) {
                gms.shutdown(shutdownType2);
                GMSFactory.setGMSEnabledState((String)clusterName, (Boolean)Boolean.FALSE);
                GMSFactory.removeGMSModule((String)clusterName);
            }
        }
        catch (GMSException e) {
            this.getLogger().log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    private Properties getGMSConfigProps(Cluster cluster, ConfigContext configContext) {
        Properties props = new Properties();
        try {
            String configRef = cluster.getConfigRef();
            Config config = ConfigAPIHelper.getConfigByName((ConfigContext)configContext, (String)configRef);
            com.sun.enterprise.config.serverbeans.GroupManagementService gmsConfig = config.getGroupManagementService();
            props.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_RETRIES.toString(), gmsConfig.getFdProtocolMaxTries());
            props.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_TIMEOUT.toString(), gmsConfig.getFdProtocolTimeoutInMillis());
            props.put(ServiceProviderConfigurationKeys.DISCOVERY_TIMEOUT.toString(), gmsConfig.getPingProtocolTimeoutInMillis());
            props.put(ServiceProviderConfigurationKeys.FAILURE_VERIFICATION_TIMEOUT.toString(), gmsConfig.getVsProtocolTimeoutInMillis());
            props.put(ServiceProviderConfigurationKeys.MULTICASTADDRESS.toString(), cluster.getHeartbeatAddress());
            props.put(ServiceProviderConfigurationKeys.MULTICASTPORT.toString(), cluster.getHeartbeatPort());
        }
        catch (ConfigException e) {
            this.getLogger().log(Level.WARNING, e.getLocalizedMessage());
        }
        return props;
    }

    Map<String, List<Long>> getClusterHealth(String clusterName) {
        if (!this.healthMap.containsKey(clusterName)) {
            throw new RuntimeException(_strMgr.getString("gms.noSuchCluster", (Object)clusterName));
        }
        this.refreshHealthMap(clusterName);
        Hashtable<String, List<Long>> retval = new Hashtable<String, List<Long>>(this.healthMap.get(clusterName));
        return retval;
    }

    public synchronized void processNotification(Signal signal) {
        this.seqNum = this.seqNum++;
        if (signal instanceof JoinNotificationSignal) {
            this.updateHealthStatus(0L, signal.getGroupName(), signal.getMemberToken(), signal.getStartTime());
            this.mbean.sendStartNotification(signal.getMemberToken(), signal.getStartTime(), this.seqNum);
        } else if (signal instanceof PlannedShutdownSignal) {
            long time = System.currentTimeMillis();
            this.updateHealthStatus(1L, signal.getGroupName(), signal.getMemberToken(), time);
            this.mbean.sendStoppedNotification(signal.getMemberToken(), time, this.seqNum);
        } else if (signal instanceof FailureNotificationSignal) {
            long time = System.currentTimeMillis();
            this.updateHealthStatus(2L, signal.getGroupName(), signal.getMemberToken(), time);
            this.mbean.sendFailureNotification(signal.getMemberToken(), time, this.seqNum);
        } else if (signal instanceof FailureSuspectedSignal) {
            long time = System.currentTimeMillis();
            this.updateHealthStatus(4L, signal.getGroupName(), signal.getMemberToken(), time);
        }
    }

    public void processEvent(ElementChangeEvent event) {
        this.getLogger().log(Level.INFO, "*** processEvent " + event.toString());
    }

    public void handleCreate(ClusterEvent event) {
        String clusterName = event.getElementId();
        this.initGMSGroupForNamedCluster(clusterName);
    }

    public void handleDelete(ClusterEvent event) {
        String clusterName = event.getElementId();
        this.leaveGMSGroupForNamedCluster(clusterName, GMSConstants.shutdownType.GROUP_SHUTDOWN);
    }

    public void handleUpdate(ClusterEvent event) {
        String clusterName = event.getElementId();
        ArrayList changeList = event.getConfigChangeList();
        for (ConfigChange change : changeList) {
            if (!(change instanceof ConfigUpdate)) continue;
            Set attrs = ((ConfigUpdate)change).getAttributeSet();
            for (String attr : attrs) {
                if (HEARTBEAT_ENABLED_KEY.equals(attr)) {
                    if (Boolean.valueOf(((ConfigUpdate)change).getNewValue(attr)).booleanValue()) {
                        this.initGMSGroupForNamedCluster(clusterName);
                        continue;
                    }
                    this.leaveGMSGroupForNamedCluster(clusterName, GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
                    continue;
                }
                if (!HEARTBEAT_ADDRESS_KEY.equals(attr) && !HEARTBEAT_PORT_KEY.equals(attr)) continue;
                this.leaveGMSGroupForNamedCluster(clusterName, GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
                this.initGMSGroupForNamedCluster(clusterName);
            }
            try {
                ServerRef[] refs;
                Cluster cluster = ClusterHelper.getClusterByName((ConfigContext)this.getConfigContext(), (String)clusterName);
                for (ServerRef ref : refs = cluster.getServerRef()) {
                    ServerRuntimeMBean runtimeMBean = InstanceProxy.getInstanceProxy(ref.getRef());
                    runtimeMBean.setRestartRequired(true);
                }
            }
            catch (ConfigException e) {
                this.getLogger().log(Level.WARNING, e.getLocalizedMessage());
            }
            catch (InstanceException e) {
                this.getLogger().log(Level.WARNING, e.getLocalizedMessage());
            }
            catch (MBeanException e) {
                this.getLogger().log(Level.WARNING, e.getLocalizedMessage());
            }
        }
    }
}

