/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.util.Vector;
import javax.enterprise.deploy.spi.TargetModuleID;

public class ListApplicationReferenceCommand
extends S1ASCommand {
    private final String DEFAULT_TARGET = "domain";
    private static final StringManager _strMgr = StringManager.getManager(ListApplicationReferenceCommand.class);

    public void runCommand() throws CommandException, CommandValidationException {
        TargetModuleID[] targetModuleIDs;
        block8: {
            this.validateOptions();
            CLILogger.getInstance().printDebugMessage("******************************************************");
            CLILogger.getInstance().printDebugMessage("Calling the class ListApplicationReferencesCommand.java");
            targetModuleIDs = null;
            ServerConnectionIdentifier conn = this.createServerConnectionIdentifier(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            try {
                DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
                df.connect(conn);
                String targetName = this.getTargetOperand();
                if (df.isConnected()) {
                    targetModuleIDs = df.listAppRefs(new String[]{targetName});
                    if (targetModuleIDs == null) {
                        throw new CommandException(_strMgr.getString("InvalidTarget", new Object[]{targetName}));
                    }
                    break block8;
                }
                throw new CommandException(this.getLocalizedString("CouldNotConnectToDAS"));
            }
            catch (IOException ioe) {
                CLILogger.getInstance().printDebugMessage("**** Caught the IOException ***");
                if (ioe.getLocalizedMessage() != null) {
                    CLILogger.getInstance().printDetailMessage(ioe.getLocalizedMessage());
                }
                throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), (Throwable)ioe);
            }
            catch (Exception e) {
                CLILogger.getInstance().printDebugMessage("**** Caught the Exception ***");
                if (e.getLocalizedMessage() != null) {
                    CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
                }
                throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
            }
        }
        for (int i = 0; i < targetModuleIDs.length; ++i) {
            CLILogger.getInstance().printMessage(targetModuleIDs[i].getModuleID());
        }
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        return true;
    }

    public String getTargetOperand() {
        Vector operandsList = this.getOperands();
        if (operandsList.size() == 0) {
            return "domain";
        }
        return (String)operandsList.get(0);
    }
}

