/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.lifecycle;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.ext.IiopInfo;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMSLifecycleImpl
extends ServerLifecycleImpl {
    private GroupManagementService gms;
    private String instanceName;
    private ServerContext serverContext;
    private final Logger logger = Logger.getLogger("javax.ee.enterprise.system.gms");
    private StandardMBean mbean;
    private static final String GmsClientName = new StringBuffer().append("com.sun.appserv").append(":type=GMSClientMBean,category=monitor").toString();
    private boolean isDASInstance = false;
    private boolean isGMSEnabled = true;
    private MBeanServer mbs = null;
    private final GMSConstants.shutdownType shutdownType = GMSConstants.shutdownType.INSTANCE_SHUTDOWN;

    public void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
        this.instanceName = serverContext.getInstanceName();
        this.serverContext = serverContext;
        String gmsClientMBeanName = "com.sun.enterprise.ee.admin.mbeans.GMSClientMBean";
        String gmsClientIntfName = "com.sun.enterprise.ee.admin.mbeans.GMSClient";
        String gmsClientListenerName = "com.sun.enterprise.ee.admin.clientreg.RegistrySynchronizer";
        String gmsClientStdMBeanName = "com.sun.enterprise.ee.admin.mbeans.GMSClientStandardMBean";
        try {
            if (!AdminService.getAdminService().isDas()) {
                this.initializeGMSForThisInstance(serverContext);
            } else {
                this.isDASInstance = true;
                Object gcm = Class.forName("com.sun.enterprise.ee.admin.mbeans.GMSClientMBean").newInstance();
                Object[] initargs = new Object[]{gcm, Class.forName("com.sun.enterprise.ee.admin.mbeans.GMSClient")};
                Class<?> gcsmClass = Class.forName("com.sun.enterprise.ee.admin.mbeans.GMSClientStandardMBean");
                Constructor<?>[] gcsmConstructors = gcsmClass.getConstructors();
                Constructor<?> gcsmConstructor = gcsmConstructors[0];
                this.mbean = (StandardMBean)gcsmConstructor.newInstance(initargs);
                this.mbs = MBeanServerFactory.getMBeanServer();
                ObjectName gmsClientMBeanObjName = new ObjectName(GmsClientName);
                this.mbs.registerMBean(this.mbean, gmsClientMBeanObjName);
                NotificationListener gmsClientListener = (NotificationListener)Class.forName("com.sun.enterprise.ee.admin.clientreg.RegistrySynchronizer").newInstance();
                this.mbs.addNotificationListener(gmsClientMBeanObjName, gmsClientListener, null, null);
                this.mbs.invoke(new ObjectName(GmsClientName), "initGMSGroupForAllClusters", new Object[0], new String[0]);
            }
            String GMS_EVENT_FACTORY_CLASS = "com.sun.enterprise.ee.selfmanagement.events.GMSEventFactory";
            try {
                Class<?> c = Class.forName("com.sun.enterprise.ee.selfmanagement.events.GMSEventFactory");
            }
            catch (Exception ex) {
                this.logger.log(Level.FINE, "No class found: com.sun.enterprise.ee.selfmanagement.events.GMSEventFactory", ex);
            }
        }
        catch (ConfigException e) {
            this.logger.log(Level.FINEST, ((Object)((Object)e)).getClass().getName() + ':' + "GroupManagementService will initialize only for" + "clustered instances:" + e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
        catch (InstantiationException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
        catch (NotCompliantMBeanException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
        catch (MBeanRegistrationException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
        catch (MalformedObjectNameException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
        catch (ReflectionException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
        catch (InstanceNotFoundException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
        catch (MBeanException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
        catch (InvocationTargetException e) {
            this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
        }
    }

    public void onStartup(ServerContext serverContext) throws ServerLifecycleException {
    }

    private void initializeGMSForThisInstance(ServerContext serverContext) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterForInstance((ConfigContext)serverContext.getConfigContext(), (String)this.instanceName);
        if (cluster != null && cluster.isHeartbeatEnabled()) {
            try {
                Class<?> gmsFactory = Class.forName("com.sun.enterprise.ee.cms.core.GMSFactory");
                this.logger.log(Level.INFO, "Initializing and Starting GroupManagementService");
                String clusterName = cluster.getName();
                GMSFactory.setGMSEnabledState((String)clusterName, (Boolean)Boolean.TRUE);
                Properties props = this.getGMSConfigProps(cluster, serverContext.getConfigContext());
                this.gms = (GroupManagementService)GMSFactory.startGMSModule((String)this.instanceName, (String)clusterName, (GroupManagementService.MemberType)GroupManagementService.MemberType.CORE, (Properties)props);
                this.gms.join();
                this.addMemberDetails(this.instanceName, serverContext.getConfigContext());
            }
            catch (ClassNotFoundException e) {
                this.isGMSEnabled = false;
                this.logger.log(Level.WARNING, "GroupManagementService classes are not available in the classpath." + e.getLocalizedMessage() + ". Continuing startup without GroupManagementServices enabled.");
            }
            catch (GMSException e) {
                this.logger.log(Level.WARNING, "Exception Occured in GMS Initialization:" + (Object)((Object)e));
            }
        }
    }

    private Properties getGMSConfigProps(Cluster cluster, ConfigContext configContext) {
        Properties props = new Properties();
        try {
            String configRef = cluster.getConfigRef();
            Config config = ConfigAPIHelper.getConfigByName((ConfigContext)configContext, (String)configRef);
            com.sun.enterprise.config.serverbeans.GroupManagementService gmsConfig = config.getGroupManagementService();
            props.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_RETRIES.toString(), gmsConfig.getFdProtocolMaxTries());
            props.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_TIMEOUT.toString(), gmsConfig.getFdProtocolTimeoutInMillis());
            props.put(ServiceProviderConfigurationKeys.DISCOVERY_TIMEOUT.toString(), gmsConfig.getPingProtocolTimeoutInMillis());
            props.put(ServiceProviderConfigurationKeys.FAILURE_VERIFICATION_TIMEOUT.toString(), gmsConfig.getVsProtocolTimeoutInMillis());
            props.put(ServiceProviderConfigurationKeys.MULTICASTADDRESS.toString(), cluster.getHeartbeatAddress());
            props.put(ServiceProviderConfigurationKeys.MULTICASTPORT.toString(), cluster.getHeartbeatPort());
        }
        catch (ConfigException e) {
            this.logger.log(Level.WARNING, e.getLocalizedMessage());
        }
        return props;
    }

    private void addMemberDetails(String instanceName, ConfigContext configContext) {
        try {
            this.addIIOPEndPoints(instanceName, configContext);
        }
        catch (GMSException e) {
            this.logger.log(Level.WARNING, e.getLocalizedMessage());
        }
        catch (ConfigException e) {
            this.logger.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    private void addIIOPEndPoints(String instanceName, ConfigContext configContext) throws ConfigException, GMSException {
        Map<String, IiopListener[]> lsnrMap = this.getResolvedIiopListenersInCluster(true, configContext, instanceName);
        if (!lsnrMap.isEmpty()) {
            for (String instance : lsnrMap.keySet()) {
                ArrayList<IiopInfo> infoList = new ArrayList<IiopInfo>();
                IiopListener[] listeners = lsnrMap.get(instance);
                Server server = ServerHelper.getServerByName((ConfigContext)configContext, (String)instance);
                for (IiopListener listener : listeners) {
                    IiopInfo iiopInfo = this.getIiopInfo(listener);
                    iiopInfo.setWeight(Integer.parseInt(server.getLbWeight()));
                    try {
                        String nodeAgentHostName = this.getNodeAgentHostName(configContext, server);
                        iiopInfo.setHostName(nodeAgentHostName);
                    }
                    catch (ConfigException configEx) {
                        this.logger.log(Level.WARNING, configEx.getMessage());
                    }
                    infoList.add(iiopInfo);
                }
                this.gms.updateMemberDetails(instance, (Serializable)((Object)"IIOPListenerEndPoints"), (Serializable)infoList);
            }
        }
    }

    private Map<String, IiopListener[]> getResolvedIiopListenersInCluster(boolean includeMe, ConfigContext configContext, String instanceName) throws ConfigException {
        HashMap<String, IiopListener[]> map = new HashMap<String, IiopListener[]>();
        if (ServerHelper.isServerClustered((ConfigContext)configContext, (String)instanceName)) {
            Server[] buddies;
            String myCluster = ClusterHelper.getClusterForInstance((ConfigContext)configContext, (String)instanceName).getName();
            for (Server as : buddies = ServerHelper.getServersInCluster((ConfigContext)configContext, (String)myCluster)) {
                if (!includeMe && instanceName.equals(as.getName())) continue;
                IiopListener[] ls = this.getResolvedIiopListenersInServer(as, configContext);
                map.put(as.getName(), ls);
            }
        }
        return map;
    }

    private IiopListener[] getResolvedIiopListenersInServer(Server server, ConfigContext configContext) throws ConfigException {
        Config cfg = ServerHelper.getConfigForServer((ConfigContext)configContext, (String)server.getName());
        IiopService iiop = cfg.getIiopService();
        IiopListener[] lsnrs = iiop.getIiopListener();
        IiopListener[] values = new IiopListener[lsnrs.length];
        int i = 0;
        for (IiopListener lsnr : lsnrs) {
            IiopListener copy = new IiopListener();
            String resolved = this.resolve(server.getName(), SystemPropertyConstants.unSystemProperty((String)lsnr.getRawAttributeValue("id")), configContext);
            copy.setId(resolved);
            resolved = this.resolve(server.getName(), SystemPropertyConstants.unSystemProperty((String)lsnr.getRawAttributeValue("port")), configContext);
            copy.setPort(resolved);
            resolved = this.resolve(server.getName(), SystemPropertyConstants.unSystemProperty((String)lsnr.getRawAttributeValue("address")), configContext);
            copy.setAddress(resolved);
            this.logger.fine("Iiop Service Endpoint for Server: " + server.getName() + ", iiop-lsnr-id = " + copy.getId() + ", iiop-lsnr-port = " + copy.getPort() + ", iiop-lsnr-address = " + copy.getAddress());
            values[i++] = copy;
        }
        return values;
    }

    private String resolve(String server, String value, ConfigContext configContext) throws ConfigException {
        PropertyResolver pr = new PropertyResolver(configContext, server);
        String resolved = pr.getPropertyValue(value, true);
        if (resolved == null) {
            resolved = value;
        }
        return resolved;
    }

    private String getNodeAgentHostName(ConfigContext configContext, Server server) throws ConfigException {
        NodeAgent na = NodeAgentHelper.getNodeAgentForServer((ConfigContext)configContext, (String)server.getName());
        boolean dasShookHandsWithNodeAgent = NodeAgentHelper.hasNodeAgentRendezvousd((ConfigContext)configContext, (NodeAgent)na);
        if (!dasShookHandsWithNodeAgent) {
            throw new ConfigException("Error: NA: " + na.getName() + " has not rendezvous'ed with DAS");
        }
        String naHost = NodeAgentHelper.getNodeAgentSystemConnector((ConfigContext)configContext, (String)na.getName()).getElementPropertyByName("client-hostname").getValue();
        return naHost;
    }

    private IiopInfo getIiopInfo(IiopListener il) {
        IiopInfo info = new IiopInfo();
        String address = il.getAddress();
        String port = il.getPort();
        String id = il.getId();
        info.setAddress(address);
        info.setPort(port);
        info.setID(id);
        return info;
    }

    public void onReady(ServerContext serverContext) throws ServerLifecycleException {
    }

    public void onShutdown() throws ServerLifecycleException {
        if (this.isDASInstance) {
            if (this.mbs != null) {
                try {
                    this.mbs.invoke(new ObjectName(GmsClientName), "leaveGMSGroupForAllClusters", new Object[]{this.shutdownType}, new String[]{GMSConstants.shutdownType.class.getName()});
                }
                catch (InstanceNotFoundException e) {
                    this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
                }
                catch (MBeanException e) {
                    this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
                }
                catch (ReflectionException e) {
                    this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
                }
                catch (MalformedObjectNameException e) {
                    this.logger.log(Level.WARNING, e.getClass().getName() + ':' + e.getLocalizedMessage());
                }
            }
        } else if (this.isGMSEnabled && this.gms != null) {
            this.gms.shutdown(this.shutdownType);
        }
    }

    public void onTermination() throws ServerLifecycleException {
    }
}

