/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.appserv.management.util.misc.RunnableBase;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ShutdownEvent;
import com.sun.enterprise.admin.event.ShutdownEventListener;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.admin.servermgmt.NodeAgentPropertyReader;
import com.sun.enterprise.ee.nodeagent.NodeAgent;
import com.sun.enterprise.ee.nodeagent.Shutdown;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.util.ASenvPropertyReader;
import com.sun.enterprise.util.FeatureAvailability;
import com.sun.enterprise.util.JvmInfoUtil;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class NodeAgentMain {
    private static final StringManager _strMgr = StringManager.getManager(NodeAgentMain.class);
    private static AgentConfig _config = null;
    private static Logger _logger = null;
    private static volatile boolean bDebug = Boolean.getBoolean("Debug");

    private static void usage() {
        System.out.println("usage: NodeAgentMain start|stop");
    }

    private static synchronized AgentConfig getConfig() {
        if (_config == null) {
            _config = new AgentConfig();
        }
        return _config;
    }

    static synchronized Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.nodeagent", "com.sun.logging.ee.enterprise.system.nodeagent.LogStrings");
            if (bDebug) {
                _logger.setLevel(Level.FINEST);
            } else {
                _logger.setLevel(Level.CONFIG);
            }
        }
        return _logger;
    }

    private static void shutdown() {
        try {
            NodeAgentMain.getLogger().log(Level.INFO, "nodeAgent.sending-stop");
            String agentName = NodeAgentMain.getConfig().getRepositoryName();
            RMIClient rmiClient = AdminChannel.getRMIClient((String)agentName);
            ShutdownEvent shutdownEvent = new ShutdownEvent(agentName);
            AdminEventResult adminEventResult = rmiClient.sendNotification((AdminEvent)shutdownEvent);
        }
        catch (Exception ex) {
            NodeAgentMain.getLogger().log(Level.WARNING, "nodeAgent.exception", ex);
            System.exit(1);
        }
    }

    private static void startup(String startInstancesOverride, boolean syncInstancesOverride) throws ServerLifecycleException {
        try {
            IdentityManager.populateFromInputStreamQuietly();
        }
        catch (IOException e) {
            NodeAgentMain.getLogger().log(Level.WARNING, "nodeagent.failureOnReadingSecurityIdentity", e);
        }
        NodeAgentMain.getLogger().log(Level.INFO, IdentityManager.getFormatedContents());
        AdminChannel.createRMIChannel();
        AdminChannel.createSharedSecret();
        NodeAgentMain.publishPID();
        System.out.println(_strMgr.getString("nodeAgent.redirecting.output", (Object)(System.getProperty("com.sun.aas.instanceRoot") + "/logs/server.log")));
        NodeAgentMain.getLogger().log(Level.INFO, "nodeagent.starting.agent");
        DASPropertyReader dasReader = new DASPropertyReader(new AgentConfig());
        try {
            dasReader.read();
            if (dasReader.getPort() != null) {
                NodeAgentMain.getLogger().log(Level.CONFIG, "DAS url = " + dasReader.getJMXURL());
            }
        }
        catch (Exception e) {
            NodeAgentMain.getLogger().log(Level.INFO, "nodeAgent.das_properties_not_found", e);
        }
        NodeAgentPropertyReader nodeAgentReader = new NodeAgentPropertyReader(new AgentConfig());
        try {
            nodeAgentReader.read();
            if (!nodeAgentReader.isBound()) {
                NodeAgentMain.getLogger().log(Level.CONFIG, "NodeAgent url  = " + nodeAgentReader.getJMXURL());
            }
        }
        catch (Exception e) {
            NodeAgentMain.getLogger().log(Level.SEVERE, "nodeAgent.nodeagent_properties_not_found", e);
            System.exit(1);
        }
        try {
            NodeAgent nas = new NodeAgent(dasReader, nodeAgentReader);
            AdminEventListenerRegistry.addShutdownEventListener((ShutdownEventListener)new Shutdown(nas));
            nas.run(startInstancesOverride, syncInstancesOverride);
            AdminChannel.setRMIChannelReady();
        }
        catch (Exception e) {
            throw new ServerLifecycleException((Throwable)e);
        }
    }

    public static void main(String[] args) {
        new LoadMBeanServer().submit(RunnableBase.HowToRun.RUN_IN_SEPARATE_THREAD);
        try {
            if (System.getProperty("Debug") != null) {
                bDebug = true;
            }
            ASenvPropertyReader propertyReader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"));
            propertyReader.setSystemProperties();
            if (args == null || args.length < 1) {
                NodeAgentMain.usage();
                System.exit(1);
            } else if (args[0].equals("stop")) {
                NodeAgentMain.shutdown();
                System.exit(0);
            } else if (args[0].equals("start")) {
                String startInstancesOverride = null;
                boolean syncInstances = false;
                for (int ii = 0; ii < args.length; ++ii) {
                    String syncInstancesOverride;
                    if (args[ii].startsWith(" startInstancesOverride")) {
                        startInstancesOverride = args[ii].substring(args[ii].indexOf("=") + 1);
                    }
                    if (!args[ii].startsWith("syncInstances") || !"true".equalsIgnoreCase(syncInstancesOverride = args[ii].substring(args[ii].indexOf("=") + 1))) continue;
                    syncInstances = true;
                }
                NodeAgentMain.startup(startInstancesOverride, syncInstances);
            } else {
                NodeAgentMain.usage();
                System.exit(1);
            }
        }
        catch (Throwable ex) {
            NodeAgentMain.getLogger().log(Level.SEVERE, "nodeAgent.exception", ex);
            System.exit(1);
        }
    }

    private static void publishPID() {
        JvmInfoUtil jvminfo = new JvmInfoUtil();
        String pidFileName = System.getProperty("com.sun.aas.instanceRoot") + "/config/";
        pidFileName = pidFileName + ".__com_sun_appserv_pid";
        jvminfo.logPID(pidFileName);
    }

    private static final class LoadMBeanServer
    extends RunnableBase {
        LoadMBeanServer() {
            super("NodeAgentMain-LoadMBeanServer");
        }

        protected void doRun() {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            FeatureAvailability.getInstance().registerFeature("MBeanServer", (Object)mbeanServer);
            if (bDebug) {
                System.out.println("class of platform MBeanServer is " + mbeanServer.getClass().getName());
            }
        }
    }
}

