/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.HealthChecker;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.ee.selfmanagement.actions.CheckServerHealth;
import com.sun.enterprise.ee.selfmanagement.actions.Instance;
import com.sun.enterprise.ee.selfmanagement.actions.InstanceHangActionMBean;
import com.sun.enterprise.ee.selfmanagement.actions.RestartInstance;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class InstanceHangAction
implements InstanceHangActionMBean,
MBeanRegistration,
NotificationListener {
    static final ConfigContext configCtx = ApplicationServer.getServerContext().getConfigContext();
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.selfmanagement");
    private static final StringManager localStrings = StringManager.getManager(InstanceHangAction.class);
    private static String msgPrefix = null;
    public String checkList = null;
    public int timeoutInSeconds = 0;
    private MBeanServer mbeanServer = null;
    private final long DEFAULT_HC_TIMEOUT_ = 10L;
    public boolean isRestart = false;
    public String alertRef = null;
    private ArrayList<Instance> instanceList = null;
    private HashMap<String, Vector<Instance>> instMap = null;

    public InstanceHangAction() {
        AdminService as = AdminService.getAdminService();
        if (!as.isDas()) {
            String errMsg = localStrings.getString("instancehang.notDAS");
            _logger.log(Level.SEVERE, "sgmt.instancehangaction_notDAS");
            throw new RuntimeException(errMsg);
        }
        this.instanceList = new ArrayList();
        this.instMap = new HashMap();
    }

    void addToCheck(String name) {
        try {
            boolean isServer = ServerHelper.isAServer((ConfigContext)configCtx, (String)name);
            if (isServer) {
                Server instance = ServerHelper.getServerByName((ConfigContext)configCtx, (String)name);
                Instance inst = new Instance(instance);
                this.instanceList.add(inst);
                Vector<Instance> instanceCol = new Vector<Instance>();
                instanceCol.add(inst);
                this.instMap.put(name, instanceCol);
            } else if (ClusterHelper.isACluster((ConfigContext)configCtx, (String)name)) {
                Server[] servers = ServerHelper.getServersInCluster((ConfigContext)configCtx, (String)name);
                Vector<Instance> instanceCol = new Vector<Instance>(servers.length);
                for (Server server : servers) {
                    Instance inst = new Instance(server, name);
                    this.instanceList.add(inst);
                    instanceCol.add(inst);
                }
                this.instMap.put(name, instanceCol);
            } else {
                _logger.log(Level.WARNING, "sgmt.instancehang_invalidname", name);
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public void setChecklist(String val) {
        String[] list;
        this.checkList = val;
        for (String name : list = this.checkList.split(",")) {
            this.addToCheck(name);
        }
    }

    public String getChecklist() {
        return this.checkList;
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public synchronized void setTimeoutInSeconds(int value) {
        this.timeoutInSeconds = value;
    }

    public ObjectName preRegister(MBeanServer mbs, ObjectName objName) throws Exception {
        this.mbeanServer = mbs;
        return objName;
    }

    public void postRegister(Boolean isRegistrationDone) {
    }

    void validateTimeout() {
        try {
            Set<String> names = this.instMap.keySet();
            Set lbs = ServerBeansFactory.getLbConfigs((ConfigContext)configCtx);
            for (String name : names) {
                LbConfig lb;
                if (ServerHelper.isAServer((ConfigContext)configCtx, (String)name)) {
                    LbConfig lb2;
                    ServerRef ref = null;
                    Vector<Instance> col = this.instMap.get(name);
                    Instance instance = col.firstElement();
                    Iterator<Object> i$ = lbs.iterator();
                    while (i$.hasNext() && (ref = (lb2 = (LbConfig)i$.next()).getServerRefByRef(name)) == null) {
                    }
                    if (ref != null) {
                        HealthChecker hc = ref.getHealthChecker();
                        if (hc != null) {
                            String val = hc.getTimeoutInSeconds();
                            int hcTimeout = Integer.parseInt(val);
                            if (this.timeoutInSeconds >= hcTimeout) {
                                instance.setTimeout(this.timeoutInSeconds);
                                continue;
                            }
                            instance.setTimeout(hcTimeout);
                            _logger.log(Level.INFO, "sgmt.instancehang_hctimeout", new Object[]{name, this.timeoutInSeconds, val});
                            continue;
                        }
                        instance.setTimeout(this.timeoutInSeconds);
                        continue;
                    }
                    instance.setTimeout(this.timeoutInSeconds);
                    continue;
                }
                Vector<Instance> col = this.instMap.get(name);
                ClusterRef ref = null;
                Iterator<Object> i$ = lbs.iterator();
                while (i$.hasNext() && (ref = (lb = (LbConfig)i$.next()).getClusterRefByRef(name)) == null) {
                }
                if (ref != null) {
                    HealthChecker hc = ref.getHealthChecker();
                    if (hc != null) {
                        String val = hc.getTimeoutInSeconds();
                        int hcTimeout = Integer.parseInt(val);
                        if (this.timeoutInSeconds >= hcTimeout) {
                            for (Instance instance : col) {
                                instance.setTimeout(this.timeoutInSeconds);
                            }
                            continue;
                        }
                        for (Instance instance : col) {
                            instance.setTimeout(hcTimeout);
                        }
                        _logger.log(Level.INFO, "sgmt.instancehang_hccltimeout", new Object[]{name, this.timeoutInSeconds, val});
                        continue;
                    }
                    for (Instance instance : col) {
                        instance.setTimeout(this.timeoutInSeconds);
                    }
                    continue;
                }
                for (Instance instance : col) {
                    instance.setTimeout(this.timeoutInSeconds);
                }
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public synchronized void handleNotification(Notification notif, Object notifObj) {
        boolean potentialCount = false;
        ArrayList tasks = new ArrayList();
        try {
            if (this.instanceList.size() != 0) {
                this.validateTimeout();
                ExecutorService exSrv = Executors.newFixedThreadPool(this.instanceList.size());
                for (Instance instance : this.instanceList) {
                    CheckServerHealth server = new CheckServerHealth(instance);
                    Future<?> task = exSrv.submit(server);
                    tasks.add(task);
                    if (instance.getClusterName() != null) {
                        _logger.log(Level.INFO, "sgmt.instancehang_clinstcheckstart", new Object[]{instance.getServer().getName(), instance.getClusterName()});
                        continue;
                    }
                    _logger.log(Level.INFO, "sgmt.instancehang_instcheckstart", instance.getServer().getName());
                }
                for (Future future : tasks) {
                    future.get();
                }
                if (this.isRestart) {
                    tasks.clear();
                    for (Instance instance : this.instanceList) {
                        if (instance.isHealthy()) continue;
                        Future<?> task = exSrv.submit(new RestartInstance(instance, this.mbeanServer));
                        tasks.add(task);
                    }
                    for (Future future : tasks) {
                        future.get();
                    }
                }
                _logger.log(Level.INFO, "sgmt.instancehang_complete");
            } else {
                _logger.log(Level.INFO, "sgmt.instancehang_noinstance");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public synchronized void setRestart(boolean restart) {
        this.isRestart = restart;
    }

    public boolean getRestart() {
        return this.isRestart;
    }

    public void preDeregister() {
    }

    public void postDeregister() {
    }
}

