/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.events;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.ee.cms.core.Action;
import com.sun.enterprise.ee.cms.core.ActionException;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.PlannedShutdownAction;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.selfmanagement.events.GMSEventProxy;
import com.sun.enterprise.server.ApplicationServer;

public class GMSStopEvent
implements PlannedShutdownActionFactory,
PlannedShutdownAction {
    private static volatile GMSStopEvent _instance = null;
    private final GMSEventProxy proxy;

    private GMSStopEvent(GMSEventProxy proxy) {
        this.proxy = proxy;
    }

    static synchronized GMSStopEvent getInstance(GMSEventProxy proxy) {
        if (_instance != null) {
            return _instance;
        }
        _instance = new GMSStopEvent(proxy);
        String currentServer = ApplicationServer.getServerContext().getInstanceName();
        ConfigContext context = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        if (AdminService.getAdminService().isDas()) {
            try {
                Cluster[] clusters = ClusterHelper.getClustersInDomain((ConfigContext)context);
                for (int i = 0; i < clusters.length; ++i) {
                    String clusterName = clusters[i].getName();
                    if (clusterName == null) continue;
                    GroupManagementService gms = GMSFactory.getGMSModule((String)clusterName);
                    gms.addActionFactory((PlannedShutdownActionFactory)_instance);
                }
            }
            catch (ConfigException ex) {
            }
            catch (GMSException ex) {}
        } else {
            try {
                String clusterName;
                if (currentServer != null && (clusterName = ClusterHelper.getClusterForInstance((ConfigContext)context, (String)currentServer).getName()) != null) {
                    GroupManagementService gms = GMSFactory.getGMSModule((String)clusterName);
                    gms.addActionFactory((PlannedShutdownActionFactory)_instance);
                }
            }
            catch (ConfigException ex) {
            }
            catch (GMSException gMSException) {
                // empty catch block
            }
        }
        return _instance;
    }

    public void consumeSignal(Signal s) throws ActionException {
        String memberToken = s.getMemberToken();
        if (this.proxy != null) {
            this.proxy.eventOccurred(memberToken, "cluster.stop");
        }
    }

    public Action produceAction() {
        return _instance;
    }
}

