/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.ee.synchronization.AppclientModuleRequestBuilder;
import com.sun.enterprise.ee.synchronization.ApplicationRequestBuilder;
import com.sun.enterprise.ee.synchronization.ApplicationSynchRequest;
import com.sun.enterprise.ee.synchronization.ConnectorModuleRequestBuilder;
import com.sun.enterprise.ee.synchronization.EjbModuleRequestBuilder;
import com.sun.enterprise.ee.synchronization.LifecycleModuleRequestBuilder;
import com.sun.enterprise.ee.synchronization.WebModuleRequestBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerDirector {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private String _serverName = null;
    private ConfigContext _configCtx = null;
    private ArrayList _requests = new ArrayList();
    private ArrayList _excludes = new ArrayList();
    private ArrayList _includes = new ArrayList();

    public ServerDirector(ConfigContext ctx, String serverName) {
        this._configCtx = ctx;
        this._serverName = serverName;
    }

    public List constructIncludes() {
        this.buildJ2EEApplicationIncludes();
        this.buildEJBModuleIncludes();
        this.buildWebModuleIncludes();
        this.buildConnectorModuleIncludes();
        this.buildAppclientModuleIncludes();
        this.buildLifecycleModuleIncludes();
        return this._includes;
    }

    public List constructExcludes() {
        this.buildJ2EEApplicationExcludes();
        this.buildEJBModuleExcludes();
        this.buildWebModuleExcludes();
        this.buildConnectorModuleExcludes();
        this.buildAppclientModuleExcludes();
        this.buildLifecycleModuleExcludes();
        return this._excludes;
    }

    public List construct() {
        this.buildJ2EEApplications();
        this.buildEJBModules();
        this.buildWebModules();
        this.buildConnectorModules();
        this.buildAppclientModules();
        this.buildLifecycleModules();
        return this._requests;
    }

    private void buildJ2EEApplicationExcludes() {
        J2eeApplication[] j2eeApps = null;
        try {
            j2eeApps = ServerHelper.getUnAssociatedJ2eeApplications((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_apps", this._serverName);
        }
        this._excludes.addAll(this.getJ2EEApplicationDirs(j2eeApps));
    }

    private void buildJ2EEApplicationIncludes() {
        J2eeApplication[] j2eeApps = null;
        try {
            j2eeApps = ServerHelper.getAssociatedJ2eeApplications((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_apps", this._serverName);
        }
        this._includes.addAll(this.getJ2EEApplicationDirs(j2eeApps));
    }

    private List getJ2EEApplicationDirs(J2eeApplication[] j2eeApps) {
        ArrayList list = new ArrayList();
        if (j2eeApps != null) {
            ApplicationRequestBuilder aBuilder = new ApplicationRequestBuilder(this._configCtx, this._serverName);
            for (int i = 0; i < j2eeApps.length; ++i) {
                list.addAll(aBuilder.getAllDirectories((ConfigBean)j2eeApps[i]));
            }
        }
        return list;
    }

    private void buildJ2EEApplications() {
        J2eeApplication[] j2eeApps = null;
        try {
            j2eeApps = ServerHelper.getAssociatedJ2eeApplications((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_apps", this._serverName);
        }
        if (j2eeApps != null) {
            for (int i = 0; i < j2eeApps.length; ++i) {
                ApplicationRequestBuilder aBuilder = new ApplicationRequestBuilder(this._configCtx, this._serverName);
                ApplicationSynchRequest asr = aBuilder.build(j2eeApps[i]);
                this._requests.add(asr);
            }
        }
    }

    private void buildEJBModuleExcludes() {
        EjbModule[] ejbMods = null;
        try {
            ejbMods = ServerHelper.getUnAssociatedEjbModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_ejbs", this._serverName);
        }
        this._excludes.addAll(this.getEJBModuleDirs(ejbMods));
    }

    private void buildEJBModuleIncludes() {
        EjbModule[] ejbMods = null;
        try {
            ejbMods = ServerHelper.getAssociatedEjbModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_ejbs", this._serverName);
        }
        this._includes.addAll(this.getEJBModuleDirs(ejbMods));
    }

    private List getEJBModuleDirs(EjbModule[] ejbMods) {
        ArrayList list = new ArrayList();
        if (ejbMods != null) {
            EjbModuleRequestBuilder eBuilder = new EjbModuleRequestBuilder(this._configCtx, this._serverName);
            for (int i = 0; i < ejbMods.length; ++i) {
                list.addAll(eBuilder.getAllDirectories((ConfigBean)ejbMods[i]));
            }
        }
        return list;
    }

    private void buildEJBModules() {
        EjbModule[] ejbMods = null;
        try {
            ejbMods = ServerHelper.getAssociatedEjbModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_ejbs", this._serverName);
        }
        if (ejbMods != null) {
            for (int i = 0; i < ejbMods.length; ++i) {
                EjbModuleRequestBuilder eBuilder = new EjbModuleRequestBuilder(this._configCtx, this._serverName);
                ApplicationSynchRequest asr = eBuilder.build(ejbMods[i]);
                this._requests.add(asr);
            }
        }
    }

    private void buildWebModuleExcludes() {
        WebModule[] webMods = null;
        try {
            webMods = ServerHelper.getUnAssociatedWebModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_web", this._serverName);
        }
        this._excludes.addAll(this.getWebModuleDirs(webMods));
    }

    private void buildWebModuleIncludes() {
        WebModule[] webMods = null;
        try {
            webMods = ServerHelper.getAssociatedWebModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_web", this._serverName);
        }
        this._includes.addAll(this.getWebModuleDirs(webMods));
    }

    private List getWebModuleDirs(WebModule[] webMods) {
        ArrayList list = new ArrayList();
        if (webMods != null) {
            WebModuleRequestBuilder wBuilder = new WebModuleRequestBuilder(this._configCtx, this._serverName);
            for (int i = 0; i < webMods.length; ++i) {
                list.addAll(wBuilder.getAllDirectories((ConfigBean)webMods[i]));
            }
        }
        return list;
    }

    private void buildWebModules() {
        WebModule[] webMods = null;
        try {
            webMods = ServerHelper.getAssociatedWebModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_web", this._serverName);
        }
        if (webMods != null) {
            for (int i = 0; i < webMods.length; ++i) {
                WebModuleRequestBuilder wBuilder = new WebModuleRequestBuilder(this._configCtx, this._serverName);
                ApplicationSynchRequest asr = wBuilder.build(webMods[i]);
                this._requests.add(asr);
            }
        }
    }

    private void buildAppclientModuleExcludes() {
        AppclientModule[] appclientMods = null;
        try {
            appclientMods = ServerHelper.getUnAssociatedAppclientModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_appclient", this._serverName);
        }
        this._excludes.addAll(this.getAppclientModuleDirs(appclientMods));
    }

    private void buildAppclientModuleIncludes() {
        AppclientModule[] appclientMods = null;
        try {
            appclientMods = ServerHelper.getAssociatedAppclientModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_appclient", this._serverName);
        }
        this._includes.addAll(this.getAppclientModuleDirs(appclientMods));
    }

    private List getAppclientModuleDirs(AppclientModule[] appclientMods) {
        ArrayList list = new ArrayList();
        if (appclientMods != null) {
            AppclientModuleRequestBuilder acBuilder = new AppclientModuleRequestBuilder(this._configCtx, this._serverName);
            for (int i = 0; i < appclientMods.length; ++i) {
                list.addAll(acBuilder.getAllDirectories((ConfigBean)appclientMods[i]));
            }
        }
        return list;
    }

    private void buildAppclientModules() {
        AppclientModule[] acMods = null;
        try {
            acMods = ServerHelper.getAssociatedAppclientModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_appclient", this._serverName);
        }
        if (acMods != null) {
            for (int i = 0; i < acMods.length; ++i) {
                AppclientModuleRequestBuilder acBuilder = new AppclientModuleRequestBuilder(this._configCtx, this._serverName);
                ApplicationSynchRequest asr = acBuilder.build(acMods[i]);
                this._requests.add(asr);
            }
        }
    }

    private void buildConnectorModuleExcludes() {
        ConnectorModule[] connectorMods = null;
        try {
            connectorMods = ServerHelper.getUnAssociatedConnectorModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_connector", this._serverName);
        }
        this._excludes.addAll(this.getConnectorModuleDirs(connectorMods));
    }

    private void buildConnectorModuleIncludes() {
        ConnectorModule[] connectorMods = null;
        try {
            connectorMods = ServerHelper.getAssociatedConnectorModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_connector", this._serverName);
        }
        this._includes.addAll(this.getConnectorModuleDirs(connectorMods));
    }

    private List getConnectorModuleDirs(ConnectorModule[] connectorMods) {
        ArrayList list = new ArrayList();
        if (connectorMods != null) {
            ConnectorModuleRequestBuilder cBuilder = new ConnectorModuleRequestBuilder(this._configCtx, this._serverName);
            for (int i = 0; i < connectorMods.length; ++i) {
                list.addAll(cBuilder.getAllDirectories((ConfigBean)connectorMods[i]));
            }
        }
        return list;
    }

    private void buildConnectorModules() {
        ConnectorModule[] connectorMods = null;
        try {
            connectorMods = ServerHelper.getAssociatedConnectorModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_connector", this._serverName);
        }
        if (connectorMods != null) {
            for (int i = 0; i < connectorMods.length; ++i) {
                ConnectorModuleRequestBuilder cBuilder = new ConnectorModuleRequestBuilder(this._configCtx, this._serverName);
                ApplicationSynchRequest asr = cBuilder.build(connectorMods[i]);
                this._requests.add(asr);
            }
        }
    }

    private void buildLifecycleModuleExcludes() {
        LifecycleModule[] lifecycleMods = null;
        try {
            lifecycleMods = ServerHelper.getUnAssociatedLifecycleModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_lifecycle", this._serverName);
        }
        this._excludes.addAll(this.getLifecycleModuleDirs(lifecycleMods));
    }

    private void buildLifecycleModuleIncludes() {
        LifecycleModule[] lifecycleMods = null;
        try {
            lifecycleMods = ServerHelper.getAssociatedLifecycleModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_lifecycle", this._serverName);
        }
        this._includes.addAll(this.getLifecycleModuleDirs(lifecycleMods));
    }

    private List getLifecycleModuleDirs(LifecycleModule[] lifecycleMods) {
        ArrayList list = new ArrayList();
        if (lifecycleMods != null) {
            LifecycleModuleRequestBuilder lBuilder = new LifecycleModuleRequestBuilder(this._configCtx, this._serverName);
            for (int i = 0; i < lifecycleMods.length; ++i) {
                list.addAll(lBuilder.getAllDirectories((ConfigBean)lifecycleMods[i]));
            }
        }
        return list;
    }

    private void buildLifecycleModules() {
        LifecycleModule[] lifecycleMods = null;
        try {
            lifecycleMods = ServerHelper.getAssociatedLifecycleModules((ConfigContext)this._configCtx, (String)this._serverName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "synchronization.config_no_lifecycle", this._serverName);
        }
        if (lifecycleMods != null) {
            for (int i = 0; i < lifecycleMods.length; ++i) {
                LifecycleModuleRequestBuilder lBuilder = new LifecycleModuleRequestBuilder(this._configCtx, this._serverName);
                ApplicationSynchRequest asr = lBuilder.build(lifecycleMods[i]);
                this._requests.add(asr);
            }
        }
    }
}

