/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.synchronization.Command;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

class TimestampCommand
implements Command {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManager _localStrMgr = StringManager.getManager(TimestampCommand.class);
    private SynchronizationRequest _request = null;
    private SynchronizationResponse _response = null;
    private static final String NAME = "Synchronization-Timestamp-Command";

    TimestampCommand(SynchronizationRequest req, SynchronizationResponse res) {
        this._request = req;
        this._response = res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws SynchronizationException {
        block23: {
            try {
                long startTime = this._response.getSynchronizationStartTime();
                File cacheTSFile = this._request.getCacheTimestampFile();
                assert (cacheTSFile != null);
                File parentDir = cacheTSFile.getParentFile();
                if (cacheTSFile.exists()) {
                    BufferedReader is = null;
                    try {
                        is = new BufferedReader(new FileReader(cacheTSFile));
                        long lastModifiedTime = Long.parseLong(is.readLine());
                        is.close();
                        is = null;
                        if (startTime < lastModifiedTime) {
                            String msg = _localStrMgr.getString("invalidSynchronizationTS", (Object)cacheTSFile.getPath(), (Object)Long.toString(startTime), (Object)Long.toString(lastModifiedTime));
                            throw new SynchronizationException(msg);
                        }
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
                if (parentDir.exists()) {
                    FileWriter fw = null;
                    try {
                        fw = new FileWriter(cacheTSFile);
                        fw.write(Long.toString(startTime));
                        fw.flush();
                        fw.close();
                        fw = null;
                        _logger.log(Level.FINE, "synchronization.ts_created", cacheTSFile.getPath());
                        break block23;
                    }
                    finally {
                        try {
                            if (fw != null) {
                                fw.close();
                            }
                        }
                        catch (Exception e) {}
                    }
                }
                _logger.log(Level.FINE, "synchronization.ts_exists", cacheTSFile.getPath());
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "synchronization.ts_not_created", this._request.getMetaFileName());
                String msg = _localStrMgr.getString("updateTimestampError", (Object)this._request.getMetaFileName());
                throw new SynchronizationException(msg, e);
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public Object getResult() {
        return null;
    }
}

