/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.inventory;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class InventoryDiff {
    private String[] _origList = null;
    private String[] _targetList = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManager _localStrMgr = StringManager.getManager(InventoryDiff.class);

    InventoryDiff(List origList, List targetList) {
        this._origList = InventoryDiff.transformInventory(origList);
        this._targetList = InventoryDiff.transformInventory(targetList);
    }

    List diff() {
        ArrayList<String> list = new ArrayList<String>();
        if (this._origList == null || this._origList.length == 0) {
            return list;
        }
        if (this._targetList == null || this._targetList.length == 0) {
            return Arrays.asList(this._origList);
        }
        for (int i = 0; i < this._origList.length; ++i) {
            int idx = -1;
            idx = Arrays.binarySearch(this._targetList, this._origList[i]);
            if (idx < 0) {
                list.add(this._origList[i]);
                _logger.log(Level.FINE, "Found diff " + this._origList[i]);
                continue;
            }
            _logger.log(Level.FINE, "No diff - idx : " + idx + " Target List: " + this._targetList[idx] + " Original List: " + this._origList[i]);
        }
        return list;
    }

    static String[] transformInventory(List list) {
        if (list.size() == 0) {
            return null;
        }
        Object[] l = new String[list.size()];
        l = list.toArray(l);
        for (int i = 0; i < l.length; ++i) {
            l[i] = FileUtils.makeForwardSlashes((String)l[i]);
        }
        Arrays.sort(l);
        return l;
    }
}

