/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.processor;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.processor.BaseProcessor;
import com.sun.enterprise.ee.synchronization.processor.RequestContext;
import com.sun.enterprise.ee.util.zip.Zipper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipOutputStream;

public class ByteProcessor
extends BaseProcessor {
    public ByteProcessor(RequestContext ctx) throws IOException {
        this._ctx = ctx;
        this._bos = new ByteArrayOutputStream(16384);
        this._cos = new CheckedOutputStream(new BufferedOutputStream(this._bos), new CRC32());
        this._out = new ZipOutputStream(this._cos);
    }

    void initZipper(SynchronizationRequest req, Zipper z) throws ConfigException {
        long buffer = this.getMaxBuffer();
        z.setMaxBuffer(buffer);
        this.processAlwaysInclude(req, z);
    }

    void postProcess(long zipSize, SynchronizationRequest[] results) throws IOException {
        this._cos.flush();
        byte[] zipBytes = null;
        zipBytes = this._bos.toByteArray();
        if (zipBytes == null) {
            zipBytes = new byte[]{};
        }
        long checksum = this._cos.getChecksum().getValue();
        if (zipBytes.length > 0) {
            this._out.close();
            this._out = null;
        }
        this._response = new SynchronizationResponse(zipBytes, results, checksum, this._ctx.getStartTime(), System.currentTimeMillis());
    }

    private long getMaxBuffer() {
        long maxBuffer = 0xA00000L;
        try {
            String buffer = System.getProperty("com.sun.appserv.synchronizationBufferSize");
            if (buffer != null && !"".equals(buffer)) {
                maxBuffer = Long.parseLong(buffer);
            }
        }
        catch (Exception e) {
            maxBuffer = 0xA00000L;
        }
        return maxBuffer;
    }
}

