/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.processor;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.processor.BaseProcessor;
import com.sun.enterprise.ee.synchronization.processor.RequestContext;
import com.sun.enterprise.ee.util.zip.Zipper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ServletProcessor
extends BaseProcessor {
    public static final String RESPONSE_ENTRY_NAME = "com.sun.appserv.SynchronizationResponse";

    public ServletProcessor(RequestContext ctx, HttpServletResponse response) throws IOException {
        this._ctx = ctx;
        response.setHeader("Content-Type", "application/zip");
        ServletOutputStream sout = response.getOutputStream();
        this._out = new ZipOutputStream((OutputStream)sout);
    }

    void initZipper(SynchronizationRequest req, Zipper z) throws ConfigException {
        this.processAlwaysInclude(req, z);
    }

    void postProcess(long zipSize, SynchronizationRequest[] results) throws IOException {
        this._response = new SynchronizationResponse(null, results, 0L, this._ctx.getStartTime(), System.currentTimeMillis());
        this.addResponseToZip(this._response);
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this._out = null;
        }
    }

    private void addResponseToZip(SynchronizationResponse response) throws IOException {
        ZipEntry entry = new ZipEntry(RESPONSE_ENTRY_NAME);
        entry.setTime(System.currentTimeMillis());
        this._out.putNextEntry(entry);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(response);
        oos.close();
        byte[] buf = bos.toByteArray();
        this._out.write(buf, 0, buf.length);
        this._out.closeEntry();
    }
}

