/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.store;

import com.sun.enterprise.ee.synchronization.store.PersistenceStore;
import com.sun.enterprise.ee.synchronization.store.StoreException;
import com.sun.enterprise.ee.synchronization.util.io.Utils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilePersistenceStore
implements PersistenceStore {
    private static final StringManager _localStrMgr = StringManager.getManager(FilePersistenceStore.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static StringManagerBase _logStrMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    static final String DEF_SUFFIX = "_save";
    static final String BKUP_KEY = "com.sun.appserv.synchronization.backup";

    public void save(Object obj) throws StoreException {
        if (this.isBkupON()) {
            this.saveWithCopy(obj);
        }
    }

    private boolean isBkupON() {
        return Boolean.getBoolean(BKUP_KEY);
    }

    private void saveWithCopy(Object obj) throws StoreException {
        assert (obj != null);
        String origDir = (String)obj;
        String backupDir = (String)this.getBackupFileName(origDir);
        File fromDir = new File(origDir);
        File toDir = new File(backupDir);
        if (toDir.exists()) {
            _logger.log(Level.FINEST, "synchronization.remove_olddir", toDir.getName());
            FileUtils.liquidate((File)toDir);
        }
        try {
            FileUtils.copy((File)fromDir, (File)toDir);
        }
        catch (IOException ioe) {
            String msg = _localStrMgr.getString("notSavedError", (Object)fromDir, (Object)toDir);
            throw new StoreException(msg, ioe);
        }
    }

    private void saveWithMove(Object obj) throws StoreException {
        assert (obj != null);
        String origDir = (String)obj;
        String backupDir = (String)this.getBackupFileName(origDir);
        File fromDir = new File(origDir);
        File toDir = new File(backupDir);
        if (toDir.exists()) {
            _logger.log(Level.FINEST, "synchronization.remove_olddir", toDir.getName());
            FileUtils.liquidate((File)toDir);
        }
        _logger.log(Level.FINER, _logStrMgr.getString("synchronization.rename_dir", (Object)fromDir.getName(), (Object)toDir.getName()));
        boolean ok = fromDir.renameTo(toDir);
        if (!ok) {
            String msg = _localStrMgr.getString("notSavedError", (Object)fromDir, (Object)toDir);
            throw new StoreException(msg);
        }
    }

    public void restore(Object obj) throws StoreException {
        if (!this.isBkupON()) {
            return;
        }
        assert (obj != null);
        String origDir = (String)obj;
        String backupDir = (String)this.getBackupFileName(origDir);
        File fromDir = new File(backupDir);
        File toDir = new File(origDir);
        if (toDir.exists()) {
            _logger.log(Level.FINEST, "synchronization.remove_olddir", toDir.getName());
            FileUtils.liquidate((File)toDir);
        }
        if (fromDir.exists()) {
            _logger.log(Level.FINER, _logStrMgr.getString("synchronization.rename_dir", (Object)fromDir.getName(), (Object)toDir.getName()));
            boolean ok = fromDir.renameTo(toDir);
            if (!ok) {
                String msg = _localStrMgr.getString("notSavedError", (Object)fromDir, (Object)toDir);
                throw new StoreException(msg);
            }
        }
    }

    public void merge(Object src, Object dst) throws StoreException {
        if (!this.isBkupON()) {
            return;
        }
        assert (src != null);
        assert (dst != null);
        File srcFile = new File((String)src);
        File dstFile = new File((String)dst);
        try {
            _logger.log(Level.FINEST, _logStrMgr.getString("synchronization.merge_dirs", (Object)srcFile.getName(), (Object)dstFile.getName()));
            Utils.mergeTree(srcFile, dstFile);
        }
        catch (IOException ioe) {
            String msg = _localStrMgr.getString("notMergedError", src, dst);
            throw new StoreException(msg, ioe);
        }
    }

    public Object getBackupFileName(Object src) throws StoreException {
        assert (src != null);
        try {
            File file = new File((String)src);
            File bkup = null;
            _logger.log(Level.FINER, "synchronization.get_backup", file.getName());
            if (file.isDirectory()) {
                String dir = file.getCanonicalPath();
                if (dir.endsWith(File.separator)) {
                    dir = dir.substring(0, dir.length());
                }
                bkup = new File(dir + DEF_SUFFIX);
            } else {
                bkup = new File(file.getCanonicalPath() + DEF_SUFFIX);
            }
            return bkup.getCanonicalPath();
        }
        catch (Exception e) {
            String msg = _localStrMgr.getString("noBackupFileError", src);
            throw new StoreException(msg, e);
        }
    }
}

