/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.HAStoreBase;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManager;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Session;

public class ReplicationBackgroundManager
extends ReplicationManagerBase
implements ReplicationManager {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private static final String info = "ReplicationBackgroundManager/1.0";
    private static final String name = "ReplicationBackgroundManager";

    public String getInfo() {
        return info;
    }

    public String getName() {
        return name;
    }

    protected Session createNewSession() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN ReplicationBackgroundManager>>createNewSession");
        }
        Session sess = super.createNewSession();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("GOT SESSION VIA FACTORY: Class = " + sess.getClass().getName());
        }
        return sess;
    }

    protected Session swapIn(String id) throws IOException {
        Session sess = super.swapIn(id);
        if (sess != null) {
            this.doValveSave(sess);
        }
        return sess;
    }

    public boolean isSessionVersioningSupported() {
        return false;
    }

    public ReplicationState processBroadcastfindsession(ReplicationState queryState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastfindSession:instance: " + this.getInstanceName());
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastfindSession:id=" + queryState.getId());
        }
        ReplicationState replicaState = this.findReplicatedState(queryState);
        ReplicationState returnState = null;
        if (replicaState != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("processBroadcastfindsession:REPLICA_FOUND:replicaStateVersion:" + replicaState.getVersion());
                _logger.fine("processBroadcastfindsession:REPLICA_FOUND:replicaState:" + replicaState.getTrunkState());
                _logger.fine("processBroadcastfindsession:REPLICA_FOUND:replicaAttrState" + replicaState.getState());
            }
            returnState = ReplicationState.createQueryResponseFrom(replicaState);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("processBroadcastfindsession:replicaStateResponseVersion:" + returnState.getVersion());
            }
            this.replicatedSessions.remove(replicaState.getId());
        }
        this.clearFromManagerCache((String)queryState.getId());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastfindSession:returnState=" + returnState);
        }
        return returnState;
    }

    public String getMonitorAttributeValues() {
        StringBuffer sb = new StringBuffer(500);
        WebModuleStatistics stats = this.getWebModuleStatistics();
        sb.append("\nBACKGROUND_SAVE_LOW=" + stats.getBackgroundSaveLow());
        sb.append("\nBACKGROUND_SAVE_HIGH=" + stats.getBackgroundSaveHigh());
        sb.append("\nBACKGROUND_SAVE_AVG=" + stats.getBackgroundSaveAverage());
        sb.append("\nSESSION_SIZE_LOW=" + stats.getSessionSizeLow());
        sb.append("\nSESSION_SIZE_HIGH=" + stats.getSessionSizeHigh());
        sb.append("\nSESSION_SIZE_AVG=" + stats.getSessionSizeAverage());
        long cacheHits = stats.getCacheHits();
        long cacheMisses = stats.getCacheMisses();
        long cacheTotal = cacheHits + cacheMisses;
        long ratio = -1L;
        if (cacheTotal != 0L) {
            ratio = cacheHits / cacheTotal;
        }
        sb.append("\nCACHE_HIT_RATIO=" + ratio);
        int numCachedSessions = this.sessions.size();
        sb.append("\nNUMBER_CACHED_SESSIONS=" + numCachedSessions);
        HAStoreBase store = (HAStoreBase)this.getStore();
        int numStoredSessions = -1;
        try {
            numStoredSessions = store.getSize();
        }
        catch (Exception ex) {
            // empty catch block
        }
        int activeSessions = 0;
        int passivatedSessions = 0;
        if (numStoredSessions >= numCachedSessions) {
            activeSessions = numStoredSessions;
            passivatedSessions = numStoredSessions - numCachedSessions;
        } else {
            activeSessions = numCachedSessions;
        }
        sb.append("\nNUMBER_ACTIVE_SESSIONS=" + activeSessions);
        sb.append("\nNUMBER_PASSIVATED_SESSIONS=" + passivatedSessions);
        stats.resetStats();
        return sb.toString();
    }
}

