/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.jxta;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.impl.common.DSCMessage;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.MessageSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.impl.common.ShutdownHelper;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.impl.jxta.DistributedStateCacheImpl;
import com.sun.enterprise.ee.cms.impl.jxta.GMSContext;
import com.sun.enterprise.ee.cms.impl.jxta.MessagePacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.GMSMessage;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.text.MessageFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageWindow
implements Runnable {
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private GMSContext ctx;
    private ArrayBlockingQueue<MessagePacket> messageQueue;
    private final String groupName;

    public MessageWindow(String groupName, ArrayBlockingQueue<MessagePacket> messageQueue) {
        this.groupName = groupName;
        this.messageQueue = messageQueue;
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = (GMSContext)GMSContextFactory.getGMSContext(this.groupName);
        }
        return this.ctx;
    }

    @Override
    public void run() {
        while (!this.getGMSContext().isShuttingDown()) {
            try {
                MessagePacket packet = this.messageQueue.take();
                if (packet == null) continue;
                this.logger.log(Level.FINER, "Processing received message .... ");
                this.newMessageReceived(packet);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINEST, e.getLocalizedMessage());
            }
        }
    }

    private void newMessageReceived(MessagePacket packet) {
        Object message = packet.getMessage();
        SystemAdvertisement adv = packet.getAdvertisement();
        String sender = adv.getName();
        if (message instanceof GMSMessage) {
            this.handleGMSMessage((GMSMessage)message, sender);
        } else if (message instanceof DSCMessage) {
            this.handleDSCMessage((DSCMessage)message, sender);
        }
    }

    private void handleDSCMessage(DSCMessage dMsg, String token) {
        String ops = dMsg.getOperation();
        this.logger.log(Level.FINER, MessageFormat.format("DSCMessageReceived from :{0}, Operation :{1}", token, ops));
        DistributedStateCacheImpl dsc = (DistributedStateCacheImpl)this.getGMSContext().getDistributedStateCache();
        if (ops.equals(DSCMessage.OPERATION.ADD.toString())) {
            this.logger.log(Level.FINER, "Adding Message: " + dMsg.getKey() + ":" + dMsg.getValue());
            dsc.addToLocalCache(dMsg.getKey(), dMsg.getValue());
        } else if (ops.equals(DSCMessage.OPERATION.REMOVE.toString())) {
            this.logger.log(Level.FINER, "Removing Values with Key: " + dMsg.getKey());
            dsc.removeFromLocalCache(dMsg.getKey());
        } else if (ops.equals(DSCMessage.OPERATION.ADDALLLOCAL.toString())) {
            if (dMsg.isCoordinator()) {
                try {
                    this.logger.log(Level.FINER, "Syncing local cache with group ...");
                    dsc.addAllToRemoteCache();
                    this.logger.log(Level.FINER, "done with local to group sync...");
                }
                catch (GMSException e) {
                    this.logger.log(Level.WARNING, e.getLocalizedMessage());
                }
                this.logger.log(Level.FINER, "adding group cache state to local cache..");
                dsc.addAllToLocalCache(dMsg.getCache());
            }
        } else if (ops.equals(DSCMessage.OPERATION.ADDALLREMOTE.toString())) {
            dsc.addAllToLocalCache(dMsg.getCache());
        }
    }

    private void handleGMSMessage(GMSMessage gMsg, String sender) {
        if (gMsg.getComponentName().equals(GMSConstants.shutdownType.GROUP_SHUTDOWN.toString())) {
            ShutdownHelper sh = GMSContextFactory.getGMSContext(gMsg.getGroupName()).getShutdownHelper();
            this.logger.log(Level.INFO, "member.groupshutdown", new Object[]{sender});
            sh.addToGroupShutdownList(gMsg.getGroupName());
        } else if (this.getRouter().isMessageAFRegistered()) {
            this.writeLog(sender, gMsg);
            MessageSignalImpl ms = new MessageSignalImpl(gMsg.getMessage(), gMsg.getComponentName(), sender, gMsg.getGroupName(), gMsg.getStartTime());
            SignalPacket signalPacket = new SignalPacket(ms);
            this.getRouter().queueSignal(signalPacket);
        }
    }

    private Router getRouter() {
        return this.getGMSContext().getRouter();
    }

    private void writeLog(String sender, GMSMessage message) {
        String localId = this.getGMSContext().getServerIdentityToken();
        this.logger.log(Level.FINER, MessageFormat.format("Sender:{0}, Receiver :{1}, TargetComponent :{2}, Message :{3}", sender, localId, message.getComponentName(), new String(message.getMessage())));
    }
}

