/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.jxta;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSCacheable;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.common.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureRecoverySignalImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureSuspectedSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.GMSMember;
import com.sun.enterprise.ee.cms.impl.common.JoinNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.PlannedShutdownSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.RecoveryTargetSelector;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.impl.jxta.CustomTagNames;
import com.sun.enterprise.ee.cms.impl.jxta.DistributedStateCacheImpl;
import com.sun.enterprise.ee.cms.impl.jxta.EventPacket;
import com.sun.enterprise.ee.cms.impl.jxta.GMSContext;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.jxtamgmt.ClusterView;
import com.sun.enterprise.jxtamgmt.ClusterViewEvents;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewWindow
implements com.sun.enterprise.ee.cms.impl.common.ViewWindow,
Runnable {
    private GMSContext ctx;
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private int size = 100;
    private final List<ArrayList<GMSMember>> views = new Vector<ArrayList<GMSMember>>();
    private List<Signal> signals = new Vector<Signal>();
    private final List<String> currentCoreMembers = new ArrayList<String>();
    private final List<String> allCurrentMembers = new ArrayList<String>();
    private static final String CORETYPE = "CORE";
    private static final int SYNCWAITMILLIS = 3000;
    private static final String REC_PROGRESS_STATE = GroupManagementService.RECOVERY_STATE.RECOVERY_IN_PROGRESS.toString();
    private static final String REC_APPOINTED_STATE = GroupManagementService.RECOVERY_STATE.RECOVERY_SERVER_APPOINTED.toString();
    private final ArrayBlockingQueue<EventPacket> viewQueue;
    private final String groupName;

    ViewWindow(String groupName, ArrayBlockingQueue<EventPacket> viewQueue) {
        this.groupName = groupName;
        this.viewQueue = viewQueue;
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = (GMSContext)GMSContextFactory.getGMSContext(this.groupName);
        }
        return this.ctx;
    }

    @Override
    public void run() {
        while (!this.getGMSContext().isShuttingDown()) {
            try {
                EventPacket packet = this.viewQueue.take();
                if (packet == null) continue;
                this.newViewObserved(packet);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINEST, e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newViewObserved(EventPacket packet) {
        List<ArrayList<GMSMember>> list = this.views;
        synchronized (list) {
            this.views.add(this.getMemberTokens(packet));
            if (this.views.size() > this.size) {
                this.views.remove(0);
            }
            this.logger.log(Level.INFO, "membership.snapshot.analysis", new Object[]{packet.getClusterViewEvent().toString()});
            Signal[] activeSignals = this.analyzeViewChange(packet);
            if (activeSignals.length != 0) {
                this.getGMSContext().getRouter().queueSignals(new SignalPacket(activeSignals));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<GMSMember> getMemberTokens(EventPacket packet) {
        List<String> list = this.currentCoreMembers;
        synchronized (list) {
            this.currentCoreMembers.clear();
        }
        list = this.allCurrentMembers;
        synchronized (list) {
            this.allCurrentMembers.clear();
        }
        ArrayList<GMSMember> tokens = new ArrayList<GMSMember>();
        ClusterView view = packet.getClusterView();
        int count = 0;
        StringBuffer sb = new StringBuffer("GMS View Change Received: Members in view ").append("(before change analysis) are :\n");
        Iterator<SystemAdvertisement> i$ = view.getView().iterator();
        while (i$.hasNext()) {
            List<String> list2;
            SystemAdvertisement systemAdvertisement;
            SystemAdvertisement advert = systemAdvertisement = i$.next();
            GMSMember member = this.getGMSMember(advert);
            member.setSnapShotId(view.getClusterViewId());
            sb.append(++count).append(": MemberId: ").append(member.getMemberToken()).append(", MemberType: ").append(member.getMemberType()).append(", Address: ").append(advert.getID().toString()).append('\n');
            if (member.getMemberType().equals(CORETYPE)) {
                list2 = this.currentCoreMembers;
                synchronized (list2) {
                    this.currentCoreMembers.add(new StringBuffer(member.getMemberToken()).append("::").append(member.getStartTime()).toString());
                }
            }
            tokens.add(member);
            list2 = this.allCurrentMembers;
            synchronized (list2) {
                this.allCurrentMembers.add(new StringBuffer().append(member.getMemberToken()).append("::").append(member.getStartTime()).toString());
            }
        }
        this.logger.log(Level.INFO, sb.toString());
        return tokens;
    }

    private GMSMember getGMSMember(SystemAdvertisement systemAdvertisement) {
        GMSMember member;
        try {
            member = new GMSMember(systemAdvertisement.getName(), systemAdvertisement.getCustomTagValue(CustomTagNames.MEMBER_TYPE.toString()), systemAdvertisement.getCustomTagValue(CustomTagNames.GROUP_NAME.toString()), Long.valueOf(systemAdvertisement.getCustomTagValue(CustomTagNames.START_TIME.toString())));
        }
        catch (NoSuchFieldException e) {
            this.logger.log(Level.WARNING, new StringBuffer("SystemAdvertisement did not contain one of the ").append("specified tag values:").append(e.getLocalizedMessage()).toString());
            member = new GMSMember(systemAdvertisement.getName(), null, null, null);
        }
        return member;
    }

    private Signal[] analyzeViewChange(EventPacket packet) {
        ((Vector)this.signals).removeAllElements();
        ClusterViewEvents events = packet.getClusterViewEvent();
        if (events.equals((Object)ClusterViewEvents.ADD_EVENT)) {
            this.addNewMemberJoins(packet);
        } else if (events.equals((Object)ClusterViewEvents.IN_DOUBT_EVENT)) {
            this.addInDoubtMemberSignals(packet);
        } else if (events.equals((Object)ClusterViewEvents.FAILURE_EVENT)) {
            this.addFailureSignals(packet);
        } else if (events.equals((Object)ClusterViewEvents.MASTER_CHANGE_EVENT)) {
            this.analyzeMasterChangeView(packet);
        } else if (events.equals((Object)ClusterViewEvents.CLUSTER_STOP_EVENT) || events.equals((Object)ClusterViewEvents.PEER_STOP_EVENT)) {
            this.addPlannedShutdownSignals(packet);
        } else if (events.equals((Object)ClusterViewEvents.NO_LONGER_INDOUBT_EVENT)) {
            this.addNewMemberJoins(packet);
        }
        Signal[] s = new Signal[this.signals.size()];
        return this.signals.toArray(s);
    }

    private void analyzeMasterChangeView(EventPacket packet) {
        if (this.views.size() > 1 && packet.getClusterView().getSize() != this.views.get(this.views.size() - 2).size()) {
            this.determineAndAddNewMemberJoins();
        }
    }

    private void determineAndAddNewMemberJoins() {
        block5: {
            List newMembership;
            block4: {
                newMembership = this.views.get(this.views.size() - 1);
                if (this.views.size() != 1) break block4;
                if (newMembership.size() <= 1) break block5;
                for (GMSMember member : newMembership) {
                    String token = member.getMemberToken();
                    if (!token.equals(this.getGMSContext().getServerIdentityToken())) {
                        this.syncDSC(token);
                    }
                    if (!member.getMemberType().equalsIgnoreCase(CORETYPE)) continue;
                    this.addJoinNotificationSignal(token, member.getGroupName(), member.getStartTime());
                }
                break block5;
            }
            if (this.views.size() > 1) {
                List<String> oldMembers = this.getTokens((List<GMSMember>)this.views.get(this.views.size() - 2));
                for (GMSMember member : newMembership) {
                    String token = member.getMemberToken();
                    if (oldMembers.contains(token)) continue;
                    this.syncDSC(token);
                    if (!member.getMemberType().equalsIgnoreCase(CORETYPE)) continue;
                    this.addJoinNotificationSignal(token, member.getGroupName(), member.getStartTime());
                }
            }
        }
    }

    private List<String> getTokens(List<GMSMember> oldMembers) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (GMSMember member : oldMembers) {
            tokens.add(member.getMemberToken());
        }
        return tokens;
    }

    private void addPlannedShutdownSignals(EventPacket packet) {
        SystemAdvertisement advert = packet.getSystemAdvertisement();
        String token = advert.getName();
        DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
        try {
            GMSConstants.shutdownType shutdownType2;
            if (packet.getClusterViewEvent().equals((Object)ClusterViewEvents.CLUSTER_STOP_EVENT)) {
                shutdownType2 = GMSConstants.shutdownType.GROUP_SHUTDOWN;
            } else {
                shutdownType2 = GMSConstants.shutdownType.INSTANCE_SHUTDOWN;
                if (dsc != null) {
                    dsc.removeAllForMember(token);
                }
            }
            this.logger.log(Level.INFO, "plannedshutdownevent.announcement", new Object[]{token, shutdownType2});
            this.signals.add(new PlannedShutdownSignalImpl(token, advert.getCustomTagValue(CustomTagNames.GROUP_NAME.toString()), Long.valueOf(advert.getCustomTagValue(CustomTagNames.START_TIME.toString())), shutdownType2));
        }
        catch (NoSuchFieldException e) {
            this.logger.log(Level.WARNING, "systemadv.not.contain.customtag", new Object[]{e.getLocalizedMessage()});
        }
    }

    private void addInDoubtMemberSignals(EventPacket packet) {
        SystemAdvertisement advert = packet.getSystemAdvertisement();
        String token = advert.getName();
        this.getGMSContext().addToSuspectList(token);
        try {
            this.logger.log(Level.INFO, "gms.failureSuspectedEventReceived", token);
            this.signals.add(new FailureSuspectedSignalImpl(token, advert.getCustomTagValue(CustomTagNames.GROUP_NAME.toString()), Long.valueOf(advert.getCustomTagValue(CustomTagNames.START_TIME.toString()))));
        }
        catch (NoSuchFieldException e) {
            this.logger.log(Level.WARNING, "systemadv.not.contain.customtag", new Object[]{e.getLocalizedMessage()});
        }
    }

    private void addFailureSignals(EventPacket packet) {
        SystemAdvertisement advert = packet.getSystemAdvertisement();
        String token = advert.getName();
        try {
            String type = advert.getCustomTagValue(CustomTagNames.MEMBER_TYPE.toString());
            if (type.equalsIgnoreCase(CORETYPE)) {
                this.logger.log(Level.INFO, "member.failed", new Object[]{token});
                this.generateFailureRecoverySignals((List<GMSMember>)this.views.get(this.views.size() - 2), token, advert.getCustomTagValue(CustomTagNames.GROUP_NAME.toString()), Long.valueOf(advert.getCustomTagValue(CustomTagNames.START_TIME.toString())));
                if (this.getGMSContext().getRouter().isFailureNotificationAFRegistered()) {
                    this.signals.add(new FailureNotificationSignalImpl(token, advert.getCustomTagValue(CustomTagNames.GROUP_NAME.toString()), Long.valueOf(advert.getCustomTagValue(CustomTagNames.START_TIME.toString()))));
                }
                this.logger.fine("removing newly added node from the suspected list..." + token);
                this.getGMSContext().removeFromSuspectList(token);
            }
        }
        catch (NoSuchFieldException e) {
            this.logger.log(Level.WARNING, "systemadv.not.contain.customtag", new Object[]{e.getLocalizedMessage()});
        }
    }

    private void generateFailureRecoverySignals(List<GMSMember> oldMembership, String token, String groupName, Long startTime) {
        Router router = this.getGMSContext().getRouter();
        if (router.isFailureRecoveryAFRegistered()) {
            this.logger.log(Level.FINE, "Determining the recovery server..");
            if (RecoveryTargetSelector.resolveRecoveryTarget(null, oldMembership, token, this.getGMSContext())) {
                List<String> recInProgressMembers = this.getRecoveriesInProgressByFailedMember(token);
                List<String> recApptsHeldByFailedMember = this.getRecApptsHeldByFailedMember(token);
                for (String comp : router.getFailureRecoveryComponents()) {
                    this.logger.log(Level.FINE, new StringBuffer("adding failure recovery signal for component=").append(comp).toString());
                    this.signals.add(new FailureRecoverySignalImpl(comp, token, groupName, startTime));
                    if (!recInProgressMembers.isEmpty()) {
                        for (String fToken : recInProgressMembers) {
                            this.signals.add(new FailureRecoverySignalImpl(comp, fToken, groupName, 0L));
                        }
                    }
                    if (recApptsHeldByFailedMember.isEmpty()) continue;
                    for (String fToken : recApptsHeldByFailedMember) {
                        this.signals.add(new FailureRecoverySignalImpl(comp, fToken, groupName, 0L));
                    }
                }
            }
        }
    }

    private List<String> getRecApptsHeldByFailedMember(String token) {
        ArrayList<String> tokens = new ArrayList<String>();
        DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
        Map<GMSCacheable, Object> entries = dsc.getFromCache(token);
        for (GMSCacheable gmsCacheable : entries.keySet()) {
            Object entry;
            if (!token.equals(gmsCacheable.getMemberTokenId()) || token.equals(gmsCacheable.getKey()) || !((entry = entries.get(gmsCacheable)) instanceof String) || !((String)entry).startsWith(REC_APPOINTED_STATE) || this.currentCoreMembers.contains(gmsCacheable.getKey())) continue;
            this.logger.log(Level.FINER, new StringBuffer("Failed Member ").append(token).append(" was appointed for recovery of ").append(gmsCacheable.getKey()).append(" when ").append(token).append(" failed. ").append("Adding to recovery-appointed list...").toString());
            tokens.add((String)gmsCacheable.getKey());
            try {
                dsc.removeFromCache(gmsCacheable.getComponentName(), gmsCacheable.getMemberTokenId(), (Serializable)gmsCacheable.getKey());
                RecoveryTargetSelector.setRecoverySelectionState(this.getGMSContext().getServerIdentityToken(), (String)gmsCacheable.getKey(), this.getGMSContext().getGroupName());
            }
            catch (GMSException e) {
                this.logger.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
        return tokens;
    }

    private List<String> getRecoveriesInProgressByFailedMember(String token) {
        ArrayList<String> tokens = new ArrayList<String>();
        DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
        Map<GMSCacheable, Object> entries = dsc.getFromCache(token);
        for (GMSCacheable gmsCacheable : entries.keySet()) {
            Object entry;
            if (!token.equals(gmsCacheable.getMemberTokenId()) || token.equals(gmsCacheable.getKey()) || !((entry = entries.get(gmsCacheable)) instanceof String) || !((String)entry).startsWith(REC_PROGRESS_STATE)) continue;
            this.logger.log(Level.FINER, new StringBuffer("Failed Member ").append(token).append(" had recovery-in-progress for ").append(gmsCacheable.getKey()).append(" when ").append(token).append(" failed. ").toString());
            tokens.add((String)gmsCacheable.getKey());
            RecoveryTargetSelector.setRecoverySelectionState(this.getGMSContext().getServerIdentityToken(), (String)gmsCacheable.getKey(), this.getGMSContext().getGroupName());
        }
        return tokens;
    }

    private void addNewMemberJoins(EventPacket packet) {
        SystemAdvertisement advert = packet.getSystemAdvertisement();
        String token = advert.getName();
        if (packet.getClusterView().getSize() > 1) {
            this.syncDSC(token);
        }
        try {
            if (advert.getCustomTagValue(CustomTagNames.MEMBER_TYPE.toString()).equalsIgnoreCase(CORETYPE)) {
                this.addJoinNotificationSignal(token, advert.getCustomTagValue(CustomTagNames.GROUP_NAME.toString()), Long.valueOf(advert.getCustomTagValue(CustomTagNames.START_TIME.toString())));
            }
        }
        catch (NoSuchFieldException e) {
            this.logger.log(Level.WARNING, new StringBuffer("The SystemAdvertisement did ").append("not contain the ").append(e.getLocalizedMessage()).append(" custom tag value:").toString());
        }
    }

    private void addJoinNotificationSignal(String token, String groupName, long startTime) {
        this.logger.log(Level.FINE, "adding join signal");
        this.signals.add(new JoinNotificationSignalImpl(token, this.getCurrentCoreMembers(), this.getAllCurrentMembers(), groupName, startTime));
        this.logger.log(Level.FINE, "gms.newMemberAdded", token);
    }

    private void syncDSC(String token) {
        if (this.isCoordinator()) {
            this.logger.log(Level.FINE, "I am coordinator, performing sync ops on " + token);
            try {
                DistributedStateCacheImpl dsc = (DistributedStateCacheImpl)this.getGMSContext().getDistributedStateCache();
                this.logger.log(Level.FINER, "got DSC ref " + dsc.toString());
                Thread.sleep(3000L);
                this.logger.log(Level.FINER, "Syncing...");
                dsc.syncCache(token, true);
                this.logger.log(Level.FINER, "Sync request sent..");
            }
            catch (GMSException e) {
                this.logger.log(Level.WARNING, "GMSException during DSC sync" + e.getLocalizedMessage());
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, e.getLocalizedMessage());
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Exception during DSC sync:" + e);
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isCoordinator() {
        return this.getGMSContext().getGroupCommunicationProvider().isGroupLeader();
    }

    @Override
    public List getPreviousView() {
        return this.views.get(this.views.size() - 2);
    }

    @Override
    public List getCurrentView() {
        return this.views.get(this.views.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCurrentCoreMembers() {
        ArrayList<String> retVal = new ArrayList<String>();
        List<String> list = this.currentCoreMembers;
        synchronized (list) {
            for (String member : this.currentCoreMembers) {
                member = member.substring(0, member.indexOf("::"));
                retVal.add(member);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllCurrentMembers() {
        ArrayList<String> retVal = new ArrayList<String>();
        List<String> list = this.allCurrentMembers;
        synchronized (list) {
            for (String member : this.allCurrentMembers) {
                member = member.substring(0, member.indexOf("::"));
                retVal.add(member);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCurrentCoreMembersWithStartTimes() {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> list = this.currentCoreMembers;
        synchronized (list) {
            ret.addAll(this.currentCoreMembers);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllCurrentMembersWithStartTimes() {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> list = this.allCurrentMembers;
        synchronized (list) {
            ret.addAll(this.allCurrentMembers);
        }
        return ret;
    }
}

