/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.tests;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.impl.common.GroupManagementServiceImpl;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.tests.GMSClientService;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationServer
implements Runnable {
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private GroupManagementService gms = null;
    private GMSClientService gcs1;
    private GMSClientService gcs2;
    private String serverName;

    public ApplicationServer(String serverName, String groupName, GroupManagementService.MemberType memberType, Properties props) {
        this.serverName = serverName;
        this.gms = (GroupManagementService)((Object)GMSFactory.startGMSModule(serverName, groupName, memberType, props));
        this.initClientServices(Boolean.valueOf(System.getProperty("MESSAGING_MODE", "true")));
    }

    private void initClientServices(boolean sendMessages) {
        this.gcs1 = new GMSClientService("EJBContainer", this.serverName, sendMessages);
        this.gcs2 = new GMSClientService("TransactionService", this.serverName, false);
    }

    public void run() {
        this.startGMS();
        this.addMemberDetails();
        this.startClientServices();
        try {
            Thread.sleep(Integer.parseInt(System.getProperty("LIFEINMILLIS", "15000")));
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        this.stopClientServices();
        this.stopGMS();
        System.exit(0);
    }

    private void addMemberDetails() {
        Hashtable details = new Hashtable();
        ArrayList ar1 = new ArrayList();
        ArrayList<String> ar2 = new ArrayList<String>();
        int port = 3700;
        int port1 = 3800;
        try {
            ar2.add(InetAddress.getLocalHost() + ":" + 3700);
            ar2.add(InetAddress.getLocalHost() + ":" + 3800);
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
        ar1.add(ar2);
        details.put("IIOPListenerEndPoints", ar1);
        try {
            ((GroupManagementServiceImpl)this.gms).setMemberDetails(this.serverName, details);
        }
        catch (GMSException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    public void startClientServices() {
        logger.log(Level.FINE, "ApplicationServer: Starting GMSClient");
        this.gcs1.start();
        this.gcs2.start();
    }

    public void startGMS() {
        logger.log(Level.FINE, "ApplicationServer: Starting GMS service");
        Thread gservice = new Thread((Runnable)((Object)this.gms), "GMSThread");
        gservice.start();
        try {
            gservice.join();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    public void stopGMS() {
        logger.log(Level.FINE, "ApplicationServer: Stopping GMS service");
        this.gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
    }

    private void stopClientServices() {
        logger.log(Level.FINE, "ApplicationServer: Stopping GMSClient");
        this.gcs1.stopClient();
        this.gcs2.stopClient();
    }

    public void sendMessage(String message) {
        GroupHandle gh = this.gms.getGroupHandle();
        try {
            gh.sendMessage(null, message.getBytes());
        }
        catch (GMSException e) {
            logger.log(Level.INFO, e.getLocalizedMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length > 0 && "--usage".equals(args[1])) {
            logger.log(Level.INFO, new StringBuffer().append("USAGE: java -DMEMBERTYPE <CORE|SPECTATOR>").append(" -DINSTANCEID=<instanceid>").append(" -DCLUSTERNAME=<clustername").append(" -DLIFEINMILLIS= <length of time for this demo").append(" -DMESSAGING_MODE=[true|false] ApplicationServer").toString());
        }
        JxtaUtil.setLogger(logger);
        JxtaUtil.setupLogHandler();
        GroupManagementService.MemberType memberType = "CORE".equals(System.getProperty("MEMBERTYPE", "CORE").toUpperCase()) ? GroupManagementService.MemberType.CORE : GroupManagementService.MemberType.SPECTATOR;
        Properties configProps = new Properties();
        configProps.put(ServiceProviderConfigurationKeys.MULTICASTADDRESS.toString(), System.getProperty("MULTICASTADDRESS", "229.9.1.1"));
        configProps.put(ServiceProviderConfigurationKeys.MULTICASTPORT.toString(), (Object)2299);
        configProps.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_RETRIES.toString(), "2");
        ApplicationServer applicationServer = new ApplicationServer(System.getProperty("INSTANCEID"), System.getProperty("CLUSTERNAME"), memberType, configProps);
        Thread appServThread = new Thread((Runnable)applicationServer, "ApplicationServer");
        appServThread.start();
        try {
            appServThread.join();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }
}

