/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.NetworkManagerProxy;
import com.sun.enterprise.jxtamgmt.NetworkManagerRegistry;
import com.sun.enterprise.jxtamgmt.NiceLogFormatter;
import com.sun.enterprise.jxtamgmt.SelectiveLogFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.endpoint.WireFormatMessageFactory;

public class JxtaUtil {
    private static Logger LOG = Logger.getLogger(System.getProperty("JXTA_MGMT_LOGGER", "JxtaMgmt"));

    private JxtaUtil() {
    }

    public static byte[] createByteArrayFromObject(Object object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(outStream);
            ObjectOutputStream out = new ObjectOutputStream(gos);
            out.writeObject(object);
            gos.finish();
            gos.close();
            return outStream.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public static Object getObjectFromByteArray(MessageElement element) {
        if (element == null) {
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(element.getStream()));
            return in.readObject();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    static Logger getLogger() {
        return LOG;
    }

    static Logger getLogger(String name) {
        return JxtaUtil.getLogger();
    }

    public static void setLogger(Logger logger) {
        LOG = logger;
    }

    public static void setupLogHandler() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        try {
            consoleHandler.setLevel(Level.ALL);
            consoleHandler.setFormatter(new NiceLogFormatter());
            SelectiveLogFilter filter = new SelectiveLogFilter();
        }
        catch (SecurityException e) {
            new ErrorManager().error("Exception caught in setting up ConsoleHandler ", e, 0);
        }
        LOG.addHandler(consoleHandler);
        LOG.setUseParentHandlers(false);
        String level = System.getProperty("LOG_LEVEL", "FINEST");
        LOG.setLevel(Level.parse(level));
    }

    public static void printMessageStats(Message msg, boolean verbose) {
        try {
            Message.ElementIterator it = msg.getMessageElements();
            LOG.log(Level.FINER, "------------------Begin Message---------------------");
            WireFormatMessage serialed = WireFormatMessageFactory.toWire((Message)msg, (MimeMediaType)new MimeMediaType("application/x-jxta-msg"), null);
            LOG.log(Level.FINER, "Message Size :" + serialed.getByteLength());
            while (it.hasNext()) {
                MessageElement el = it.next();
                String eName = el.getElementName();
                LOG.log(Level.FINER, "Element " + eName);
                if (!verbose) continue;
                LOG.log(Level.FINER, "[" + el + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static NetworkManagerProxy getNetworkManagerProxy(String groupName) throws IllegalArgumentException {
        NetworkManagerProxy manager = NetworkManagerRegistry.getNetworkManagerProxy(groupName);
        if (manager != null) {
            return manager;
        }
        throw new IllegalArgumentException("Network Manager Proxy for GroupName " + groupName + "could not be located." + "Check if group has been created or enabled");
    }
}

