/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteControl;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LWRMulticast
implements PipeMsgListener {
    private static final Logger LOG = Logger.getLogger(LWRMulticast.class.getName());
    public static final String NAMESPACE = "JXTAMCAST";
    public static final String ACKTAG = "ACK";
    public static final String SEQTAG = "SEQ";
    public static final String SRCIDTAG = "SRCID";
    private transient PipeAdvertisement pipeAdv;
    private transient PipeService pipeSvc;
    private transient InputPipe in;
    private transient PeerGroup group;
    private transient OutputPipe outputPipe;
    private transient boolean closed = false;
    private transient boolean bound = false;
    private transient long padding = 250L;
    private transient long timeout = 5000L + this.padding;
    private transient MessageElement srcElement = null;
    private transient AtomicLong sequence = new AtomicLong();
    private static final String ackLock = new String("ackLock");
    private transient int threshold = 0;
    private transient Set<PeerID> ackSet = new HashSet<PeerID>();
    private transient Set<PeerID> ackList = new HashSet<PeerID>();
    private transient Map<PeerID, OutputPipe> pipeCache = new Hashtable<PeerID, OutputPipe>();
    private RouteControl routeControl = null;
    private MessageElement routeAdvElement = null;
    private static final String ROUTEADV = "ROUTE";
    private long t0 = System.currentTimeMillis();
    protected transient PipeMsgListener msgListener;

    public LWRMulticast(PeerGroup group, PipeAdvertisement pipeAd, PipeMsgListener msgListener) throws IOException {
        this.joinGroup(group, pipeAd, msgListener);
        MessageTransport endpointRouter = group.getEndpointService().getMessageTransport("jxta");
        if (endpointRouter != null) {
            this.routeControl = (RouteControl)endpointRouter.transportControl((Object)EndpointRouter.GET_ROUTE_CONTROL, null);
            RouteAdvertisement route = this.routeControl.getMyLocalRoute();
            if (route != null) {
                this.routeAdvElement = new TextDocumentMessageElement(ROUTEADV, (TextDocument)((XMLDocument)route.getDocument(MimeMediaType.XMLUTF8)), null);
            }
        }
    }

    public void joinGroup(PeerGroup group, PipeAdvertisement pipeAd, PipeMsgListener msgListener) throws IOException {
        if (pipeAd.getType() != null && !pipeAd.getType().equals("JxtaPropagate")) {
            throw new IOException("Only propagate pipe advertisements are supported");
        }
        if (pipeAd.getPipeID() == null) {
            throw new IOException("Invalid pipe advertisement");
        }
        if (msgListener == null) {
            throw new IllegalArgumentException("msgListener can not be null");
        }
        this.msgListener = msgListener;
        this.group = group;
        this.pipeAdv = pipeAd;
        this.pipeSvc = group.getPipeService();
        this.in = this.pipeSvc.createInputPipe(pipeAd, (PipeMsgListener)this);
        this.outputPipe = this.pipeSvc.createOutputPipe(pipeAd, 1L);
        String id = group.getPeerID().toString();
        this.srcElement = new StringMessageElement(SRCIDTAG, id, null);
        LOG.log(Level.FINEST, "Statring LWRMulticast on pipe id :" + this.pipeAdv.getID());
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.bound = false;
        this.closed = true;
        this.in.close();
        this.outputPipe.close();
        this.in = null;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message message = event.getMessage();
        if (message == null) {
            return;
        }
        PeerID id = LWRMulticast.getSource(message);
        if (id.equals(this.group.getPeerID())) {
            return;
        }
        MessageElement element = message.getMessageElement(NAMESPACE, ACKTAG);
        if (element != null) {
            this.processAck(id, element.toString());
        } else {
            element = message.getMessageElement(NAMESPACE, SEQTAG);
            if (element != null) {
                this.ackMessage(id, element);
                try {
                    if (this.msgListener != null) {
                        LOG.log(Level.FINEST, "Calling message listener");
                        this.msgListener.pipeMsgEvent(event);
                    }
                }
                catch (Throwable th) {
                    LOG.log(Level.FINEST, "Exception occurred while calling message listener", th);
                }
            }
        }
        this.processRoute(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAck(PeerID id, String seq) {
        LOG.log(Level.FINEST, "Processing ack for message sequence " + seq);
        if (!this.ackSet.contains(id)) {
            this.ackSet.add(id);
            if (this.ackSet.size() >= this.threshold) {
                String string = ackLock;
                synchronized (string) {
                    ackLock.notifyAll();
                }
            }
        }
    }

    private void ackMessage(PeerID id, MessageElement seq) {
        LOG.log(Level.FINEST, "Ack'ing message Sequence :" + seq.toString());
        Message msg = new Message();
        msg.addMessageElement(NAMESPACE, this.srcElement);
        msg.addMessageElement(NAMESPACE, (MessageElement)new StringMessageElement(ACKTAG, seq.toString(), null));
        try {
            this.send(id, msg);
        }
        catch (IOException io) {
            LOG.log(Level.FINEST, "I/O Error occured " + io.toString());
        }
    }

    public Set<PeerID> getAckList() {
        return this.ackList;
    }

    public synchronized long getSoTimeout() {
        return this.timeout;
    }

    public synchronized void setSoTimeout(long timeout) throws IOException {
        this.checkState();
        this.timeout = timeout + this.padding;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    private void checkState() throws IOException {
        if (this.isClosed()) {
            throw new IOException("LWRMulticast is closed");
        }
        if (!this.isBound()) {
            throw new IOException("LWRMulticast not bound");
        }
    }

    public static long getSequenceID(Message msg) {
        MessageElement sel = msg.getMessageElement(NAMESPACE, SEQTAG);
        if (sel != null) {
            return Long.parseLong(sel.toString());
        }
        return -1L;
    }

    public static PeerID getSource(Message msg) {
        String addrStr = null;
        PeerID id = null;
        MessageElement sel = msg.getMessageElement(NAMESPACE, SRCIDTAG);
        if (sel != null) {
            try {
                addrStr = new String(sel.getBytes(false), 0, (int)sel.getByteLength(), "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                LOG.log(Level.FINEST, "Encoding Error occured " + uee.toString());
            }
        }
        if (addrStr != null) {
            id = (PeerID)ID.create((URI)URI.create(addrStr));
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message msg, int threshold) throws IOException {
        if (threshold < 0) {
            throw new IllegalArgumentException("Invalid threshold " + threshold + " must be >= 0");
        }
        if (this.routeAdvElement != null && this.routeControl != null && this.sequence.intValue() < 2) {
            msg.addMessageElement(NAMESPACE, this.routeAdvElement);
        }
        this.t0 = System.currentTimeMillis();
        this.threshold = threshold;
        msg.addMessageElement(NAMESPACE, this.srcElement);
        long seq = this.sequence.getAndIncrement();
        msg.addMessageElement(NAMESPACE, (MessageElement)new StringMessageElement(SEQTAG, Long.toString(seq), null));
        String string = ackLock;
        synchronized (string) {
            this.ackList.clear();
            LOG.log(Level.FINEST, "Sending message sequence #: " + seq + " Threshold :" + threshold);
            this.send((PeerID)null, msg);
            if (threshold == 0) {
                return;
            }
            try {
                ackLock.wait(this.timeout);
                if (this.ackSet.size() >= threshold) {
                    this.ackList = new HashSet<PeerID>(this.ackSet);
                    this.ackSet.clear();
                    return;
                }
            }
            catch (InterruptedException ie) {
                LOG.log(Level.FINEST, "Interrupted " + ie.toString());
            }
            this.ackList = new HashSet<PeerID>(this.ackSet);
            this.ackSet.clear();
            if (this.ackList.size() < threshold) {
                throw new SocketTimeoutException("Failed to receive minimum acknowledments of " + threshold + " received :" + this.ackList.size());
            }
        }
    }

    public void send(PeerID pid, Message msg) throws IOException {
        this.checkState();
        if (this.routeAdvElement != null && this.routeControl != null && this.sequence.intValue() < 2) {
            msg.addMessageElement(NAMESPACE, this.routeAdvElement);
        }
        LOG.log(Level.FINEST, "Sending a message");
        if (pid != null) {
            OutputPipe op;
            if (!this.pipeCache.containsKey(pid)) {
                op = this.pipeSvc.createOutputPipe(this.pipeAdv, Collections.singleton(pid), 1000L);
                this.pipeCache.put(pid, op);
            } else {
                op = this.pipeCache.get(pid);
            }
            op.send(msg);
        } else {
            this.outputPipe.send(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Set<PeerID> ids, Message msg) throws IOException {
        this.checkState();
        this.threshold = ids.size();
        this.ackList.clear();
        this.ackSet.clear();
        if (this.routeAdvElement != null && this.routeControl != null && this.sequence.intValue() < 2) {
            msg.addMessageElement(NAMESPACE, this.routeAdvElement);
        }
        LOG.log(Level.FINEST, "Sending a message");
        if (!ids.isEmpty()) {
            OutputPipe op = this.pipeSvc.createOutputPipe(this.pipeAdv, ids, 1000L);
            op.send(msg);
            op.close();
            String string = ackLock;
            synchronized (string) {
                try {
                    ackLock.wait(this.timeout);
                    if (this.ackSet.size() >= this.threshold) {
                        this.ackList = new HashSet<PeerID>(this.ackSet);
                        this.ackSet.clear();
                        return;
                    }
                }
                catch (InterruptedException ie) {
                    LOG.log(Level.FINEST, "Interrupted " + ie.toString());
                }
                if (this.ackSet.size() < this.threshold) {
                    this.ackList = new HashSet<PeerID>(this.ackSet);
                    this.ackSet.clear();
                    throw new SocketTimeoutException("Failed to receive minimum acknowledments of " + this.threshold + " received :" + this.ackSet.size());
                }
            }
        }
    }

    private void processRoute(Message msg) {
        try {
            MessageElement routeElement = msg.getMessageElement(NAMESPACE, ROUTEADV);
            if (routeElement != null && this.routeControl != null) {
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)routeElement.getMimeType(), (InputStream)routeElement.getStream());
                RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((XMLElement)asDoc);
                this.routeControl.addRoute(route);
            }
        }
        catch (IOException io) {
            LOG.log(Level.WARNING, io.getLocalizedMessage(), io);
        }
    }
}

