/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.bean;

import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.jbi.jsf.bean.ArchiveBean;
import com.sun.jbi.jsf.bean.ComponentConfigurationEntry;
import com.sun.jbi.jsf.bean.ShowBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.jsf.util.ValidationUtilities;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIComponentConfigBean {
    private static Logger logger = JBILogger.getInstance();
    private static final String XPATH_CONFIGURATION = "/jbi/component/Configuration";
    private ObjectListDataProvider componentConfigurationDataProvider;
    private ObjectListDataProvider componentNewConfigurationDataProvider;
    private boolean isDomainDataSource;
    private boolean isDiffrentComponent = true;
    private boolean isValidComponent;

    public TableDataProvider getComponentNewConfigurationData() {
        ArrayList newConfigData = new ArrayList();
        this.componentNewConfigurationDataProvider = new ObjectListDataProvider(newConfigData);
        if (!this.isValidComponent) {
            return this.componentNewConfigurationDataProvider;
        }
        logger.fine("JBIComponentConfigBean.getNewComponentConfigurationeData(): result=" + this.componentNewConfigurationDataProvider);
        return this.componentNewConfigurationDataProvider;
    }

    public TableDataProvider getComponentConfigurationData() {
        if (this.componentConfigurationDataProvider != null && !this.isDiffrentComponent) {
            this.componentConfigurationDataProvider.commitChanges();
        } else {
            logger.fine("JBIComponentConfigBean.getComponentConfigurationeData()");
            ArchiveBean archiveBean = BeanUtilities.getArchiveBean();
            List<ComponentConfigurationEntry> configProperties = null;
            configProperties = !this.isDomainDataSource ? this.parseConfigData(archiveBean) : this.getComponentConfigurationDataFromDomain();
            this.componentConfigurationDataProvider = new ObjectListDataProvider(configProperties);
            logger.fine("JBIComponentConfigBean.getComponentConfigurationeData(): configProperties=" + this.componentConfigurationDataProvider);
            this.isDiffrentComponent = false;
        }
        return this.componentConfigurationDataProvider;
    }

    private List<ComponentConfigurationEntry> parseJbiXMLData(Document jbiXMLDoc) {
        ArrayList<ComponentConfigurationEntry> configData = new ArrayList<ComponentConfigurationEntry>();
        logger.fine("JBIComponentConfigBean.parseJbiXMLData(): configProperties:");
        try {
            NodeList configurationNodes = XPathAPI.selectNodeList(jbiXMLDoc, XPATH_CONFIGURATION);
            if (configurationNodes.getLength() > 0) {
                NodeList configElementsList = configurationNodes.item(0).getChildNodes();
                int count = configElementsList.getLength();
                for (int i = 0; i < count; ++i) {
                    Node node = configElementsList.item(i);
                    if (node == null || !(node instanceof Element)) continue;
                    String name = node.getNodeName();
                    Text text = (Text)node.getChildNodes().item(0);
                    String value = null;
                    if (text != null) {
                        value = text.getData();
                    }
                    if (name == null) continue;
                    if (value == null) {
                        value = "";
                    }
                    name = name.substring(name.lastIndexOf(":") + 1);
                    logger.fine("name=" + name + " value=" + value);
                    ComponentConfigurationEntry entry = new ComponentConfigurationEntry(name, value, value, false);
                    configData.add(entry);
                }
            }
        }
        catch (Exception ex) {
            logger.fine("getType caught ex=" + ex);
            ex.printStackTrace(System.err);
        }
        return configData;
    }

    public Properties getConfigurationProperties() {
        Properties configProps = new Properties();
        if (this.componentConfigurationDataProvider != null && this.componentConfigurationDataProvider.getRowCount() > 0) {
            configProps = this.getPropertiesFromProvider(this.componentConfigurationDataProvider);
        }
        Properties additionalProperties = this.getPropertiesFromProvider(this.componentNewConfigurationDataProvider);
        configProps = this.mergeProperties(configProps, additionalProperties);
        return configProps;
    }

    public void invalidateCommittedDataProvider() {
        this.componentConfigurationDataProvider = null;
    }

    public String getDomainDataSource() {
        this.isDiffrentComponent = true;
        this.isDomainDataSource = true;
        return "domain";
    }

    public String getArchiveDataSource() {
        this.isDiffrentComponent = true;
        this.isDomainDataSource = false;
        return "Archive";
    }

    public String getBindorServiceComponent() {
        this.isValidComponent = true;
        return "component";
    }

    public String getAssemblyComponent() {
        this.isValidComponent = false;
        return "service-assembly";
    }

    public String getShareLibComponent() {
        this.isValidComponent = false;
        return "shared-false";
    }

    public boolean isConfigurationValidForComponent() {
        return this.isValidComponent;
    }

    private List<ComponentConfigurationEntry> getComponentConfigurationDataFromDomain() {
        List<ComponentConfigurationEntry> configData = new ArrayList<ComponentConfigurationEntry>();
        if (!this.isValidComponent) {
            return configData;
        }
        JBIAdminCommands jbiAdminCommands = BeanUtilities.getClient();
        logger.fine("JBIComponentConfigBean.getComponentConfigurationDataFromDomain(): JBIAdminCommands=" + jbiAdminCommands);
        ShowBean showBean = BeanUtilities.getShowBean();
        String componentName = showBean.getName();
        try {
            String jbiXMLData = jbiAdminCommands.getComponentInstallationDescriptor(componentName);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            InputSource inStream = new InputSource();
            inStream.setCharacterStream(new StringReader(jbiXMLData));
            Document jbiXMLDoc = db.parse(inStream);
            logger.fine("JBIComponentConfigBean.getComponentConfigurationDataFromDomain(): jbi.XML Document=" + jbiXMLDoc);
            JBIComponentConfigBean configBean = new JBIComponentConfigBean();
            configData = configBean.parseJbiXMLData(jbiXMLDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configData;
    }

    private Properties getPropertiesFromProvider(ObjectListDataProvider dataProvider) {
        logger.fine("JBIComponentConfigBean.getPropertiesFromProvider():");
        Properties configProps = new Properties();
        dataProvider.commitChanges();
        List origList = dataProvider.getList();
        for (ComponentConfigurationEntry entry : origList) {
            String name = entry.getName();
            String value = entry.getDefaultValue();
            String newValue = entry.getNewValue();
            if (newValue != null && !newValue.equals(value)) {
                value = newValue;
            }
            configProps.setProperty(name, value);
            logger.fine("name=" + name + " value=" + value);
        }
        return configProps;
    }

    private Properties mergeProperties(Properties configProps, Properties newProperties) {
        Properties jbiXMLProps = configProps;
        Set<Object> keys = newProperties.keySet();
        for (String string : keys) {
            String value = (String)newProperties.get(string);
            jbiXMLProps.setProperty(string, value);
        }
        return jbiXMLProps;
    }

    private List<ComponentConfigurationEntry> parseConfigData(ArchiveBean archiveBean) {
        ArrayList<ComponentConfigurationEntry> configData = new ArrayList<ComponentConfigurationEntry>();
        if (!archiveBean.getHasJbiXml() || !this.isValidComponent) {
            return configData;
        }
        Document jbiXMLDoc = ValidationUtilities.getJbiDocument();
        return this.parseJbiXMLData(jbiXMLDoc);
    }
}

