/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.bean;

import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIRemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ServiceUnitBean {
    private static final String DEFAULT_RESULT = "";
    private Logger sLog = JBILogger.getInstance();
    private JBIAdminCommands mJac;
    private List mServiceUnitsList = new ArrayList();
    private String mServiceAssemblyName = null;
    private String mTargetComponent = null;
    private String mComponentType = null;
    private String mDescription = null;
    private String mServiceUnitName = null;

    public ServiceUnitBean() {
        this.mJac = BeanUtilities.getClient();
    }

    public String getDeploymentDescriptor() {
        String result = DEFAULT_RESULT;
        try {
            if (null != this.mJac) {
                this.sLog.fine("ServiceUnitBean.getDeploymentDescriptor(), mJac=" + this.mJac + ", mServiceUnitName=" + this.mServiceUnitName);
                result = this.mJac.getServiceUnitDeploymentDescriptor(this.mServiceAssemblyName, this.mServiceUnitName);
            }
        }
        catch (JBIRemoteException jrEx) {
            this.sLog.fine("ServiceUnitBean.querySuDeploymentDescriptor(), caught jrEx=" + (Object)((Object)jrEx));
            jrEx.printStackTrace();
        }
        this.sLog.fine("ServiceUnitBean.getDeploymentDescriptor(),result=" + result);
        return result;
    }

    public List getServiceUnitsList() {
        return this.mServiceUnitsList;
    }

    public String getServiceAssemblyName() {
        return this.mServiceAssemblyName;
    }

    public String getTargetComponent() {
        return this.mTargetComponent;
    }

    public String getComponentType() {
        return this.mComponentType;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getName() {
        return this.mServiceUnitName;
    }

    public String getComponentTypeIcon() {
        String iconFileName = DEFAULT_RESULT;
        if (this.mComponentType.equals("binding-component")) {
            iconFileName = "JBIBindingComponent.gif";
        } else if (this.mComponentType.equals("service-engine")) {
            iconFileName = "JBIServiceEngine.gif";
        }
        return iconFileName;
    }

    public TableDataProvider getServiceUnitsTableData() {
        this.sLog.fine("ShowBean.getServiceUnitsTableData()");
        ObjectListDataProvider result = new ObjectListDataProvider(this.mServiceUnitsList);
        this.sLog.fine("ShowBean.getServiceUnitsTableData(): result=" + result);
        return result;
    }

    public void setServiceUnitsList(List aServiceUnitsList) {
        this.sLog.fine("ShowBean.setServiceUnitsList(" + aServiceUnitsList + ")");
        this.mServiceUnitsList = aServiceUnitsList;
    }

    public void setServiceAssemblyName(String aName) {
        this.mServiceAssemblyName = aName;
    }

    public void setTargetComponent(String aName) {
        this.mTargetComponent = aName;
    }

    public void setComponentType(String aType) {
        this.mComponentType = aType;
    }

    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    public void setName(String aServiceUnitName) {
        this.mServiceUnitName = aServiceUnitName;
    }
}

