/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.common;

import com.sun.jbi.jsf.framework.model.JBIServiceAssemblyStatus;
import com.sun.jbi.jsf.framework.model.JBIServiceAssemblyStatusDocument;
import com.sun.jbi.jsf.framework.model.JBIServiceUnitStatus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceAssemblyInformationParser
extends DefaultHandler
implements Serializable {
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private JBIServiceAssemblyStatus serviceAssemblyStatus = null;
    private JBIServiceUnitStatus serviceUnitStatus = null;
    private JBIServiceAssemblyStatusDocument saDocument = new JBIServiceAssemblyStatusDocument();

    public JBIServiceAssemblyStatusDocument getDocument() {
        return this.saDocument;
    }

    public void setDocument(JBIServiceAssemblyStatusDocument jbiDocument) {
        this.saDocument = jbiDocument;
    }

    public static JBIServiceAssemblyStatusDocument parse(String documentString) throws IOException, SAXException, FileNotFoundException, ParserConfigurationException, SAXException {
        JBIServiceAssemblyStatusDocument container = null;
        if (documentString == null) {
            return container;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        StringReader reader = new StringReader(documentString);
        InputSource inputSource = new InputSource(reader);
        ServiceAssemblyInformationParser myEventHandler = new ServiceAssemblyInformationParser();
        if (inputSource != null) {
            saxParser.parse(inputSource, (DefaultHandler)myEventHandler);
            container = myEventHandler.getDocument();
        }
        return container;
    }

    public static JBIServiceAssemblyStatusDocument parse(File documentFile) throws IOException, SAXException, FileNotFoundException, ParserConfigurationException, SAXException {
        JBIServiceAssemblyStatusDocument container = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        FileReader reader = new FileReader(documentFile);
        InputSource inputSource = new InputSource(reader);
        ServiceAssemblyInformationParser myEventHandler = new ServiceAssemblyInformationParser();
        saxParser.parse(inputSource, (DefaultHandler)myEventHandler);
        container = myEventHandler.getDocument();
        return container;
    }

    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
        this.saDocument.getJbiServiceAssemblyStatusList().clear();
    }

    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("service-assembly-info-list".equals(qName)) {
            String key = null;
            String value = null;
            for (int index = 0; index < attributes.getLength(); ++index) {
                key = attributes.getQName(index);
                if (key != null && (value = attributes.getValue(key)) == null) continue;
            }
        } else {
            int index;
            String value;
            String key;
            if ("service-assembly-info".equals(qName)) {
                this.serviceAssemblyStatus = new JBIServiceAssemblyStatus();
                key = null;
                value = null;
                for (index = 0; index < attributes.getLength(); ++index) {
                    key = attributes.getQName(index);
                    if (key == null || (value = attributes.getValue(key)) == null) continue;
                    if (key.equals("name")) {
                        this.serviceAssemblyStatus.setServiceAssemblyName(value);
                    }
                    if (!key.equals("state")) continue;
                    this.serviceAssemblyStatus.setStatus(value);
                }
            }
            if ("service-unit-info".equals(qName)) {
                this.serviceUnitStatus = new JBIServiceUnitStatus();
                key = null;
                value = null;
                for (index = 0; index < attributes.getLength(); ++index) {
                    key = attributes.getQName(index);
                    if (key == null || (value = attributes.getValue(key)) == null) continue;
                    if (key.equals("name")) {
                        this.serviceUnitStatus.setServiceUnitName(value);
                    }
                    if (key.equals("state")) {
                        this.serviceUnitStatus.setStatus(value);
                    }
                    if (!key.equals("deployed-on")) continue;
                    this.serviceUnitStatus.setTargetName(value);
                }
            }
        }
        this.qNameStack.push(qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if ("service-assembly-info-list".equals(qName)) {
            // empty if block
        }
        if ("service-assembly-info".equals(qName)) {
            // empty if block
        }
        if ("description".equals(qName)) {
            if (this.serviceAssemblyStatus != null && chars != null && this.serviceUnitStatus == null) {
                this.serviceAssemblyStatus.setServiceAssemblyDescription(chars);
            }
            if (this.serviceUnitStatus != null && chars != null) {
                this.serviceUnitStatus.setServiceUnitDescription(chars);
            }
        }
        if ("name".equals(qName)) {
            if (this.serviceAssemblyStatus != null && chars != null && this.serviceUnitStatus == null) {
                this.serviceAssemblyStatus.setServiceAssemblyName(chars);
            }
            if (this.serviceUnitStatus != null && chars != null) {
                this.serviceUnitStatus.setServiceUnitName(chars);
            }
        }
        if ("status".equals(qName)) {
            if (this.serviceAssemblyStatus != null && chars != null && this.serviceUnitStatus == null) {
                this.serviceAssemblyStatus.setStatus(chars);
            }
            if (this.serviceUnitStatus != null && chars != null) {
                this.serviceUnitStatus.setStatus(chars);
            }
        }
        if ("target-name".equals(qName) && this.serviceUnitStatus != null && chars != null) {
            this.serviceUnitStatus.setTargetName(chars);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (!"service-assembly-info-list".equals(qName)) {
            if ("service-assembly-info".equals(qName)) {
                this.saDocument.addJbiServiceAssemblyStatus(this.serviceAssemblyStatus);
                this.serviceAssemblyStatus = null;
            }
            if ("service-unit-info".equals(qName)) {
                this.serviceAssemblyStatus.addJbiServiceUnitStatus(this.serviceUnitStatus);
                this.serviceUnitStatus = null;
            }
        }
    }

    public static void main(String[] args) {
    }
}

