/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.handlers;

import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.enterprise.tools.admingui.handlers.ConfigurationHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jbi.jsf.bean.AlertBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.ClusterUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.faces.model.SelectItem;

public class InstanceSelectionHandlers {
    private static Logger sLog = JBILogger.getInstance();

    public static void jbiGetRuntimeInstances(HandlerContext handlerCtx) {
        String componentType = (String)handlerCtx.getInputValue("componentType");
        String componentName = (String)handlerCtx.getInputValue("componentName");
        List instanceList = ClusterUtilities.findAllNonDomainTargets();
        instanceList.add(0, "domain");
        String[] instances = new String[]{};
        instances = instanceList.toArray(instances);
        SelectItem[] options = ConfigurationHandlers.getOptions((String[])instances);
        handlerCtx.setOutputValue("InstanceList", (Object)options);
        sLog.fine("InstanceSelectionHandlers.jbiGetRuntimeInstances(), options.length=" + options.length);
    }

    public static void jbiGetInstances(HandlerContext handlerCtx) {
        String componentType = (String)handlerCtx.getInputValue("componentType");
        String componentName = (String)handlerCtx.getInputValue("componentName");
        ArrayList<String> installedInstanceList = new ArrayList<String>();
        ArrayList<String> installedTargetList = new ArrayList<String>();
        List installedList = ClusterUtilities.findTargetsForNameByType(componentName, componentType);
        for (Properties targetProp : installedList) {
            String target = targetProp.getProperty("name");
            installedTargetList.add(target);
        }
        for (String target : installedTargetList) {
            if (ClusterUtilities.isCluster(target)) {
                sLog.fine("InstanceSelectionHandlers.jbiGetInstances(), cluster target=" + target);
                Map serverMap = ((ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(target)).getClusteredServerConfigMap();
                ArrayList<String> instancesForOneCluster = new ArrayList<String>();
                if (null != serverMap) {
                    for (String key : serverMap.keySet()) {
                        String name = ((ClusteredServerConfig)serverMap.get(key)).getName();
                        J2EEServer server = (J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(name);
                        int state = server.getstate();
                        if (state == 1) {
                            instancesForOneCluster.add(name);
                        }
                        sLog.fine("InstanceSelectionHandlers.jbiGetInstances(), cluster target=" + target + ", instanceName=" + name + ", state=" + state);
                    }
                }
                for (String instance : instancesForOneCluster) {
                    installedInstanceList.add(instance);
                }
                continue;
            }
            J2EEServer server = (J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(target);
            int state = server.getstate();
            if (state == 1) {
                installedInstanceList.add(target);
            }
            sLog.fine("InstanceSelectionHandlers.jbiGetInstances(), stand-alone server target=" + target + ", state=" + state);
        }
        String alertType = "";
        String alertDetails = "";
        String alertSummary = "";
        boolean isAlertNeeded = false;
        if (installedInstanceList.size() == 0) {
            isAlertNeeded = true;
            alertType = "warning";
            alertSummary = I18nUtilities.getResourceString("jbi.component.not.installed.to.target.summary");
            Object[] args = new Object[]{componentName};
            alertDetails = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.component.not.installed.to.target.details"), (Object[])args);
            AlertBean alertBean = BeanUtilities.getAlertBean();
            alertBean.setAlertType(alertType);
        }
        String[] instances = new String[]{};
        instances = installedInstanceList.toArray(instances);
        SelectItem[] options = ConfigurationHandlers.getOptions((String[])instances);
        handlerCtx.setOutputValue("InstanceList", (Object)options);
        handlerCtx.setOutputValue("isAlertNeeded", (Object)isAlertNeeded);
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
        sLog.fine("InstanceSelectionHandlers.jbiGetInstances(), options.length=" + options.length);
    }

    public static void jbiSetDefaultSelectedInstances(HandlerContext handlerCtx) {
        String fromInstance = (String)handlerCtx.getInputValue("fromInstance");
        String[] result = new String[]{fromInstance};
        sLog.fine("InstanceSelectionHandlers.jbiSetDefaultSelectedInstances(" + fromInstance + "), result.length=" + result.length);
        handlerCtx.setOutputValue("toInstances", (Object)result);
    }

    public static void jbiObjectArrayToStringArray(HandlerContext handlerCtx) {
        String[] result;
        Object[] fromObjectArray = (Object[])handlerCtx.getInputValue("fromObjectArray");
        if (null != fromObjectArray) {
            result = new String[fromObjectArray.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (String)fromObjectArray[i];
            }
        } else {
            result = new String[]{};
        }
        sLog.fine("InstanceSelectionHandlers.jbiObjectArrayToStringArray(" + fromObjectArray + "), result.length=" + result.length);
        handlerCtx.setOutputValue("toStringArray", (Object)result);
    }

    public static void jbiListArrayStrings(HandlerContext handlerCtx) {
        String result = "list: [";
        Object[] fromStringArray = (Object[])handlerCtx.getInputValue("fromStringArray");
        for (int i = 0; i < fromStringArray.length; ++i) {
            result = result + (String)fromStringArray[i];
            result = result + ", ";
        }
        result = result + " ]";
        sLog.fine("InstanceSelectionHandlers.jbiListArrayStrings(" + fromStringArray + "), result=" + result);
        handlerCtx.setOutputValue("toStringWithCommas", (Object)result);
    }
}

