/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.handlers;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.jbi.jsf.bean.ListBean;
import com.sun.jbi.jsf.bean.SelectableTargetInfo;
import com.sun.jbi.jsf.bean.ShowBean;
import com.sun.jbi.jsf.bean.TargetBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.ClusterUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.TableRowGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class QueryHandlers {
    public static final String TBL_PAGE_TYPE_BINDINGS_ENGINES = "bindingsEngines";
    public static final String TBL_PAGE_TYPE_DEPLOYMENTS = "deployments";
    public static final String TBL_PAGE_TYPE_LIBRARIES = "libraries";
    private static Logger sLog = JBILogger.getInstance();

    public static void jbiSetComponentsForTarget(HandlerContext handlerCtx) {
        String targetName = (String)handlerCtx.getInputValue("targetName");
        sLog.fine("QueryHandlers.jbiSetComponentsForTarget(...), targetName=" + targetName);
        List componentsList = ClusterUtilities.findBindingComponentsForTarget(targetName);
        componentsList.addAll(ClusterUtilities.findServiceEnginesForTarget(targetName));
        TargetBean targetBean = BeanUtilities.getTargetBean();
        sLog.fine("QueryHandlers.jbiSetComponentsForTarget(...), componentsList=" + componentsList);
        targetBean.setComponentsList(componentsList);
    }

    public static void jbiSetDeploymentsForTarget(HandlerContext handlerCtx) {
        String targetName = (String)handlerCtx.getInputValue("targetName");
        sLog.fine("QueryHandlers.jbiSetDeploymentsForTarget(...), targetName=" + targetName);
        List deploymentsList = ClusterUtilities.findServiceAssembliesForTarget(targetName);
        TargetBean targetBean = BeanUtilities.getTargetBean();
        targetBean.setDeploymentsList(deploymentsList);
    }

    public static void jbiSetLibrariesForTarget(HandlerContext handlerCtx) {
        String targetName = (String)handlerCtx.getInputValue("targetName");
        sLog.fine("QueryHandlers.jbiSetLibrariesForTarget(...), targetName=" + targetName);
        List librariesList = ClusterUtilities.findSharedLibrariesForTarget(targetName);
        TargetBean targetBean = BeanUtilities.getTargetBean();
        targetBean.setLibrariesList(librariesList);
    }

    public static void jbiSetFilteredTargetsList(HandlerContext handlerCtx) {
        ArrayList<SelectableTargetInfo> filteredTargetsList = new ArrayList<SelectableTargetInfo>();
        String pageName = (String)handlerCtx.getInputValue("pageName");
        List clustersList = (List)handlerCtx.getInputValue("clustersList");
        List serversList = (List)handlerCtx.getInputValue("serversList");
        sLog.fine("QueryHandlers.setFilteredTargetsList, handlerCtx.getInputValue(\"clustersList\")=" + clustersList + ", serversList=" + serversList + ", pageName=" + pageName);
        ShowBean showBean = BeanUtilities.getShowBean();
        ArrayList<Properties> allTargetsList = new ArrayList<Properties>();
        if (null != clustersList) {
            for (String clusterName : clustersList) {
                Properties clusterProps = new Properties();
                clusterProps.setProperty("name", clusterName);
                clusterProps.setProperty("type", "cluster");
                sLog.fine("QueryHandlers.jbiSetFilteredTargetsList(...), adding clusterProps=" + clusterProps);
                allTargetsList.add(clusterProps);
            }
        }
        if (null != serversList) {
            for (String serverName : serversList) {
                Properties serverProps = new Properties();
                serverProps.setProperty("name", serverName);
                serverProps.setProperty("type", "server");
                sLog.fine("QueryHandlers.jbiSetFilteredTargetsList(...), adding serverProps=" + serverProps);
                allTargetsList.add(serverProps);
            }
        }
        String filterState = "Show All";
        ArrayList filterStates = null;
        if (pageName.equalsIgnoreCase(TBL_PAGE_TYPE_BINDINGS_ENGINES)) {
            filterState = showBean.getFilterTargetComponentState();
            filterStates = showBean.getFilterTargetComponentStates();
        } else if (pageName.equalsIgnoreCase(TBL_PAGE_TYPE_DEPLOYMENTS)) {
            filterState = showBean.getFilterTargetAssemblyState();
            filterStates = showBean.getFilterTargetAssemblyStates();
        }
        for (Properties targetProps : allTargetsList) {
            String target = targetProps.getProperty("name");
            String type = targetProps.getProperty("type");
            String status = showBean.check(target);
            if (null == status) continue;
            sLog.fine("QueryHandlers.setFilteredTargetsList, target=" + target + ", status=" + status);
            SelectableTargetInfo selectableTarget = new SelectableTargetInfo(target, status, type);
            if (!BeanUtilities.checkFilterOptions(selectableTarget.getStatus(), filterState, filterStates)) continue;
            filteredTargetsList.add(selectableTarget);
        }
        sLog.fine("QueryHandlers.setFilteredTargetsList, filteredTargetsList=" + filteredTargetsList);
        showBean.setTargetsList(filteredTargetsList);
    }

    public static void setJBIComponentId(HandlerContext handlerCtx) {
        String componentName = (String)handlerCtx.getInputValue("JBIComponentName");
        String componentType = (String)handlerCtx.getInputValue("JBIComponentType");
        sLog.fine("QueryHandlers.setJBIComponentId(JBIComponentName=" + componentName + ", JBIComponentType=" + componentType + ")");
        ShowBean showBean = BeanUtilities.getShowBean();
        showBean.setName(componentName);
        showBean.setType(componentType);
    }

    public static void setMetaDataContents(HandlerContext handlerCtx) {
        sLog.fine("DEPRECATED setMetaDataContents");
        String compName = (String)handlerCtx.getInputValue("compName");
        String compType = (String)handlerCtx.getInputValue("compType");
        ShowBean showBean = BeanUtilities.getShowBean();
        showBean.setName(compName);
        showBean.setType(compType);
    }

    private static List getSelectedRowProperties(TableRowGroup aGroup) {
        ArrayList<Properties> result = new ArrayList<Properties>();
        ObjectListDataProvider dp = (ObjectListDataProvider)aGroup.getSourceData();
        if (null != dp) {
            try {
                FieldKey fkName = dp.getFieldKey("name");
                FieldKey fkType = dp.getFieldKey("type");
                RowKey[] rowKeys = aGroup.getSelectedRowKeys();
                for (int cnt = 0; cnt < rowKeys.length; ++cnt) {
                    Properties selectedRowProperties = new Properties();
                    String compName = (String)dp.getValue(fkName, rowKeys[cnt]);
                    selectedRowProperties.setProperty("name", compName);
                    String compType = (String)dp.getValue(fkType, rowKeys[cnt]);
                    selectedRowProperties.setProperty("type", compType);
                    result.add(selectedRowProperties);
                }
            }
            catch (Exception ex) {
                sLog.fine("QueryHandlers.getSelectedRowProperties(), caught ex=" + ex);
                ex.printStackTrace(System.err);
            }
        } else {
            sLog.fine("QueryHandlers.getSelectedRowProperties(), cannot process dp=" + dp);
        }
        sLog.fine("QueryHandlers.getSelectedRowProperties(), result=" + result);
        return result;
    }

    public static void setSharedTableData(HandlerContext context) {
        String tableType = (String)context.getInputValue("tableType");
        sLog.fine("QueryHandlers.setSharedTableData(), tableType=" + tableType);
        ListBean listBean = BeanUtilities.getListBean();
        if (TBL_PAGE_TYPE_BINDINGS_ENGINES.equals(tableType)) {
            listBean.setBindingsEnginesTableData();
        } else if (TBL_PAGE_TYPE_DEPLOYMENTS.equals(tableType)) {
            listBean.setDeploymentsTableData();
        } else if (TBL_PAGE_TYPE_LIBRARIES.equals(tableType)) {
            listBean.setLibrariesTableData();
        }
    }

    public static void jbiGetWormholeLinkForName(HandlerContext handlerCtx) {
        String result = "";
        String clusterOrServerName = (String)handlerCtx.getInputValue("clusterOrServerName");
        if (ClusterUtilities.isCluster(clusterOrServerName)) {
            result = "cluster/clusterGeneral.jsf?clusterName=" + clusterOrServerName;
        } else if (ClusterUtilities.isServer(clusterOrServerName)) {
            result = "standalone/standaloneInstanceGeneral.jsf?instanceName=" + clusterOrServerName;
        }
        handlerCtx.setOutputValue("wormholeLink", (Object)result);
        sLog.fine("QueryHandlers.jbiGetWormholeLinkForName(...),  clusterOrServerName=" + clusterOrServerName + ", result=" + result);
    }

    public static void jbiLogFine(HandlerContext handlerCtx) {
        String where = (String)handlerCtx.getInputValue("where");
        String diagnostic = (String)handlerCtx.getInputValue("diagnostic");
        sLog.fine("QueryHandlers.jbiLogFine: where=[" + where + "], diagnostic=" + diagnostic);
    }

    public static void jbiSetDependencies(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        String name = (String)handlerCtx.getInputValue("name");
        sLog.fine("QueryHandlers.jbiSetDependencies: type=[" + type + "], name=" + name);
        ListBean listBean = BeanUtilities.getListBean();
        listBean.setSharedDepsTableData(type, name);
    }
}

