/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.handlers;

import com.sun.enterprise.tools.admingui.util.FileUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jbi.jsf.bean.AlertBean;
import com.sun.jbi.jsf.bean.UploadCopyRadioBean;
import com.sun.jbi.jsf.handlers.JbiArchiveValidationHandler;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.logging.Logger;

public class UpgradeComponentHandlers {
    private static Logger sLog = JBILogger.getInstance();

    public static void jbiUpgradeComponent(HandlerContext handlerCtx) {
        String redirectOnSuccess;
        String archivePath = (String)handlerCtx.getInputValue("archivePath");
        String jbiName = (String)handlerCtx.getInputValue("jbiName");
        String compType = (String)handlerCtx.getInputValue("compType");
        String redirectOnFailure = (String)handlerCtx.getInputValue("redirectOnFailure");
        String redirectTo = redirectOnSuccess = (String)handlerCtx.getInputValue("redirectOnSuccess");
        sLog.fine("UpgradeComponentHandlers.jbiUpgradeCompoent(...), archivePath=" + archivePath + ", jbiName=" + jbiName + ", redirectOnFailure=" + redirectOnFailure + ", redirectOnSuccess=" + redirectOnSuccess);
        String alertDetails = "";
        String alertSummary = "";
        String internalError = "";
        String successResult = "";
        String failureResult = "";
        boolean isAlertNeeded = true;
        boolean isRedirectSuccess = true;
        AlertBean alertBean = BeanUtilities.getAlertBean();
        UploadCopyRadioBean uploadCpBean = BeanUtilities.getUploadCopyRadioBean();
        uploadCpBean.setNavDestValid(redirectOnSuccess);
        uploadCpBean.setNavDestInvalid(redirectOnFailure);
        try {
            String invalidAlertDetail = JbiArchiveValidationHandler.checkValidArchive(archivePath, compType);
            if ("".equals(invalidAlertDetail)) {
                JBIAdminCommands jac = BeanUtilities.getClient();
                successResult = jac.updateComponent(jbiName, archivePath);
            } else {
                failureResult = invalidAlertDetail;
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            JBIManagementMessage mgmtMsg = BeanUtilities.extractJBIManagementMessage((Exception)((Object)jbiRemoteEx));
            sLog.fine("UpgradeComponentHandlers.jbiUpgradeComponent(...), caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx) + ", mgmtMsg=" + mgmtMsg);
            if (null == mgmtMsg) {
                failureResult = jbiRemoteEx.getMessage();
                if (null == failureResult) {
                    failureResult = jbiRemoteEx.toString();
                }
            }
            failureResult = mgmtMsg.getMessage();
        }
        sLog.fine("UpgradeComponentHandlers.jbiUpgradeComponent(...), jbiName=" + jbiName + ", archiivePath=" + archivePath + ", successResult=" + successResult + ", failureResult=" + failureResult + ", internalError=" + internalError);
        if (!"".equals(internalError)) {
            isRedirectSuccess = false;
            alertBean.setAlertType("error");
            alertSummary = I18nUtilities.getResourceString("jbi.internal.error.summary");
            alertDetails = alertDetails + internalError + "<br />";
        }
        if (!"".equals(successResult)) {
            alertBean.setAlertType("info");
            alertSummary = I18nUtilities.getResourceString("jbi.upgrade.success.alert.summary.text");
        } else {
            isRedirectSuccess = false;
            alertBean.setAlertType("error");
            alertSummary = I18nUtilities.getResourceString("jbi.upgrade.failed.alert.summary.text");
            alertDetails = alertDetails + failureResult + "<br />";
        }
        if (isRedirectSuccess) {
            alertDetails = "Upgrade of " + jbiName + " completed.";
            Object[] args = new Object[]{jbiName};
            alertDetails = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.upgrade.component.success.details"), (Object[])args);
            redirectTo = redirectOnSuccess;
        } else {
            alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
            redirectTo = redirectOnFailure;
        }
        if (((Boolean)handlerCtx.getInputValue("uploadSelected")).booleanValue()) {
            sLog.fine("UpgradeComponentHandlers.jbiUpgradeComponent(...),to delete uploaded tmp file=" + archivePath);
            FileUtil.delete((String)archivePath);
        }
        handlerCtx.setOutputValue("isAlertNeeded", (Object)Boolean.toString(isAlertNeeded));
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
        handlerCtx.setOutputValue("redirectTo", (Object)redirectTo);
        sLog.fine("UpgradeComponentHandlers.jbiUpgradeValidatedArchive(...),  isAlertNeeded=" + isAlertNeeded + " isRedirectSuccess=" + isRedirectSuccess + ", alertSummary=" + alertSummary + ", alertDetails=" + alertDetails + ", redirectTo=" + redirectTo);
    }
}

