/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.enterprise.admin.common.JMXFileTransfer;
import com.sun.enterprise.cli.commands.BaseTransformationRuleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.io.File;
import java.io.IOException;
import javax.management.MBeanServerConnection;

public class CreateTransformationRuleCommand
extends BaseTransformationRuleCommand {
    private static final String RULE_LOCATION_OPTION = "rulefilelocation";
    private static final String APPLY_TO_OPTION = "applyto";
    private static final String ENABLED_OPTION = "enabled";
    private static final String WEB_SERVICE_OPTION = "webservicename";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            String webServiceName = this.getOption(WEB_SERVICE_OPTION);
            this.validateWebServiceName(webServiceName, true);
            WebServiceEndpointConfig wsc = this.getWebServiceEndpointConfig(mbsc, webServiceName, true);
            if (wsc == null) {
                throw new CommandException(this.getLocalizedString("CannotFindWebservice"));
            }
            String ruleName = (String)this.getOperands().get(0);
            String ruleLocation = this.getOption(RULE_LOCATION_OPTION);
            boolean enabled = this.getBooleanOption(ENABLED_OPTION);
            String applyTo = this.getOption(APPLY_TO_OPTION);
            File ruleFile = new File(ruleLocation);
            String msg = null;
            if (!ruleFile.exists()) {
                msg = this.getLocalizedString("FileDoesNotExist", new Object[]{ruleLocation});
            } else if (ruleFile.length() <= 0L) {
                msg = this.getLocalizedString("FileIsEmpty", new Object[]{ruleLocation});
            } else if (!ruleFile.canRead()) {
                msg = this.getLocalizedString("FileNotReadable", new Object[]{ruleLocation});
            }
            if (msg != null) {
                throw new CommandValidationException(msg);
            }
            String remoteLocation = this.uploadFileToServer(mbsc);
            CLILogger.getInstance().printDebugMessage("uploadedFile = " + remoteLocation);
            wsc.createTransformationRuleConfig(ruleName, remoteLocation, enabled, applyTo, null);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private String uploadFileToServer(MBeanServerConnection mbsc) throws CommandException, IOException {
        String ruleLocation = this.getOption(RULE_LOCATION_OPTION);
        return new JMXFileTransfer(mbsc).uploadFile(ruleLocation);
    }
}

