/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.enterprise.cli.commands.BaseTransformationRuleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Set;
import javax.management.MBeanServerConnection;

public class DeleteTransformationRuleCommand
extends BaseTransformationRuleCommand {
    private static final String WEB_SERVICE_OPTION = "webservicename";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            String webServiceName = this.getOption(WEB_SERVICE_OPTION);
            this.validateWebServiceName(webServiceName, true);
            WebServiceEndpointConfig wsc = this.getWebServiceEndpointConfig(mbsc, webServiceName, false);
            if (wsc == null) {
                throw new CommandException(this.getLocalizedString("CannotFindWebservice"));
            }
            String ruleName = (String)this.getOperands().get(0);
            wsc.removeTransformationRuleConfig(ruleName);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private WebServiceEndpointConfig getWebServiceEndpointConfig(Set s) throws CommandException {
        String fqWebServiceName = this.getOption(WEB_SERVICE_OPTION);
        int firstHashIdx = fqWebServiceName.indexOf("#");
        String wsName = null;
        if (firstHashIdx != -1) {
            if (firstHashIdx + 1 == fqWebServiceName.length()) {
                throw new CommandException(this.getLocalizedString("InvalidFormatForWebservice"));
            }
        } else {
            throw new CommandException(this.getLocalizedString("InvalidFormatForWebservice"));
        }
        wsName = fqWebServiceName.substring(firstHashIdx + 1);
        for (WebServiceEndpointConfig wsc : s) {
            CLILogger.getInstance().printDebugMessage(wsc.getName());
            if (!wsc.getName().equals(wsName)) continue;
            return wsc;
        }
        return null;
    }
}

