/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.AddonControl;
import com.sun.enterprise.cli.commands.BaseLifeCycleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.io.File;

public class InstallAddonCommand
extends BaseLifeCycleCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String addonJar = null;
        try {
            addonJar = (String)this.operands.firstElement();
            File addonJarFile = new File(addonJar);
            if (!addonJarFile.isFile() || !addonJarFile.exists()) {
                throw new CommandException(this.getLocalizedString("InvalidAddonFile", new Object[]{addonJar}));
            }
            AddonControl ac = new AddonControl();
            ac.install(addonJarFile);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Throwable t) {
            CLILogger.getInstance().printDetailMessage(t.getLocalizedMessage());
            throw new CommandException(this.getLocalizedString("InstallAddonFailed", new Object[]{addonJar}));
        }
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("InstallAddonCompleted", new Object[]{addonJar}));
    }
}

