/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.enterprise.cli.commands.BaseTransformationRuleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;

public class ListTransformationRulesCommand
extends BaseTransformationRuleCommand {
    private static final String WEB_SERVICE_OPTION = "webservicename";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            String webServiceName = this.getOption(WEB_SERVICE_OPTION);
            this.validateWebServiceName(webServiceName, false);
            boolean nothingToList = this.listTransformationRules(mbsc);
            if (nothingToList) {
                CLILogger.getInstance().printMessage(this.getLocalizedString("NoElementsToList"));
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private boolean listTransformationRules(MBeanServerConnection mbsc) throws CommandException, CommandValidationException {
        String webServiceName = this.getOption(WEB_SERVICE_OPTION);
        if (webServiceName != null) {
            WebServiceEndpointConfig wsc = this.getWebServiceEndpointConfig(mbsc, webServiceName, false);
            if (wsc == null) {
                throw new CommandException(this.getLocalizedString("CannotFindWebservice"));
            }
            return this.displayTransformationRules(wsc);
        }
        DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
        Set s = domainRoot.getQueryMgr().queryJ2EETypeSet("X-WebServiceEndpointConfig");
        Iterator iter = s.iterator();
        boolean nothingToList = true;
        while (iter.hasNext()) {
            WebServiceEndpointConfig wsc = (WebServiceEndpointConfig)iter.next();
            if (wsc.getTransformationRuleConfigMap().size() <= 0) continue;
            CLILogger.getInstance().printMessage(wsc.getName());
            nothingToList = this.displayTransformationRules(wsc);
        }
        return nothingToList;
    }

    private boolean displayTransformationRules(WebServiceEndpointConfig wsc) throws CommandException {
        Map rules = wsc.getTransformationRuleConfigMap();
        for (Object key : rules.keySet()) {
            CLILogger.getInstance().printMessage((String)key);
        }
        return rules.size() <= 0;
    }
}

