/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ICommand;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.OptionsMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Command
implements ICommand {
    private static final char REPLACE_START_CHAR = '{';
    private static final char REPLACE_END_CHAR = '}';
    private static final char VARIABLE_START_CHAR = '$';
    private static final char OPERAND_START_CHAR = '#';
    private static final String PATTERN_MATCHING = "\\{([\\$\\#])(\\w[\\w\\-]*)\\}";
    protected String name = null;
    protected OptionsMap optionsMap;
    protected Vector operands = new Vector();
    protected String usageStr = null;
    protected Hashtable properties;

    public Command() {
        this.optionsMap = new OptionsMap();
    }

    public abstract void runCommand() throws CommandException, CommandValidationException;

    public abstract boolean validateOptions() throws CommandValidationException;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Vector getOperands() {
        return this.operands;
    }

    public void setOperands(Vector operands) {
        this.operands = operands;
    }

    public Map getOptions() {
        return this.optionsMap.getOptions();
    }

    public Map getCLOptions() {
        return this.optionsMap.getCLOptions();
    }

    public Map getENVOptions() {
        return this.optionsMap.getEnvOptions();
    }

    public void setOptionsMap(OptionsMap options) {
        this.optionsMap = options;
    }

    public String getOption(String optionName) {
        return this.optionsMap.getOption(optionName);
    }

    public String getCLOption(String optionName) {
        Map<String, String> map = this.optionsMap.getCLOptions();
        return map.get(optionName);
    }

    public String getENVOption(String optionName) {
        Map<String, String> map = this.optionsMap.getEnvOptions();
        return map.get(optionName);
    }

    public String getOtherOption(String optionName) {
        Map<String, String> map = this.optionsMap.getOtherOptions();
        return map.get(optionName);
    }

    public void setOption(String optionName, String optionValue) {
        this.optionsMap.addOptionValue(optionName, optionValue);
    }

    protected boolean getBooleanOption(String optionName) {
        return Boolean.valueOf(this.getOption(optionName));
    }

    protected int getIntegerOption(String optionName) {
        assert (!this.optionNameExist(optionName));
        return Integer.valueOf(this.getOption(optionName));
    }

    private boolean optionNameExist(String optionName) {
        return this.optionsMap.containsName(optionName);
    }

    public String getUsageText() {
        return this.usageStr;
    }

    public void setUsageText(String usageText) {
        this.usageStr = usageText;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    protected Hashtable getProperties(String key) {
        return this.properties;
    }

    protected void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    protected String getLocalizedString(String key) {
        LocalStringsManager lsm = null;
        try {
            lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
        }
        catch (CommandValidationException cve) {
            return "Key not found";
        }
        return lsm.getString(key);
    }

    protected String getLocalizedString(String key, Object[] toInsert) {
        LocalStringsManager lsm = null;
        try {
            lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
            return lsm.getString(key, toInsert);
        }
        catch (CommandValidationException cve) {
            return "Key not found";
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.getName());
        Map<String, String> clOptions = this.optionsMap.getOptions();
        for (String optionKey : clOptions.keySet()) {
            strbuf.append(" --" + optionKey);
            String optionVal = clOptions.get(optionKey);
            if (Boolean.TRUE.toString().equalsIgnoreCase(optionVal) || Boolean.FALSE.toString().equalsIgnoreCase(optionVal)) {
                strbuf.append("=");
            } else {
                strbuf.append(" ");
            }
            strbuf.append(optionVal);
        }
        for (int ii = 0; ii < this.operands.size(); ++ii) {
            strbuf.append(" " + this.operands.get(ii).toString());
        }
        return strbuf.toString();
    }

    public String replacePattern(String replaceValue) throws CommandException {
        if (replaceValue == null) {
            return null;
        }
        Pattern patt = Pattern.compile(PATTERN_MATCHING);
        Matcher match = patt.matcher(replaceValue);
        String outstr = replaceValue;
        try {
            if (match.find()) {
                StringBuffer strbuf = new StringBuffer();
                do {
                    String value;
                    if ((value = this.findPatternStringValue(match.group(1), match.group(2))) == null) {
                        return value;
                    }
                    value = this.prepareStringForAppend(value);
                    match.appendReplacement(strbuf, value);
                    CLILogger.getInstance().printDebugMessage("strbuf = " + strbuf);
                } while (match.find());
                match.appendTail(strbuf);
                outstr = strbuf.toString();
            }
        }
        catch (IllegalArgumentException iae) {
            try {
                LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
                throw new CommandException(lsm.getString("RequireEscapeChar"), iae);
            }
            catch (CommandValidationException cve) {
                throw new CommandException(cve);
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
        return outstr.length() < 1 ? null : outstr;
    }

    private String findPatternStringValue(String pattern, String key) throws CommandException {
        String value = null;
        try {
            if (pattern.equals(String.valueOf('#'))) {
                if (this.operands.size() > 0) {
                    value = (String)this.getOperands().get(Integer.parseInt(key) - 1);
                }
            } else if (pattern.equals(String.valueOf('$'))) {
                value = this.getOption(key);
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
        return value;
    }

    private String prepareStringForAppend(String str) {
        String strTmp = this.escapeTheEscape(str);
        return this.addEscapeToLiteral(strTmp);
    }

    private String escapeTheEscape(String strToEscape) {
        StringBuffer strbuf = new StringBuffer();
        int previousIndex = 0;
        int index = strToEscape.indexOf("\\");
        while (index > -1) {
            if (index < strToEscape.length() - 1 && strToEscape.charAt(index + 1) == '$') {
                strbuf.append(strToEscape.substring(previousIndex, index));
            } else {
                strbuf.append(strToEscape.substring(previousIndex, index) + "\\\\");
            }
            previousIndex = index + 1;
            index = strToEscape.indexOf("\\", index + 1);
        }
        strbuf.append(strToEscape.substring(previousIndex));
        return strbuf.toString();
    }

    private String addEscapeToLiteral(String strToAdd) {
        StringBuffer strbuf = new StringBuffer();
        int previousIndex = 0;
        int index = strToAdd.indexOf(36);
        while (index > -1) {
            strbuf.append(strToAdd.substring(previousIndex, index) + "\\$");
            previousIndex = index + 1;
            index = strToAdd.indexOf(36, index + 1);
        }
        strbuf.append(strToAdd.substring(previousIndex));
        return strbuf.toString();
    }

    protected int getDelimeterIndex(String searchStr, String delimeter, int fromIndex) {
        return searchStr.indexOf(delimeter, fromIndex);
    }
}

