/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound;

import com.sun.genericra.AbstractXAResourceType;
import com.sun.genericra.XAResourceType;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SimpleXAResourceProxy
extends AbstractXAResourceType {
    private static Logger logger = LogUtils.getLogger();
    private Xid startxid = null;
    boolean endCalled = false;
    boolean torollback = true;
    private XAResource xar;

    public SimpleXAResourceProxy(XAResource xar) {
        this.xar = xar;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.debugxid("Commiting Simple inbound transaction ", xid);
        if (xid == null) {
            xid = this.startxid;
        }
        this._getXAResource().commit(xid, onePhase);
        this.debugxid("Commited Simple inbound transaction ", xid);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.debug("Ending simple inbound transaction " + this.convertFlag(flags));
        this.debugxid("Ending simple inbound transaction ", xid);
        if (this.endCalled) {
            return;
        }
        if (xid == null) {
            xid = this.startxid;
        }
        this.endCalled = true;
        this._getXAResource().end(xid, flags);
        this.debugxid("Ended simple inbound transaction ", xid);
    }

    public void forget(Xid xid) throws XAException {
        this._getXAResource().forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this._getXAResource().getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        XAResource inxa = xares;
        if (xares instanceof XAResourceType) {
            XAResourceType wrapper = (XAResourceType)((Object)xares);
            inxa = (XAResource)wrapper.getWrappedObject();
            if (!this.compare(wrapper)) {
                this.debug("isSameRM retursn /compare :false");
                return false;
            }
        }
        boolean result = this._getXAResource().isSameRM(inxa);
        this.debug("isSameRM retursn /compare :" + result);
        return result;
    }

    public int prepare(Xid xid) throws XAException {
        this.debugxid("Preparing simple inbound transaction with ID ", xid);
        if (xid == null) {
            xid = this.startxid;
        }
        return this._getXAResource().prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this._getXAResource().recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.debugxid("Rolling back simple inbound transaction with ID ", xid);
        if (xid == null) {
            xid = this.startxid;
        }
        if (this.torollback) {
            this._getXAResource().rollback(xid);
        }
        this.debugxid("Rolled back simple inbound transaction with ID ", xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this._getXAResource().setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.debug("Starting tx..." + this.convertFlag(flags));
        this.debugxid("Staring simple inbound transaction ", xid);
        this.startxid = xid;
        this._getXAResource().start(xid, flags);
        this.debugxid("Started simple inbound transaction ", xid);
    }

    private XAResource _getXAResource() throws XAException {
        return this.xar;
    }

    public void setToRollback(boolean rb) {
        this.torollback = rb;
    }

    public Object getWrappedObject() {
        return this.xar;
    }

    String convertFlag(int i) {
        if (i == 0x200000) {
            return "TMJOIN";
        }
        if (i == 0) {
            return "TMNOFLAGS";
        }
        if (i == 0x4000000) {
            return "TMSUCCESS";
        }
        if (i == 0x2000000) {
            return "TMSUSPEND";
        }
        if (i == 0x8000000) {
            return "TMRESUME";
        }
        return "" + i;
    }

    public void startDelayedXA() {
        throw new UnsupportedOperationException();
    }

    public boolean endCalled() {
        throw new UnsupportedOperationException();
    }

    void debug(String s) {
        logger.log(Level.FINEST, "SimpleXAResourceProxy :" + s);
    }

    void debugxid(String s, Xid xid) {
        if (logger.getLevel() == Level.FINEST) {
            logger.log(Level.FINEST, s + this.printXid(xid));
        }
    }
}

