/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.util;

import com.sun.genericra.GenericJMSRA;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.MethodExecutor;
import com.sun.genericra.util.StringManager;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;

public abstract class ObjectBuilder {
    private static Logger _logger = LogUtils.getLogger();
    private String setterMethodName = null;
    private String propString = null;
    private String separator = "=";
    private String delimiter = ",";
    private Object builtObject = null;
    private StringManager sm = StringManager.getManager(GenericJMSRA.class);

    protected ObjectBuilder() {
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setCommonSetterMethodName(String name) {
        this.setterMethodName = name;
    }

    public void setProperties(String props) {
        this.propString = props;
    }

    protected Hashtable parseToProperties(String prop) throws ResourceException {
        _logger.log(Level.FINE, "parseToProperties:" + prop + " delimited:" + this.delimiter + " seperator:" + this.separator);
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (prop == null || prop.trim().equals("")) {
            return result;
        }
        if (this.delimiter == null || this.delimiter.equals("")) {
            String msg = this.sm.getString("delim_not_specified");
            throw new ResourceException(msg);
        }
        StringTokenizer tokenList = new StringTokenizer(prop, this.delimiter);
        while (tokenList.hasMoreTokens()) {
            String propValuePair = tokenList.nextToken();
            _logger.log(Level.FINEST, "PropertyValuePair : " + propValuePair + ", separator:" + this.separator);
            int loc = propValuePair.indexOf(this.separator);
            String propName = propValuePair.substring(0, loc);
            String propValue = propValuePair.substring(loc + this.separator.length());
            _logger.log(Level.FINER, "Property : " + propName + ":" + propValue);
            result.put(propName, propValue);
        }
        return result;
    }

    public Object build() throws ResourceException {
        if (this.builtObject == null) {
            this.builtObject = this.createObject();
            _logger.log(Level.FINEST, "Created the object based on class :" + this.builtObject.getClass().getName());
            if (this.setterMethodName != null && !this.setterMethodName.trim().equals("")) {
                _logger.log(Level.FINEST, "About to set properties on " + this.builtObject + " using methodName :" + this.setterMethodName);
                this.setUsingCommonSetterMethod(this.builtObject, this.parseToProperties(this.propString));
            } else {
                _logger.log(Level.FINEST, "About to set properties on " + this.builtObject);
                this.setProperties(this.builtObject, this.parseToProperties(this.propString));
            }
        }
        return this.builtObject;
    }

    protected abstract Object createObject() throws ResourceException;

    private void setUsingCommonSetterMethod(Object obj, Hashtable props) throws ResourceException {
        Class[] params = new Class[]{String.class, String.class};
        try {
            Method m = obj.getClass().getMethod(this.setterMethodName, params);
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String key = (String)me.getKey();
                String value = (String)me.getValue();
                _logger.log(Level.FINER, "Setting property " + key + ":" + value + " on " + obj.getClass().getName());
                MethodExecutor.runJavaBeanMethod(key, value, m, obj);
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.newInvalidPropertyException(e);
        }
    }

    private void setProperties(Object obj, Hashtable props) throws ResourceException {
        try {
            Method[] methods = obj.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String propName;
                String name = methods[i].getName();
                if (!name.startsWith("set") || !props.containsKey(propName = name.substring(3))) continue;
                String propValue = (String)props.get(propName);
                _logger.log(Level.FINER, "Setting property " + propName + ":" + propValue + " on " + obj.getClass().getName());
                MethodExecutor.runJavaBeanMethod(propValue, methods[i], obj);
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.newInvalidPropertyException(e);
        }
    }
}

