/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.folb;

import com.sun.corba.ee.impl.folb.InitialGroupInfoService;
import com.sun.corba.ee.impl.interceptors.ClientRequestInfoImpl;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.spi.folb.CSIv2SSLTaggedComponentHandler;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfoHelper;
import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceBase;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.IIOPPrimaryToContactInfo;
import com.sun.corba.ee.spi.transport.IORToSocketInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ForwardRequestHelper;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientGroupManager
extends LocalObject
implements ClientRequestInterceptor,
GroupInfoService,
IIOPPrimaryToContactInfo,
IORToSocketInfo,
ORBConfigurator,
ORBInitializer {
    public final String baseMsg = ClientGroupManager.class.getName();
    private boolean debug = false;
    public static boolean sentMemberShipLabel = false;
    public static boolean receivedIORUpdate = false;
    private ORB orb;
    private Codec codec;
    private boolean initialized = false;
    private IOR lastIOR;
    private java.lang.Object lastIORLock = new java.lang.Object();
    private CSIv2SSLTaggedComponentHandler csiv2SSLTaggedComponentHandler;
    private GIS gis = new GIS();
    private Map map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.initialized) {
            return;
        }
        try {
            if (this.debug) {
                ClientGroupManager.dprint(".initialize->");
            }
            this.initialized = true;
            try {
                this.csiv2SSLTaggedComponentHandler = (CSIv2SSLTaggedComponentHandler)this.orb.resolve_initial_references("CSIv2SSLTaggedComponentHandler");
            }
            catch (InvalidName e) {
                this.csiv2SSLTaggedComponentHandler = null;
                ClientGroupManager.dprint(".initialize: not found: CSIv2SSLTaggedComponentHandler");
            }
            CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)this.orb.resolve_initial_references("CodecFactory"));
            this.codec = codecFactory.create_codec(new Encoding(0, 1, 2));
        }
        catch (InvalidName e) {
            ClientGroupManager.dprint(".initialize: " + (java.lang.Object)((java.lang.Object)e));
        }
        catch (UnknownEncoding e) {
            ClientGroupManager.dprint(".initialize: " + (java.lang.Object)((java.lang.Object)e));
        }
        finally {
            if (this.debug) {
                ClientGroupManager.dprint(".initialize<-");
            }
        }
    }

    public List getSocketInfo(IOR ior, List previous) {
        this.initialize();
        try {
            List csiv2;
            if (this.debug) {
                ClientGroupManager.dprint(".getSocketInfo->:");
            }
            if (this.csiv2SSLTaggedComponentHandler != null && (csiv2 = this.csiv2SSLTaggedComponentHandler.extract(ior)) != null) {
                List list = csiv2;
                return list;
            }
            if (this.debug) {
                ClientGroupManager.dprint(".getSocketInfo: handling non SSL socketInfo");
            }
            if (!previous.isEmpty()) {
                if (this.debug) {
                    ClientGroupManager.dprint(".getSocketInfo: returning previous socketInfo: " + previous);
                }
                csiv2 = previous;
                return csiv2;
            }
            ArrayList<com.sun.corba.ee.spi.transport.SocketInfo> result = new ArrayList<com.sun.corba.ee.spi.transport.SocketInfo>();
            IIOPProfileTemplate iiopProfileTemplate = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
            IIOPAddress primary = iiopProfileTemplate.getPrimaryAddress();
            String host = primary.getHost().toLowerCase();
            int port = primary.getPort();
            com.sun.corba.ee.spi.transport.SocketInfo primarySocketInfo = this.createSocketInfo("primary", "IIOP_CLEAR_TEXT", host, port);
            result.add(primarySocketInfo);
            Iterator<TaggedComponent> iterator = iiopProfileTemplate.iteratorById(1398099459);
            while (iterator.hasNext()) {
                ClusterInstanceInfo clusterInstanceInfo = this.extractClusterInstanceInfo(iterator.next());
                SocketInfo[] endpoints = clusterInstanceInfo.endpoints;
                for (int i = 0; i < endpoints.length; ++i) {
                    SocketInfo socketInfo = endpoints[i];
                    result.add(this.createSocketInfo("ClusterInstanceInfo.endpoint", socketInfo.type, socketInfo.host, socketInfo.port));
                }
            }
            iterator = iiopProfileTemplate.iteratorById(3);
            while (iterator.hasNext()) {
                AlternateIIOPAddressComponent alternate = (AlternateIIOPAddressComponent)iterator.next();
                host = alternate.getAddress().getHost().toLowerCase();
                port = alternate.getAddress().getPort();
                result.add(this.createSocketInfo("AlternateIIOPAddressComponent", "IIOP_CLEAR_TEXT", host, port));
            }
            ArrayList<com.sun.corba.ee.spi.transport.SocketInfo> arrayList = result;
            return arrayList;
        }
        catch (RuntimeException e) {
            ClientGroupManager.dprint(".getSocketInfo:", e);
            throw e;
        }
        catch (Exception e) {
            ClientGroupManager.dprint(".getSocketInfo:", e);
            RuntimeException rte = new RuntimeException(e.getMessage());
            rte.initCause(e);
            throw rte;
        }
        finally {
            if (this.debug) {
                ClientGroupManager.dprint(".getSocketInfo<-:");
            }
        }
    }

    private ClusterInstanceInfo extractClusterInstanceInfo(TaggedComponent sunTC) {
        ClusterInstanceInfo clusterInstanceInfo = null;
        try {
            org.omg.IOP.TaggedComponent tc = sunTC.getIOPComponent((org.omg.CORBA.ORB)((java.lang.Object)this.orb));
            Any any = this.codec.decode_value(tc.component_data, ClusterInstanceInfoHelper.type());
            clusterInstanceInfo = ClusterInstanceInfoHelper.extract(any);
        }
        catch (FormatMismatch e) {
            ClientGroupManager.dprint(".extractClusterInstanceInfo: ", e);
        }
        catch (TypeMismatch e) {
            ClientGroupManager.dprint(".extractClusterInstanceInfo: ", e);
        }
        return clusterInstanceInfo;
    }

    private com.sun.corba.ee.spi.transport.SocketInfo createSocketInfo(String msg, final String type, final String host, final int port) {
        if (this.debug) {
            ClientGroupManager.dprint(".getSocketInfo: address from: " + msg + "; type/address/port: " + type + "/" + host + "/" + port);
        }
        return new com.sun.corba.ee.spi.transport.SocketInfo(){

            public String getType() {
                return type;
            }

            public String getHost() {
                return host;
            }

            public int getPort() {
                return port;
            }

            public boolean equals(java.lang.Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof com.sun.corba.ee.spi.transport.SocketInfo)) {
                    return false;
                }
                com.sun.corba.ee.spi.transport.SocketInfo other = (com.sun.corba.ee.spi.transport.SocketInfo)o;
                if (other.getPort() != port) {
                    return false;
                }
                if (!other.getHost().equals(host)) {
                    return false;
                }
                return other.getType().equals(type);
            }

            public String toString() {
                return "SocketInfo[" + type + " " + host + " " + port + "]";
            }
        };
    }

    @Override
    public synchronized void reset(ContactInfo primary) {
        this.initialize();
        try {
            if (this.debug) {
                ClientGroupManager.dprint(".reset->: " + this.getKey(primary));
            }
            this.map.remove(this.getKey(primary));
        }
        catch (Throwable t) {
            ClientGroupManager.dprint(".reset: ", t);
            RuntimeException rte = new RuntimeException(this.baseMsg + ".reset error");
            rte.initCause(t);
            throw rte;
        }
        finally {
            if (this.debug) {
                ClientGroupManager.dprint(".reset<-: " + this.getKey(primary));
            }
        }
    }

    @Override
    public synchronized boolean hasNext(ContactInfo primary, ContactInfo previous, List contactInfos) {
        this.initialize();
        try {
            boolean result;
            if (this.debug) {
                ClientGroupManager.dprint(".hasNext->: " + this.formatKeyPreviousList(this.getKey(primary), previous, contactInfos));
            }
            if (previous == null) {
                result = true;
            } else {
                int previousIndex = contactInfos.indexOf(previous);
                int contactInfosSize = contactInfos.size();
                if (this.debug) {
                    ClientGroupManager.dprint(".hasNext: " + previousIndex + " " + contactInfosSize);
                }
                if (previousIndex < 0) {
                    RuntimeException rte = new RuntimeException("Problem in " + this.baseMsg + ".hasNext: previousIndex: " + previousIndex);
                    ClientGroupManager.dprint("Problem in " + this.baseMsg + ".hasNext: previousIndex: " + previousIndex, rte);
                    throw rte;
                }
                boolean bl = result = contactInfosSize - 1 > previousIndex;
            }
            if (this.debug) {
                ClientGroupManager.dprint(".hasNext<-: " + result);
            }
            return result;
        }
        catch (Throwable t) {
            ClientGroupManager.dprint("Problem in " + this.baseMsg + ".hasNext", t);
            RuntimeException rte = new RuntimeException(this.baseMsg + ".hasNext error");
            rte.initCause(t);
            throw rte;
        }
    }

    @Override
    public synchronized ContactInfo next(ContactInfo primary, ContactInfo previous, List contactInfos) {
        this.initialize();
        try {
            String debugMsg = null;
            if (this.debug) {
                debugMsg = "";
                ClientGroupManager.dprint(".next->: " + this.formatKeyPreviousList(this.getKey(primary), previous, contactInfos));
                ClientGroupManager.dprint(".next: map: " + this.formatMap(this.map));
            }
            java.lang.Object result = null;
            if (previous == null) {
                result = this.map.get(this.getKey(primary));
                if (result == null) {
                    if (this.debug) {
                        debugMsg = ".next<-: initialize map: ";
                    }
                    result = contactInfos.get(0);
                    this.map.put(this.getKey(primary), result);
                } else {
                    int position;
                    if (this.debug) {
                        ClientGroupManager.dprint(".next: primary mapped to: " + result);
                    }
                    if ((position = contactInfos.indexOf(result)) == -1) {
                        if (this.debug) {
                            ClientGroupManager.dprint(".next: cannot find mapped entry in current list.  Removing mapped entry and trying .next again.");
                        }
                        this.reset(primary);
                        return this.next(primary, previous, contactInfos);
                    }
                    result = contactInfos.get(position);
                    if (this.debug) {
                        debugMsg = ".next<-: mapped: ";
                    }
                }
            } else {
                result = contactInfos.get(contactInfos.indexOf(previous) + 1);
                this.map.put(this.getKey(primary), result);
                if (this.debug) {
                    ClientGroupManager.dprint("IIOP failover to: " + result);
                }
                if (this.debug) {
                    debugMsg = ".next<-: update map:  " + contactInfos.indexOf(previous) + " " + contactInfos.size() + " ";
                }
            }
            if (this.debug) {
                ClientGroupManager.dprint(debugMsg + result);
            }
            return (ContactInfo)result;
        }
        catch (Throwable t) {
            ClientGroupManager.dprint("Problem in " + this.baseMsg + ".next", t);
            RuntimeException rte = new RuntimeException(this.baseMsg + ".next error");
            rte.initCause(t);
            throw rte;
        }
    }

    private java.lang.Object getKey(ContactInfo contactInfo) {
        if (((com.sun.corba.ee.spi.transport.SocketInfo)((java.lang.Object)contactInfo)).getPort() == 0) {
            return ((CorbaContactInfoList)contactInfo.getContactInfoList()).getEffectiveTargetIOR();
        }
        return contactInfo;
    }

    private String formatKeyPreviousList(java.lang.Object key, ContactInfo previous, List list) {
        String result = "\n  key     : " + key + "\n  previous: " + previous + "\n  list:";
        Iterator i = list.iterator();
        int count = 1;
        while (i.hasNext()) {
            result = result + "\n    " + count++ + "  " + i.next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatMap(Map map) {
        String result = "";
        Map map2 = map;
        synchronized (map2) {
            Iterator i = map.entrySet().iterator();
            if (!i.hasNext()) {
                return "empty";
            }
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                result = result + "\n    key  : " + entry.getKey() + "\n    value: " + entry.getValue() + "\n";
            }
        }
        return result;
    }

    public List<ClusterInstanceInfo> getInitialClusterInstanceInfo(ORB orb) {
        try {
            Object ref = orb.resolve_initial_references("NameService");
            NamingContext nctx = NamingContextHelper.narrow((Object)ref);
            NameComponent[] path = new NameComponent[]{new NameComponent("INITIAL_GIS", "")};
            InitialGroupInfoService.InitialGIS initGIS = (InitialGroupInfoService.InitialGIS)PortableRemoteObject.narrow(nctx.resolve(path), InitialGroupInfoService.InitialGIS.class);
            return initGIS.getClusterInstanceInfo();
        }
        catch (Exception e) {
            if (this.debug) {
                ClientGroupManager.dprint("Exception in InitialGroupInfoService.getClusterInstanceInfo() ==> ", e);
            }
            return null;
        }
    }

    @Override
    public boolean addObserver(GroupInfoServiceObserver x) {
        return this.gis.addObserver(x);
    }

    @Override
    public void notifyObservers() {
        this.gis.notifyObservers();
    }

    @Override
    public List<ClusterInstanceInfo> getClusterInstanceInfo(String[] adapterName) {
        return this.gis.getClusterInstanceInfo(adapterName);
    }

    @Override
    public boolean shouldAddAddressesToNonReferenceFactory(String[] x) {
        return this.gis.shouldAddAddressesToNonReferenceFactory(x);
    }

    @Override
    public boolean shouldAddMembershipLabel(String[] adapterName) {
        return this.gis.shouldAddMembershipLabel(adapterName);
    }

    public String name() {
        return this.baseMsg;
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) {
        try {
            if (this.debug) {
                ClientGroupManager.dprint(".send_request->: " + ri.operation());
            }
            this.initialize();
            Object ref = ri.effective_target();
            IOR ior = this.orb.getIOR(ref, false);
            IIOPProfileTemplate iiopProfileTemplate = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
            Iterator<TaggedComponent> iterator = iiopProfileTemplate.iteratorById(1398099460);
            if (iterator.hasNext()) {
                org.omg.IOP.TaggedComponent membershipLabelTaggedComponent = iterator.next().getIOPComponent((org.omg.CORBA.ORB)((java.lang.Object)this.orb));
                byte[] data = membershipLabelTaggedComponent.component_data;
                if (this.debug) {
                    sentMemberShipLabel = true;
                    ClientGroupManager.dprint(".send_request: " + ri.operation() + ": sending membership label: " + new String(data));
                }
                ServiceContext sc = new ServiceContext(1398099457, data);
                ri.add_request_service_context(sc, false);
            } else if (this.debug) {
                sentMemberShipLabel = false;
                ClientGroupManager.dprint(".send_request: " + ri.operation() + ": no membership label");
            }
        }
        catch (RuntimeException e) {
            if (this.debug) {
                ClientGroupManager.dprint(".send_request: " + ri.operation() + ": exception: " + e);
            }
            throw e;
        }
        finally {
            if (this.debug) {
                ClientGroupManager.dprint(".send_request<-: " + ri.operation());
            }
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
        this.receive_star(".receive_reply", ri);
    }

    public void receive_exception(ClientRequestInfo ri) {
        this.receive_star(".receive_exception", ri);
    }

    public void receive_other(ClientRequestInfo ri) {
        this.receive_star(".receive_other", ri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive_star(String point, ClientRequestInfo ri) {
        try {
            if (this.debug) {
                ClientGroupManager.dprint(point + "->: " + ri.operation());
            }
            ServiceContext iorServiceContext = null;
            try {
                iorServiceContext = ri.get_reply_service_context(1398099458);
            }
            catch (BAD_PARAM e) {
                // empty catch block
            }
            if (iorServiceContext == null) {
                if (this.debug) {
                    ClientGroupManager.dprint(point + ": " + ri.operation() + ": no IOR update");
                    receivedIORUpdate = false;
                }
                return;
            }
            if (this.debug) {
                ClientGroupManager.dprint(point + ": " + ri.operation() + ": received IOR update");
                receivedIORUpdate = true;
            }
            byte[] data = iorServiceContext.context_data;
            Any any = null;
            try {
                any = this.codec.decode_value(data, ForwardRequestHelper.type());
            }
            catch (FormatMismatch e) {
                ClientGroupManager.dprint(point + ": " + ri.operation() + ": " + (java.lang.Object)((java.lang.Object)e));
            }
            catch (TypeMismatch e) {
                ClientGroupManager.dprint(point + ": " + ri.operation() + ": " + (java.lang.Object)((java.lang.Object)e));
            }
            ForwardRequest fr = ForwardRequestHelper.extract((Any)any);
            Object ref = fr.forward;
            IOR ior = this.orb.getIOR(ref, false);
            java.lang.Object object = this.lastIORLock;
            synchronized (object) {
                this.lastIOR = ior;
                this.gis.notifyObservers();
            }
            ((ClientRequestInfoImpl)ri).setLocatedIOR(ior);
        }
        finally {
            if (this.debug) {
                ClientGroupManager.dprint(point + "<-: " + ri.operation());
            }
        }
    }

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        if (this.debug) {
            ClientGroupManager.dprint(".post_init->:");
        }
        try {
            info.add_client_request_interceptor((ClientRequestInterceptor)this);
        }
        catch (Exception e) {
            ClientGroupManager.dprint(".post_init: " + e);
        }
        if (this.debug) {
            ClientGroupManager.dprint(".post_init<-:");
        }
    }

    @Override
    public void configure(DataCollector collector, ORB orb) {
        boolean bl = this.debug = this.debug || orb.transportDebugFlag;
        if (this.debug) {
            ClientGroupManager.dprint(".configure->:");
        }
        this.orb = orb;
        orb.getORBData().addORBInitializer(this);
        orb.getORBData().setIIOPPrimaryToContactInfo(this);
        orb.getORBData().setIORToSocketInfo(this);
        try {
            orb.register_initial_reference("FolbClientGroupInfoService", (Object)this);
        }
        catch (InvalidName e) {
            ClientGroupManager.dprint(".configure: " + (java.lang.Object)((java.lang.Object)e));
        }
        if (this.debug) {
            ClientGroupManager.dprint(".configure<-:");
        }
    }

    static void dprint(String msg) {
        ORBUtility.dprint("ClientGroupManager", msg);
    }

    static void dprint(String msg, Throwable t) {
        ClientGroupManager.dprint(msg);
        ClientGroupManager.dprint(t.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GIS
    extends GroupInfoServiceBase {
        private GIS() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ClusterInstanceInfo> getClusterInstanceInfo(String[] adapterName) {
            IIOPProfileTemplate iiopProfileTemplate;
            if (ClientGroupManager.this.lastIOR == null) {
                return ClientGroupManager.this.getInitialClusterInstanceInfo(ClientGroupManager.this.orb);
            }
            java.lang.Object object = ClientGroupManager.this.lastIORLock;
            synchronized (object) {
                iiopProfileTemplate = (IIOPProfileTemplate)ClientGroupManager.this.lastIOR.getProfile().getTaggedProfileTemplate();
            }
            Iterator<TaggedComponent> iterator = iiopProfileTemplate.iteratorById(1398099459);
            LinkedList<ClusterInstanceInfo> results = new LinkedList<ClusterInstanceInfo>();
            while (iterator.hasNext()) {
                ClusterInstanceInfo clusterInstanceInfo = ClientGroupManager.this.extractClusterInstanceInfo(iterator.next());
                results.add(clusterInstanceInfo);
            }
            return results;
        }

        @Override
        public boolean shouldAddAddressesToNonReferenceFactory(String[] x) {
            throw new RuntimeException("Should not be called in this context");
        }

        @Override
        public boolean shouldAddMembershipLabel(String[] adapterName) {
            throw new RuntimeException("Should not be called in this context");
        }
    }
}

