/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDRInputStream;
import com.sun.corba.ee.impl.oa.poa.Policies;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message_1_2;
import com.sun.corba.ee.impl.transport.BufferConnectionImpl;
import com.sun.corba.ee.impl.transport.CorbaInboundConnectionCacheImpl;
import com.sun.corba.ee.impl.transport.CorbaOutboundConnectionCacheImpl;
import com.sun.corba.ee.impl.transport.MessageTraceManagerImpl;
import com.sun.corba.ee.impl.transport.SelectorImpl;
import com.sun.corba.ee.pept.transport.Acceptor;
import com.sun.corba.ee.pept.transport.ByteBufferPool;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.pept.transport.InboundConnectionCache;
import com.sun.corba.ee.pept.transport.OutboundConnectionCache;
import com.sun.corba.ee.pept.transport.Selector;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.CorbaTransportManager;
import com.sun.corba.ee.spi.transport.MessageData;
import com.sun.corba.ee.spi.transport.MessageTraceManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.portable.InputStream;

public class CorbaTransportManagerImpl
implements CorbaTransportManager {
    protected ORB orb;
    protected List acceptors;
    protected Map outboundConnectionCaches;
    protected Map inboundConnectionCaches;
    protected Selector selector;
    private ThreadLocal currentMessageTraceManager = new ThreadLocal(){

        public Object initialValue() {
            return new MessageTraceManagerImpl(CorbaTransportManagerImpl.this.orb);
        }
    };

    public CorbaTransportManagerImpl(ORB orb) {
        this.orb = orb;
        this.acceptors = new ArrayList();
        this.outboundConnectionCaches = new HashMap();
        this.inboundConnectionCaches = new HashMap();
        this.selector = new SelectorImpl(orb);
    }

    public ByteBufferPool getByteBufferPool(int id) {
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundConnectionCache getOutboundConnectionCache(ContactInfo contactInfo) {
        ContactInfo contactInfo2 = contactInfo;
        synchronized (contactInfo2) {
            if (contactInfo.getConnectionCache() == null) {
                OutboundConnectionCache connectionCache = null;
                Map map = this.outboundConnectionCaches;
                synchronized (map) {
                    connectionCache = (OutboundConnectionCache)this.outboundConnectionCaches.get(contactInfo.getConnectionCacheType());
                    if (connectionCache == null) {
                        connectionCache = new CorbaOutboundConnectionCacheImpl(this.orb, contactInfo);
                        this.outboundConnectionCaches.put(contactInfo.getConnectionCacheType(), connectionCache);
                    }
                }
                contactInfo.setConnectionCache(connectionCache);
            }
            return contactInfo.getConnectionCache();
        }
    }

    public Collection getOutboundConnectionCaches() {
        return this.outboundConnectionCaches.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundConnectionCache getInboundConnectionCache(Acceptor acceptor) {
        Acceptor acceptor2 = acceptor;
        synchronized (acceptor2) {
            if (acceptor.getConnectionCache() == null) {
                InboundConnectionCache connectionCache = null;
                Map map = this.inboundConnectionCaches;
                synchronized (map) {
                    connectionCache = (InboundConnectionCache)this.inboundConnectionCaches.get(acceptor.getConnectionCacheType());
                    if (connectionCache == null) {
                        connectionCache = new CorbaInboundConnectionCacheImpl(this.orb, acceptor);
                        this.inboundConnectionCaches.put(acceptor.getConnectionCacheType(), connectionCache);
                    }
                }
                acceptor.setConnectionCache(connectionCache);
            }
            return acceptor.getConnectionCache();
        }
    }

    public Collection getInboundConnectionCaches() {
        return this.inboundConnectionCaches.values();
    }

    public Selector getSelector(int id) {
        return this.selector;
    }

    public synchronized void registerAcceptor(Acceptor acceptor) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerAcceptor->: " + acceptor);
        }
        this.acceptors.add(acceptor);
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerAcceptor<-: " + acceptor);
        }
    }

    public Collection getAcceptors() {
        return this.getAcceptors(null, null);
    }

    public synchronized void unregisterAcceptor(Acceptor acceptor) {
        this.acceptors.remove(acceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close->");
            }
            this.getSelector(0).close();
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-");
            }
        }
    }

    public Collection getAcceptors(String objectAdapterManagerId, ObjectAdapterId objectAdapterId) {
        for (Acceptor acceptor : this.acceptors) {
            if (!acceptor.initialize() || !acceptor.shouldRegisterAcceptEvent()) continue;
            this.orb.getTransportManager().getSelector(0).registerForEvent(acceptor.getEventHandler());
        }
        return this.acceptors;
    }

    public void addToIORTemplate(IORTemplate iorTemplate, Policies policies, String codebase, String objectAdapterManagerId, ObjectAdapterId objectAdapterId) {
        for (CorbaAcceptor acceptor : this.getAcceptors(objectAdapterManagerId, objectAdapterId)) {
            acceptor.addToIORTemplate(iorTemplate, policies, codebase);
        }
    }

    public Message getMessage(byte[] data) {
        BufferConnectionImpl connection = new BufferConnectionImpl(this.orb);
        ByteBuffer bb = ByteBuffer.allocate(data.length);
        bb.put(data);
        bb.position(0);
        try {
            connection.write(bb);
        }
        catch (IOException exc) {
            // empty catch block
        }
        MessageBase msg = MessageBase.readGIOPMessage(this.orb, connection);
        if (msg.getGIOPVersion().equals(GIOPVersion.V1_2)) {
            ((Message_1_2)msg).unmarshalRequestID(msg.getByteBuffer());
        }
        return msg;
    }

    public MessageData getMessageData(byte[][] data) {
        BufferConnectionImpl connection = new BufferConnectionImpl(this.orb);
        for (int ctr = 0; ctr < data.length; ++ctr) {
            byte[] message = data[ctr];
            ByteBuffer bb = ByteBuffer.allocate(message.length);
            bb.put(message);
            bb.position(0);
            try {
                connection.write(bb);
                continue;
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
        final Message[] messages = new Message[data.length];
        boolean requestID = false;
        Message firstMessage = null;
        MessageBase msg = null;
        CDRInputObject inobj = null;
        BufferManagerRead buffman = null;
        for (int ctr = 0; ctr < data.length; ++ctr) {
            msg = MessageBase.readGIOPMessage(this.orb, connection);
            messages[ctr] = msg;
            if (msg.getGIOPVersion().equals(GIOPVersion.V1_2)) {
                ((Message_1_2)msg).unmarshalRequestID(msg.getByteBuffer());
            }
            if (ctr == 0) {
                firstMessage = msg;
                inobj = new CDRInputObject(this.orb, connection, msg.getByteBuffer(), msg);
                buffman = inobj.getBufferManager();
                inobj.performORBVersionSpecificInit();
                continue;
            }
            buffman.processFragment(msg.getByteBuffer(), (FragmentMessage)((Object)msg));
        }
        firstMessage.read((InputStream)inobj);
        final CDRInputObject resultObj = inobj;
        return new MessageData(){

            public Message[] getMessages() {
                return messages;
            }

            public CDRInputStream getStream() {
                return resultObj;
            }
        };
    }

    public MessageTraceManager getMessageTraceManager() {
        return (MessageTraceManager)this.currentMessageTraceManager.get();
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaTransportManagerImpl", msg);
    }
}

