/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.transport.TemporarySelectorClosedException;
import com.sun.corba.ee.impl.transport.TemporarySelectorStateClosed;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.TemporarySelectorState;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.atomic.AtomicInteger;

public class TemporarySelectorStateOpen
implements TemporarySelectorState {
    static final AtomicInteger tsCount = new AtomicInteger(0);
    private final boolean debug;
    private ORB itsOrb;

    private TemporarySelectorStateOpen() {
        this.debug = true;
    }

    public TemporarySelectorStateOpen(ORB theOrb) {
        this.itsOrb = theOrb;
        this.debug = this.itsOrb.transportDebugFlag;
        if (this.debug) {
            this.dprint("(): number of open temporary selectors : " + tsCount.incrementAndGet());
        }
    }

    public int select(Selector theSelector, long theTimeout) throws IOException {
        if (this.debug) {
            this.dprint("select()->: selector: " + theSelector + ", timeout: " + theTimeout);
        }
        int result = 0;
        if (theSelector.isOpen()) {
            if (theTimeout <= 0L) {
                ORBUtilSystemException wrapper = this.itsOrb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
                throw wrapper.temporarySelectorSelectTimeoutLessThanOne(theSelector, theTimeout);
            }
        } else {
            throw new TemporarySelectorClosedException("Selector " + theSelector.toString() + " is closed.");
        }
        result = theSelector.select(theTimeout);
        if (this.debug) {
            this.dprint("select()<-: selector: " + theSelector + ", number selected: " + result);
        }
        return result;
    }

    public SelectionKey registerChannel(Selector theSelector, SelectableChannel theSelectableChannel, int theOps) throws IOException {
        if (this.debug) {
            this.dprint("registerChannel()->: selector: " + theSelector);
        }
        SelectionKey key = null;
        if (!theSelector.isOpen()) {
            throw new TemporarySelectorClosedException("Selector " + theSelector.toString() + " is closed.");
        }
        key = theSelectableChannel.register(theSelector, theOps);
        if (this.debug) {
            this.dprint("registerChannel()<-: selector: " + theSelector + ", SelectionKey: " + key);
        }
        return key;
    }

    public TemporarySelectorState cancelKeyAndFlushSelector(Selector theSelector, SelectionKey theSelectionKey) throws IOException {
        if (this.debug) {
            this.dprint("cancelKeyAndFlushSelector()->: selector: " + theSelector);
        }
        if (theSelectionKey != null) {
            if (this.debug) {
                this.dprint("cancelKeyAndFlushSelector(): cancel key: " + theSelectionKey);
            }
            theSelectionKey.cancel();
        }
        if (!theSelector.isOpen()) {
            throw new TemporarySelectorClosedException("Selector " + theSelector.toString() + " is closed.");
        }
        theSelector.selectNow();
        if (this.debug) {
            this.dprint("cancelKeyAndFlushSelector()<-: cancelled and flushed");
        }
        return this;
    }

    public TemporarySelectorState close(Selector theSelector) throws IOException {
        if (this.debug) {
            this.dprint("close()->: selector: " + theSelector);
        }
        theSelector.close();
        if (this.debug) {
            this.dprint("close(): number of open temporary selectors : " + tsCount.decrementAndGet());
            this.dprint("close()<-: changing to closed state");
        }
        return new TemporarySelectorStateClosed(this.itsOrb);
    }

    public TemporarySelectorState removeSelectedKey(Selector theSelector, SelectionKey theSelectionKey) throws IOException {
        if (this.debug) {
            this.dprint("removeSelectedKey()->: selector: " + theSelector + ", key to remove: " + theSelectionKey);
        }
        if (!theSelector.isOpen()) {
            throw new TemporarySelectorClosedException("Selector " + theSelector.toString() + " is closed.");
        }
        theSelector.selectedKeys().remove(theSelectionKey);
        if (this.debug) {
            this.dprint("removeSelectedKey()<-: selector: " + theSelector + ", key removed: " + theSelectionKey);
        }
        return this;
    }

    private void dprint(String theMsg) {
        ORBUtility.dprint("TemporarySelectorStateOpen", theMsg);
    }
}

