/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orb;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.Operation;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationFactoryExt {
    private static final ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_UTIL_ORBUtil();

    private OperationFactoryExt() {
    }

    public static Operation convertAction(Class<?> cls) {
        return new ConvertAction(cls);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConvertAction
    implements Operation {
        Class<?> cls;
        Constructor<?> cons;

        public ConvertAction(Class<?> cls) {
            this.cls = cls;
            try {
                this.cons = cls.getConstructor(String.class);
            }
            catch (Exception exc) {
                throw wrapper.exceptionInConvertActionConstructor(exc, (Object)cls.getName());
            }
        }

        @Override
        public Object operate(Object value) {
            try {
                return this.cons.newInstance(value);
            }
            catch (Exception exc) {
                throw wrapper.exceptionInConvertAction(exc);
            }
        }

        public String toString() {
            return "ConvertAction[" + this.cls.getName() + "]";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConvertAction)) {
                return false;
            }
            ConvertAction other = (ConvertAction)obj;
            return this.toString().equals(other.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

