/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Invocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.InvocationHandlerUtil;
import com.sun.ejb.containers.util.MethodMap;
import com.sun.ejb.spi.io.IndirectlySerializable;
import com.sun.ejb.spi.io.SerializableObjectFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;

public final class EJBLocalObjectInvocationHandler
extends EJBLocalObjectImpl
implements InvocationHandler {
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EJBLocalObjectInvocationHandler.class);
    private Object proxy_;
    private MethodMap invocationInfoMap_;
    private Class localIntf_;

    public EJBLocalObjectInvocationHandler(MethodMap invocationInfoMap, Class localIntf) throws Exception {
        this.invocationInfoMap_ = invocationInfoMap;
        this.localIntf_ = localIntf;
        this.setIsLocalHomeView(true);
    }

    public EJBLocalObjectInvocationHandler(MethodMap invocationInfoMap) throws Exception {
        this.invocationInfoMap_ = invocationInfoMap;
        this.setIsLocalHomeView(false);
    }

    public void setProxy(Object proxy) {
        this.proxy_ = proxy;
    }

    public Object getClientObject() {
        return this.proxy_;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invoke(this.localIntf_, method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object invoke(Class clientInterface, Method method, Object[] args) throws Throwable {
        try {
            this.container.onEnteringContainer();
            Class<?> methodClass = method.getDeclaringClass();
            if (methodClass == Object.class) {
                Object object = InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
                return object;
            }
            if (methodClass == IndirectlySerializable.class) {
                SerializableObjectFactory serializableObjectFactory = this.getSerializableObjectFactory();
                return serializableObjectFactory;
            }
            InvocationInfo invInfo = (InvocationInfo)this.invocationInfoMap_.get(method, args != null ? args.length : 0);
            if (invInfo == null) {
                throw new IllegalStateException("Unknown method :" + method);
            }
            if (methodClass == EJBLocalObject.class || invInfo.ejbIntfOverride) {
                Object object = this.invokeEJBLocalObjectMethod(method.getName(), args);
                return object;
            }
            if (invInfo.targetMethod1 == null) {
                Object[] params = new Object[]{invInfo.ejbName, "Local", invInfo.method.toString()};
                String errorMsg = localStrings.getLocalString("ejb.bean_class_method_not_found", "", params);
                logger.log(Level.SEVERE, "ejb.bean_class_method_not_found", params);
                throw new EJBException(errorMsg);
            }
            Object returnValue = null;
            Invocation inv = new Invocation();
            inv.isLocal = true;
            inv.isBusinessInterface = !this.isLocalHomeView();
            inv.isHome = false;
            inv.ejbObject = this;
            inv.method = method;
            inv.methodParams = args;
            inv.clientInterface = clientInterface;
            inv.transactionAttribute = invInfo.txAttr;
            inv.securityPermissions = invInfo.securityPermissions;
            inv.invocationInfo = invInfo;
            inv.beanMethod = invInfo.targetMethod1;
            try {
                this.container.preInvoke(inv);
                returnValue = this.container.intercept(inv);
            }
            catch (InvocationTargetException ite) {
                inv.exceptionFromBeanMethod = inv.exception = ite.getCause();
            }
            catch (Throwable t) {
                inv.exception = t;
            }
            finally {
                this.container.postInvoke(inv);
            }
            if (inv.exception != null) {
                InvocationHandlerUtil.throwLocalException(inv.exception, method.getExceptionTypes());
            }
            Object object = returnValue;
            return object;
        }
        finally {
            this.container.onLeavingContainer();
        }
    }

    private Object invokeEJBLocalObjectMethod(String methodName, Object[] args) throws Exception {
        Object returnValue = null;
        switch (methodName.charAt(0)) {
            case 'r': {
                super.remove();
                break;
            }
            case 'i': {
                EJBLocalObject other = (EJBLocalObject)args[0];
                EJBLocalObjectImpl otherImpl = EJBLocalObjectImpl.toEJBLocalObjectImpl(other);
                returnValue = new Boolean(super.isIdentical(otherImpl));
                break;
            }
            case 'g': {
                if (methodName.charAt(3) == 'E') {
                    returnValue = super.getEJBLocalHome();
                    break;
                }
                returnValue = super.getPrimaryKey();
                break;
            }
            default: {
                throw new EJBException("unknown method = " + methodName);
            }
        }
        return returnValue;
    }
}

