/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.mbeans.ConfigsMBean;
import com.sun.enterprise.admin.mbeans.MBeanExceptionFormatter;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServer;

public class ConfigMBeanUtil {
    private static final StringManager localStrings = StringManager.getManager(ConfigsMBean.class);

    private ConfigMBeanUtil() {
    }

    public static boolean attributeDefinedInList(List list, String name) {
        if (name != null) {
            for (Attribute attr : list) {
                if (name == null || !name.equals(attr.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static MBeanServer getMBeanServer() throws MBeanException {
        return MBeanServerFactory.getMBeanServer();
    }

    public static Target getTarget(String targetName, TargetType[] targetTypes, ConfigContext configContext) throws MBeanException {
        try {
            String configName;
            Target target = TargetBuilder.INSTANCE.createTarget(targetTypes, targetName, configContext);
            if (target.getType() == TargetType.SERVER || target.getType() == TargetType.DAS) {
                String configName2 = ServerHelper.getConfigForServer(configContext, target.getName()).getName();
                if (!ConfigAPIHelper.isConfigurationReferencedByServerOnly(configContext, configName2, target.getName())) {
                    throw new ConfigException(localStrings.getString("configurationHasMultipleRefs", target.getName(), configName2, ConfigAPIHelper.getConfigurationReferenceesAsString(configContext, configName2)));
                }
            } else if (target.getType() == TargetType.CLUSTER && !ConfigAPIHelper.isConfigurationReferencedByClusterOnly(configContext, configName = ClusterHelper.getConfigForCluster(configContext, target.getName()).getName(), target.getName())) {
                throw new ConfigException(localStrings.getString("configurationHasMultipleRefs", target.getName(), configName, ConfigAPIHelper.getConfigurationReferenceesAsString(configContext, configName)));
            }
            return target;
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
    }
}

