/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.meta;

import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.meta.MBeanMetaConstants;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.naming.MBeanNamingInfo;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;

public abstract class DottedNameHelper
implements MBeanMetaConstants {
    static final String PROPERTY_TOKEN = "property";
    static final String PROPERTY_PREFIX = ".property.";
    static final String ALL_PROPERTIES = "property.*";
    static final String _PREFIX_SYMB = "%";
    static final String VALUE_PREFIX_SYMB = "%";
    static final String SPECNAME_FOR_ALL_PROPERTIES = "property.";
    static final String SPECNAME_FOR_ALL_ATTRIBUTES = "";

    public static String[] splitAttributeNameFromDottedName(String dottedName) throws MBeanConfigException {
        String[] tokens = (dottedName = dottedName.replaceAll("\\\\\\.", "\\\\\\~")).trim().split("\\.");
        if (tokens.length >= 2) {
            int idx = 0;
            idx = tokens.length > 2 && tokens[tokens.length - 2].equals(PROPERTY_TOKEN) ? dottedName.lastIndexOf(PROPERTY_PREFIX) : dottedName.lastIndexOf(".");
            if (idx > 0 && idx < dottedName.length() - 1) {
                String attrName = dottedName.substring(idx + 1).replaceAll("\\\\\\~", ".");
                if (attrName.equals("*")) {
                    attrName = SPECNAME_FOR_ALL_ATTRIBUTES;
                } else if (attrName.equals(ALL_PROPERTIES)) {
                    attrName = SPECNAME_FOR_ALL_PROPERTIES;
                }
                return new String[]{dottedName.substring(0, idx).replaceAll("\\\\\\~", "\\\\\\."), attrName};
            }
        }
        throw new MBeanConfigException("malformed dotted name");
    }

    public static String getFirstToken(String dottedName) {
        int idx = dottedName.indexOf(46);
        return idx > 0 ? dottedName.substring(0, idx) : dottedName;
    }

    public static int getDottedNameTargetType(ConfigContext ctx, String dottedName) {
        String token = DottedNameHelper.getFirstToken(dottedName);
        if (token.startsWith("%")) {
            token = token.substring("%".length());
        }
        if (token.equals("domain")) {
            return 1;
        }
        try {
            if (ConfigAPIHelper.isAConfig(ctx, token)) {
                return 4;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (ServerHelper.isAServer(ctx, token)) {
                return 2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (ClusterHelper.isACluster(ctx, token)) {
                return 3;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (NodeAgentHelper.isANodeAgent(ctx, token)) {
                return 5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public static AttributeList addDottedPrefix(AttributeList attrs, String dottedName) {
        if (attrs == null || attrs.size() == 0 || dottedName == null || dottedName.length() == 0) {
            return attrs;
        }
        AttributeList attrsMod = new AttributeList();
        String prefix = dottedName + ".";
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            attrsMod.add(new Attribute(prefix + attr.getName(), attr.getValue()));
        }
        return attrsMod;
    }

    public static String resolveDottedNameToTarget(ConfigContext ctx, String dottedName, int fromType, int toType) {
        if (dottedName == null || dottedName.length() == 0 || fromType == toType) {
            return dottedName;
        }
        String newTargetName = null;
        if (toType == 1 || toType == 6 || toType == 7) {
            newTargetName = "domain";
        } else if ((fromType == 2 || fromType == 3) && toType == 4) {
            newTargetName = DottedNameHelper.getReferencedConfigName(ctx, DottedNameHelper.getFirstToken(dottedName));
        }
        if (newTargetName == null) {
            return dottedName;
        }
        return DottedNameHelper.replaceFirstToken(dottedName, newTargetName);
    }

    public static String getReferencedConfigName(ConfigContext ctx, String targetName) {
        Object configName = null;
        try {
            return ClusterHelper.getClusterByName(ctx, targetName).getConfigRef();
        }
        catch (Exception e) {
            try {
                return ServerHelper.getServerByName(ctx, targetName).getConfigRef();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static void collectConfigMBeansDottedNames(MBeanRegistry registry, ConfigBean bean, ArrayList list) {
        if (bean == null) {
            return;
        }
        String xpath = bean.getAbsoluteXPath(SPECNAME_FOR_ALL_ATTRIBUTES);
        ConfigContext ctx = bean.getConfigContext();
        MBeanNamingInfo namingInfo = registry.getNamingInfoForConfigBean(bean, "testdomain");
        ArrayList dottedNames = MBeanRegistry.getValidDottedNames(namingInfo, "%");
        if (dottedNames != null && dottedNames.size() > 0) {
            String[] location = namingInfo.getLocationParams();
            String tokenToReplace = SPECNAME_FOR_ALL_ATTRIBUTES;
            if (location.length > 1) {
                String refsList;
                String name = location[1];
                ArrayList additionalTargetNames = new ArrayList();
                int iTargetType = DottedNameHelper.getTargetTypeForXPath(xpath);
                if (iTargetType == 4) {
                    tokenToReplace = "%" + name;
                    try {
                        refsList = ConfigAPIHelper.getConfigurationReferenceesAsString(ctx, name);
                        DottedNameHelper.addStringListToArrayList(additionalTargetNames, refsList);
                    }
                    catch (Exception e) {}
                } else if (iTargetType == 7) {
                    tokenToReplace = "domain";
                    try {
                        refsList = ResourceHelper.getResourceReferenceesAsString(ctx, name);
                        DottedNameHelper.addStringListToArrayList(additionalTargetNames, refsList);
                    }
                    catch (Exception e) {}
                } else if (iTargetType == 6) {
                    tokenToReplace = "domain";
                    try {
                        refsList = ApplicationHelper.getApplicationReferenceesAsString(ctx, name);
                        DottedNameHelper.addStringListToArrayList(additionalTargetNames, refsList);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (additionalTargetNames.size() > 0) {
                    ArrayList<String> additionalDottedNames = new ArrayList<String>();
                    for (int i = 0; i < dottedNames.size(); ++i) {
                        String dottedName = (String)dottedNames.get(i);
                        if (tokenToReplace != null && !DottedNameHelper.isDottedNameStartsWithToken(dottedName, tokenToReplace)) continue;
                        for (int j = 0; j < additionalTargetNames.size(); ++j) {
                            additionalDottedNames.add(DottedNameHelper.replaceFirstToken(dottedName, "%" + (String)additionalTargetNames.get(j)));
                        }
                    }
                    dottedNames.addAll(additionalDottedNames);
                }
            }
            list.addAll(dottedNames);
        }
        try {
            ConfigBean[] beans = bean.getAllChildBeans();
            if (beans == null) {
                return;
            }
            for (int i = 0; i < beans.length; ++i) {
                if (beans[i] != null && beans[i].getConfigContext() == null) {
                    beans[i].setConfigContext(ctx);
                }
                try {
                    DottedNameHelper.collectConfigMBeansDottedNames(registry, beans[i], list);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getTargetTypeForXPath(String xpath) {
        if (xpath == null) {
            return 0;
        }
        if (xpath.startsWith("/domain/configs/config")) {
            return 4;
        }
        if (xpath.startsWith("/domain/servers/server")) {
            return 2;
        }
        if (xpath.startsWith("/domain/clusters/cluster")) {
            return 3;
        }
        if (xpath.startsWith("/domain/node-agents/node-agent")) {
            return 5;
        }
        if (xpath.startsWith("/domain/applications/")) {
            return 6;
        }
        if (xpath.startsWith("/domain/resources/")) {
            return 7;
        }
        return 1;
    }

    public static boolean isDottedNameStartsWithToken(String dottedName, String token) {
        return dottedName != null && token != null && dottedName.startsWith(token) && (dottedName.length() == token.length() || dottedName.charAt(token.length()) == '.');
    }

    public static String replaceFirstToken(String dottedName, String replaceTo) {
        int idx = dottedName.indexOf(46);
        if (idx < 0) {
            return replaceTo;
        }
        return replaceTo + dottedName.substring(idx);
    }

    public static void addArrayToList(ArrayList list, Object[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            list.add(arr[i]);
        }
    }

    public static void addStringListToArrayList(ArrayList list, String strList) {
        if (strList != null && strList.trim().length() > 0) {
            Object[] elems = strList.trim().split(",");
            DottedNameHelper.addArrayToList(list, elems);
        }
    }

    public static ArrayList removeNamePrefixes(ArrayList list) {
        if (list == null) {
            return list;
        }
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            out.add(DottedNameHelper.removeNamePrefixes((String)list.get(i)));
        }
        return out;
    }

    public static String removeNamePrefixes(String name) {
        if (name == null) {
            return name;
        }
        if (name.startsWith("%")) {
            return name.substring("%".length()).replaceAll("\\.\\%", ".");
        }
        return name.replaceAll("\\.\\%", ".");
    }

    public static ArrayList sortDottedNames(ConfigContext ctx, ArrayList list) {
        if (list == null || list.size() < 2) {
            return list;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        String prefix = "1";
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            int type = DottedNameHelper.getDottedNameTargetType(ctx, name);
            switch (type) {
                case 4: {
                    prefix = "2";
                    break;
                }
                case 2: {
                    prefix = "3";
                    break;
                }
                case 3: {
                    prefix = "4";
                    break;
                }
                case 5: {
                    prefix = "5";
                    break;
                }
                default: {
                    prefix = "1";
                }
            }
            map.put(prefix + name, name);
        }
        return new ArrayList(map.values());
    }

    public static ArrayList filterStringValues(ArrayList list, String mask) {
        String regexp;
        if (list == null || mask == null || list.size() == 0) {
            return list;
        }
        boolean bRemovePrefixBeforeMatching = true;
        String MUSTBE_PREFIX = "[\\%]";
        String MAYBE_PREFIX = "[\\%]?";
        if (mask.length() == 0) {
            regexp = mask + "[^.]*";
        } else if (mask.indexOf(42) < 0) {
            regexp = "[\\%]?" + mask.replace(".", "\\." + "[\\%]?".replace("$", "\\$")) + "\\.([^.]*)" + "(\\." + "[\\%]" + "[^.]*)?";
            bRemovePrefixBeforeMatching = false;
        } else {
            regexp = mask.replace(".", "\\.");
            regexp = regexp.replace("$", "\\$");
            regexp = regexp.replace("*", ".*");
        }
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String dottedName = (String)list.get(i);
            if (bRemovePrefixBeforeMatching) {
                dottedName = DottedNameHelper.removeNamePrefixes(dottedName);
            }
            if (!dottedName.matches(regexp)) continue;
            if (bRemovePrefixBeforeMatching) {
                out.add(dottedName);
                continue;
            }
            out.add(DottedNameHelper.removeNamePrefixes(dottedName));
        }
        return out;
    }
}

