/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.LifeCycleNotificationFilter;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

public class LifeCycleEvent
implements Event {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private static StringManager sm = StringManager.getManager(LifeCycleEvent.class);
    private static ObjectName objName = null;
    private static String defaultDescription = sm.getString("selfmgmt_event.lifecycle_event_description");
    private LifeCycleNotificationFilter lfilter = null;
    private String description = null;
    private String type = null;
    public static final String READY_EVENT = "lifecycle.ready";
    public static final String SHUTDOWN_EVENT = "lifecycle.shutdown";
    public static final String TERMINATION_EVENT = "lifecycle.termination";

    public LifeCycleEvent(String type, LifeCycleNotificationFilter lfilter, String description) {
        this.type = type;
        this.lfilter = lfilter;
        this.description = description != null ? description : defaultDescription;
    }

    public ObjectName getObjectName() {
        return objName;
    }

    public String getType() {
        return this.type;
    }

    public NotificationFilter getNotificationFilter() {
        return this.lfilter;
    }

    public String getDescription() {
        return this.description;
    }

    public void destroy() {
    }

    static ObjectName getLifeCycleImplObjectName() {
        if (objName != null) {
            return objName;
        }
        try {
            objName = new ObjectName("com.sun.appserver.selfmanagement", "eventname", "lifecycle");
        }
        catch (MalformedObjectNameException mex) {
            _logger.log(Level.WARNING, "smgt.internal_error", mex);
        }
        return objName;
    }

    public static boolean isValidType(String type) {
        return "*".equals(type) || READY_EVENT.equals(type) || SHUTDOWN_EVENT.equals(type) || TERMINATION_EVENT.equals(type);
    }
}

