/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.channel;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.server.core.channel.AdminChannelServer;
import com.sun.enterprise.admin.server.core.channel.LocalRMIClientSocketFactory;
import com.sun.enterprise.admin.server.core.channel.LocalRMIServerSocketFactory;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.channel.ReconfigHelper;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdminChannel {
    static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    static volatile String instanceRoot = null;
    static final String fileSeparator = "/";
    static final int SEED_LENGTH = 16;
    private static volatile AdminChannelServer server = null;
    private static final Map<String, RMIClient> rmiClientMap = new HashMap<String, RMIClient>();
    private static StringManager localStrings = StringManager.getManager(AdminChannel.class);
    static final String stubFileName = "admch";
    static final String seedFileName = "admsn";
    static final String LOCAL_ONLY_ACCESS = "high";
    static final String ALLOW_ALL_ACCESS = "none";
    static final String ENFORCE = "high";
    static final String REQUIRE_KEY = "medium";
    static final String NO_ENFORCE = "low";
    static final String RECONFIG_ENABLE_ERROR = "channel.reconfig_enable_error";
    static final String SERVER_CREATION_ERRCODE = "channel.creation_error";
    static final String KEY_READ_ERROR = "channel.key_read_error";
    static final String KEY_WRITE_ERROR = "channel.key_write_error";
    static final String PROP_SERVER_PORT = "com.sun.enterprise.admin.server.core.channel.port";

    public static synchronized void createRMIChannel() throws ServerLifecycleException {
        try {
            server = AdminChannel.createServerObject();
            AdminChannel.saveStubToFile(server.getRemoteStub());
        }
        catch (Exception e) {
            AdminChannel.warn(SERVER_CREATION_ERRCODE);
            AdminChannel.debug(e);
            throw new ServerLifecycleException(e);
        }
    }

    public static synchronized void destroyRMIChannel() throws ServerLifecycleException {
        if (server != null) {
            server.setChannelStopping();
            try {
                UnicastRemoteObject.unexportObject(server, true);
            }
            catch (NoSuchObjectException nsoe) {
                throw new ServerLifecycleException(nsoe);
            }
        }
        AdminChannel.deleteStubFile();
    }

    public static synchronized void createSharedSecret() throws ServerLifecycleException {
        AdminChannel.assertAdminServerChannelNotNull();
        String fileName = AdminChannel.getSeedFileName();
        File seedFile = new File(fileName);
        byte[] prevSeed = AdminChannel.getPreviousSeed(seedFile);
        SecureRandom sr = new SecureRandom(prevSeed);
        byte[] seed = new byte[16];
        sr.nextBytes(seed);
        AdminChannel.saveSeedToFile(seed, seedFile);
        server.setSharedInfo(seed);
        server.setChannelStarting();
    }

    public static void enableWebCoreReconfig() {
        try {
            ReconfigHelper.enableWebCoreReconfig();
        }
        catch (Throwable t) {
            AdminChannel.warn(RECONFIG_ENABLE_ERROR);
            AdminChannel.debug(t);
        }
    }

    public static synchronized RMIClient getRMIClient(String instanceName) {
        RMIClient client = rmiClientMap.get(instanceName);
        if (client == null) {
            client = new RMIClient(AdminChannel.getStubFileName(), AdminChannel.getSeedFileName());
            rmiClientMap.put(instanceName, client);
        }
        return client;
    }

    public static synchronized void setRMIChannelReady() {
        AdminChannel.assertAdminServerChannelNotNull();
        server.setChannelReady();
    }

    public static synchronized void setRMIChannelStopping() {
        AdminChannel.assertAdminServerChannelNotNull();
        server.setChannelStopping();
    }

    public static void setRMIChannelAborting(int port) {
        AdminChannel.assertAdminServerChannelNotNull();
        server.setChannelAborting(port);
    }

    static String getInstanceRoot() {
        if (instanceRoot == null) {
            instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        }
        return instanceRoot;
    }

    static String getStubFileName() {
        return AdminChannel.getInstanceRoot() + fileSeparator + "config" + fileSeparator + stubFileName;
    }

    static String getSeedFileName() {
        return AdminChannel.getInstanceRoot() + fileSeparator + "config" + fileSeparator + seedFileName;
    }

    private static AdminChannelServer createServerObject() throws RemoteException {
        AdminChannelServer server = null;
        InetAddress localAddress = AdminChannel.getLocalLoopbackAddress();
        if (localAddress == null) {
            server = new AdminChannelServer();
        } else {
            LocalRMIClientSocketFactory csf = new LocalRMIClientSocketFactory(localAddress);
            LocalRMIServerSocketFactory ssf = new LocalRMIServerSocketFactory(localAddress);
            int port = 0;
            port = Integer.getInteger(PROP_SERVER_PORT, new Integer(port));
            server = new AdminChannelServer(port, csf, ssf);
            server = new AdminChannelServer(0, csf, ssf);
            server.setLocalAddress(localAddress);
        }
        return server;
    }

    private static InetAddress getLocalLoopbackAddress() {
        InetAddress localAddr = null;
        try {
            localAddr = InetAddress.getByName(null);
            if (!localAddr.isLoopbackAddress()) {
                localAddr = null;
            }
        }
        catch (Throwable t) {
            localAddr = null;
        }
        return localAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getPreviousSeed(File seedFile) {
        boolean haveSeed = false;
        byte[] prevSeed = new byte[16];
        SecureRandom sr = J2EEServer.secureRandom;
        assert (sr != null);
        sr.setSeed(System.currentTimeMillis());
        if (seedFile.exists() && seedFile.canRead()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(seedFile);
                fis.read(prevSeed);
                sr.setSeed(prevSeed);
                sr.nextBytes(prevSeed);
                haveSeed = true;
            }
            catch (IOException ioe) {
                AdminChannel.warn(KEY_READ_ERROR);
                AdminChannel.debug(ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (!haveSeed) {
            sr.nextBytes(prevSeed);
        }
        return prevSeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSeedToFile(byte[] seed, File seedFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(seedFile);
            fos.write(seed);
        }
        catch (IOException ioe) {
            AdminChannel.warn(KEY_WRITE_ERROR);
            AdminChannel.debug(ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void saveStubToFile(RemoteStub stub) {
        String fileName = AdminChannel.getStubFileName();
        try {
            File file = new File(fileName);
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(stub);
            fos.close();
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.channel.unable_saving_stub_to_file", fileName);
            throw new RuntimeException(msg, e);
        }
    }

    private static void deleteStubFile() {
        String fileName = AdminChannel.getStubFileName();
        new File(fileName).delete();
    }

    private static final void assertAdminServerChannelNotNull() {
        if (server == null) {
            String msg = localStrings.getString("admin.server.core.channel.admin_server_channel_not_initialized");
            throw new RuntimeException(msg);
        }
    }

    static void warn(String s) {
        logger.warning(s);
    }

    static void warn(String msgkey, String obj1) {
        logger.log(Level.WARNING, msgkey, obj1);
    }

    static void debug(String s) {
        logger.fine(s);
    }

    static void debug(String msgkey, String obj1) {
        logger.log(Level.FINE, msgkey, obj1);
    }

    static void debug(String msgkey, Object[] objarr) {
        logger.log(Level.FINE, msgkey, objarr);
    }

    static void debug(Throwable t) {
        logger.log(Level.FINE, t.getMessage(), t);
    }

    static void trace(Throwable t) {
        logger.log(Level.FINEST, t.getMessage(), t);
    }

    static String getAccessLevel() {
        return "high";
    }

    static String getKeyCheckLevel() {
        return "high";
    }

    static boolean getClientAutoRefreshEnabled() {
        return true;
    }

    static long getClientAutoRefreshInterval() {
        return 60000L;
    }
}

