/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.servlet;

import com.sun.enterprise.admin.server.core.AdminService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UploadServlet
extends HttpServlet {
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String str = request.getQueryString();
        Properties p = new Properties();
        try {
            this.getQueryProperties(str, p);
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e.getMessage());
            return;
        }
        String fileName = p.getProperty("file");
        if (fileName == null || fileName.trim().equals("")) {
            this.writeErrorResponse(response, "no fileName found");
            return;
        }
        File localDir = new File(AdminService.getAdminService().getTempDirPath());
        localDir.mkdirs();
        File uploadFile = new File(localDir, fileName);
        if (uploadFile.exists()) {
            sLogger.log(Level.INFO, "mbean.temp_upload_file_exists", uploadFile.getCanonicalPath());
            if (!uploadFile.delete()) {
                sLogger.log(Level.INFO, "mbean.delete_temp_file_failed", uploadFile.getCanonicalPath());
                this.writeErrorResponse(response, "cannot delete existing file");
                return;
            }
            sLogger.log(Level.FINE, "mbean.delete_temp_file_ok", uploadFile.getCanonicalPath());
        }
        sLogger.log(Level.INFO, "mbean.begin_upload", uploadFile.getCanonicalPath());
        FileOutputStream fos = null;
        ServletInputStream is = null;
        try {
            fos = new FileOutputStream(uploadFile);
            is = request.getInputStream();
            byte[] buffer = new byte[65536];
            int i = is.read(buffer);
            while (i > 0) {
                fos.write(buffer, 0, i);
                i = is.read(buffer);
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.upload_failed", uploadFile.getCanonicalPath());
            this.writeErrorResponse(response, "uploading file failed");
            return;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (is != null) {
                is.close();
            }
        }
        this.writeResponse(response, uploadFile.getCanonicalPath());
    }

    private void writeResponse(HttpServletResponse response, String msg) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setBufferSize(8192);
        PrintWriter writer = response.getWriter();
        writer.println("SUCCESS:" + msg);
        writer.close();
    }

    private void writeErrorResponse(HttpServletResponse response, String errorMsg) throws IOException {
        response.setContentType("text/html");
        response.setBufferSize(8192);
        PrintWriter writer = response.getWriter();
        writer.println("FAIL:" + errorMsg);
        writer.close();
    }

    public void getQueryProperties(String q, Properties toAddTo) throws Exception {
        if (q == null || q.length() == 0) {
            return;
        }
        StringTokenizer iter = new StringTokenizer(q, "&");
        while (iter.hasMoreElements()) {
            String pair = iter.nextToken();
            int split = pair.indexOf(61);
            if (split <= 0) {
                throw new Exception("Invalid pair [" + pair + "] in query string [" + q + "]");
            }
            String key = pair.substring(0, split);
            String value = pair.substring(split + 1);
            try {
                key = URLDecoder.decode(key, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Exception("Invalid encoding in [" + pair + "] in query string [" + q + "]" + e.getMessage());
            }
            toAddTo.setProperty(key, value);
        }
    }
}

