/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.LazyAssociatableConnectionManagerImpl;
import com.sun.enterprise.connectors.LazyEnlistableConnectionManagerImpl;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionManager;

public class ConnectionManagerFactory {
    public static ConnectionManager getAvailableConnectionManager(String poolName, boolean forceNoLazyAssoc) throws ConnectorRuntimeException {
        Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        PoolMetaData pmd = registry.getPoolMetaData(poolName);
        boolean isLazyEnlist = pmd.isLazyEnlistable();
        boolean isLazyAssoc = pmd.isLazyAssociatable();
        ConnectionManagerImpl mgr = null;
        if (isLazyAssoc && !forceNoLazyAssoc) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("@@@@ Creating LazyAssociatableConnectionManager");
            }
            mgr = new LazyAssociatableConnectionManagerImpl(poolName);
        } else if (isLazyEnlist) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("@@@@ Creating LazyEnlistableConnectionManager");
            }
            mgr = new LazyEnlistableConnectionManagerImpl(poolName);
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("@@@@ Creating plain ConnectionManager");
            }
            mgr = new ConnectionManagerImpl(poolName);
        }
        return mgr;
    }
}

