/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorAdminService;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorServiceImpl;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.enterprise.connectors.authentication.ConnectorSecurityMap;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.connectors.util.ConnectionDefinitionUtils;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ConnectionPoolReconfigHelper;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.DASResourcesUtil;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.util.SecurityMapUtils;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.resource.ConnectorConnectionPoolDeployer;
import com.sun.enterprise.resource.JdbcConnectionPoolDeployer;
import com.sun.enterprise.resource.PoolManagerImpl;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.UnpooledConnectionEventListener;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class ConnectorConnectionPoolAdminServiceImpl
extends ConnectorServiceImpl
implements ConnectorAdminService {
    private static StringManager localStrings = StringManager.getManager(ConnectorConnectionPoolAdminServiceImpl.class);

    public ConnectorConnectionPoolAdminServiceImpl() {
        this.initialize();
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, ElementProperty[] props, SecurityMap[] securityMaps) throws ConnectorRuntimeException {
        if (ccp == null || connectionDefinitionName == null || rarName == null) {
            _logger.log(Level.FINE, "Wrong parameters for pool creation ");
            String i18nMsg = localStrings.getString("ccp_adm.wrong_params_for_create");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        ConnectorDescriptor connectorDescriptor = _registry.getDescriptor(rarName);
        if (connectorDescriptor == null) {
            this.ifSystemRarLoad(rarName);
            connectorDescriptor = _registry.getDescriptor(rarName);
        }
        if (connectorDescriptor == null) {
            String i18nMsg = localStrings.getString("ccp_adm.no_conn_pool_obj", rarName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_notfound_registry", rarName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        Set connectionDefs = connectorDescriptor.getOutboundResourceAdapter().getConnectionDefs();
        ConnectionDefDescriptor cdd = null;
        Iterator it = connectionDefs.iterator();
        while (it.hasNext() && !connectionDefinitionName.equals((cdd = (ConnectionDefDescriptor)it.next()).getConnectionFactoryIntf())) {
        }
        ConnectorDescriptorInfo cdi = new ConnectorDescriptorInfo();
        cdi.setRarName(rarName);
        cdi.setResourceAdapterClassName(connectorDescriptor.getResourceAdapterClass());
        cdi.setConnectionDefinitionName(cdd.getConnectionFactoryIntf());
        cdi.setManagedConnectionFactoryClass(cdd.getManagedConnectionFactoryImpl());
        cdi.setConnectionFactoryClass(cdd.getConnectionFactoryImpl());
        cdi.setConnectionFactoryInterface(cdd.getConnectionFactoryIntf());
        cdi.setConnectionClass(cdd.getConnectionImpl());
        cdi.setConnectionInterface(cdd.getConnectionIntf());
        Set mergedProps = ConnectorDDTransformUtils.mergeProps(props, cdd.getConfigProperties());
        cdi.setMCFConfigProperties(mergedProps);
        cdi.setResourceAdapterConfigProperties(connectorDescriptor.getConfigProperties());
        ccp.setSecurityMaps(SecurityMapUtils.getConnectorSecurityMaps(securityMaps));
        this.createConnectorConnectionPool(ccp, cdi);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, ConnectionDefDescriptor cdd, String rarName) throws ConnectorRuntimeException {
        if (ccp == null || cdd == null || rarName == null) {
            _logger.log(Level.FINE, "Wrong parameters for pool creation ");
            String i18nMsg = localStrings.getString("ccp_adm.wrong_params_for_create");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        ConnectorDescriptorInfo cdi = new ConnectorDescriptorInfo();
        ConnectorDescriptor connectorDescriptor = _registry.getDescriptor(rarName);
        if (connectorDescriptor == null) {
            this.ifSystemRarLoad(rarName);
            connectorDescriptor = _registry.getDescriptor(rarName);
        }
        if (connectorDescriptor == null) {
            String i18nMsg = localStrings.getString("ccp_adm.no_conn_pool_obj", rarName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_notfound_registry", rarName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        cdi.setRarName(rarName);
        cdi.setResourceAdapterClassName(connectorDescriptor.getResourceAdapterClass());
        cdi.setConnectionDefinitionName(cdd.getConnectionFactoryIntf());
        cdi.setManagedConnectionFactoryClass(cdd.getManagedConnectionFactoryImpl());
        cdi.setConnectionFactoryClass(cdd.getConnectionFactoryImpl());
        cdi.setConnectionFactoryInterface(cdd.getConnectionFactoryIntf());
        cdi.setConnectionClass(cdd.getConnectionImpl());
        cdi.setConnectionInterface(cdd.getConnectionIntf());
        cdi.setMCFConfigProperties(cdd.getConfigProperties());
        cdi.setResourceAdapterConfigProperties(connectorDescriptor.getConfigProperties());
        this.createConnectorConnectionPool(ccp, cdi);
    }

    private void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj, ConnectorDescriptorInfo connectorDescInfo) throws ConnectorRuntimeException {
        connectorPoolObj.setConnectorDescriptorInfo(connectorDescInfo);
        this.createConnectorConnectionPool(connectorPoolObj);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj) throws ConnectorRuntimeException {
        String poolName = connectorPoolObj.getName();
        if (connectorPoolObj == null || poolName == null) {
            _logger.log(Level.FINE, "Wrong parameters for pool creation ");
            String i18nMsg = localStrings.getString("ccp_adm.wrong_params_for_create");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
        try {
            Switch.getSwitch().getNamingManager().publishObject(jndiNameForPool, (Object)connectorPoolObj, true);
            ManagedConnectionFactory mcf = this.obtainManagedConnectionFactory(poolName);
            if (mcf == null) {
                InitialContext ic = new InitialContext();
                ic.unbind(jndiNameForPool);
                String i18nMsg = localStrings.getString("ccp_adm.failed_to_create_mcf", poolName);
                ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
                _logger.log(Level.SEVERE, "rardeployment.mcf_creation_failure", poolName);
                _logger.log(Level.SEVERE, "", cre);
                throw cre;
            }
        }
        catch (NamingException ex) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_publish_in_jndi", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(ex);
            _logger.log(Level.SEVERE, "rardeployment.pool_jndi_bind_failure", poolName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        catch (NullPointerException ex) {
            try {
                InitialContext ic = new InitialContext();
                ic.unbind(jndiNameForPool);
            }
            catch (NamingException ne) {
                _logger.log(Level.FINE, "Failed to unbind connection pool object  ", poolName);
            }
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_register_mcf", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(ex);
            _logger.log(Level.SEVERE, "rardeployment.mcf_registration_failure", poolName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj, String security, Set configProperties) throws ConnectorRuntimeException {
        if (connectorPoolObj == null || configProperties == null) {
            _logger.log(Level.FINE, "Wrong parameters for pool creation ");
            String i18nMsg = localStrings.getString("ccp_adm.wrong_params_for_create");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        String poolName = connectorPoolObj.getName();
        String moduleName = connectorPoolObj.getConnectorDescriptorInfo().getRarName();
        String connectionDefinitionName = connectorPoolObj.getConnectorDescriptorInfo().getConnectionDefinitionName();
        ConnectorDescriptor connectorDescriptor = _registry.getDescriptor(moduleName);
        if (connectorDescriptor == null) {
            this.ifSystemRarLoad(moduleName);
            connectorDescriptor = _registry.getDescriptor(moduleName);
        }
        if (connectorDescriptor == null) {
            String i18nMsg = localStrings.getString("ccp_adm.null_connector_desc", moduleName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.null_mcf_in_registry", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        Set connectionDefs = connectorDescriptor.getOutboundResourceAdapter().getConnectionDefs();
        Iterator iterator = connectionDefs.iterator();
        ConnectionDefDescriptor connectionDefDescriptor = null;
        while (iterator.hasNext() && !connectionDefinitionName.equals((connectionDefDescriptor = (ConnectionDefDescriptor)iterator.next()).getConnectionFactoryIntf())) {
        }
        ConnectorDescriptorInfo connectorDescInfo = ConnectorDDTransformUtils.getConnectorDescriptorInfo(connectionDefDescriptor);
        connectorDescInfo.setMCFConfigProperties(configProperties);
        connectorDescInfo.setRarName(moduleName);
        connectorDescInfo.setResourceAdapterClassName(connectorDescriptor.getResourceAdapterClass());
        this.createConnectorConnectionPool(connectorPoolObj, connectorDescInfo);
    }

    public void deleteConnectorConnectionPool(String poolName) throws ConnectorRuntimeException {
        this.deleteConnectorConnectionPool(poolName, false);
    }

    public void deleteConnectorConnectionPool(String poolName, boolean cascade) throws ConnectorRuntimeException {
        if (poolName == null) {
            _logger.log(Level.WARNING, "Deletion of pool : poolName null.");
            String i18nMsg = localStrings.getString("ccp_adm.null_pool_name");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        boolean errorOccured = false;
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        Object[] connectorResourcesJndiNames = resUtil.getConnectorResourcesJndiNames(poolName);
        if (cascade && connectorResourcesJndiNames != null) {
            for (int i = 0; i < connectorResourcesJndiNames.length; ++i) {
                try {
                    this.getRuntime().deleteConnectorResource((String)connectorResourcesJndiNames[i]);
                    continue;
                }
                catch (ConnectorRuntimeException cre) {
                    errorOccured = true;
                }
            }
        } else if (connectorResourcesJndiNames == null || connectorResourcesJndiNames.length != 0) {
            // empty if block
        }
        this.killPool(poolName);
        boolean result = _registry.removeManagedConnectionFactory(poolName);
        if (!result && !resUtil.poolBelongsToSystemRar(poolName)) {
            _logger.log(Level.FINE, "rardeployment.mcf_removal_failure", poolName);
            return;
        }
        try {
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            InitialContext ic = new InitialContext();
            ic.unbind(jndiNameForPool);
        }
        catch (NamingException ne) {
            if (resUtil.poolBelongsToSystemRar(poolName)) {
                return;
            }
            _logger.log(Level.SEVERE, "rardeployment.connectionpool_removal_from_jndi_error", poolName);
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_remove_from_jndi", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(ne);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        if (errorOccured && !resUtil.poolBelongsToSystemRar(poolName)) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_delete_conn_res", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.all_resources_removal_error", poolName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    private void unloadAndKillPool(String poolName) throws ConnectorRuntimeException {
        this.killPool(poolName);
        boolean result = _registry.removeManagedConnectionFactory(poolName);
        if (!result) {
            _logger.log(Level.SEVERE, "rardeployment.mcf_removal_failure", poolName);
            String i18nMsg = localStrings.getString("ccp_adm.wrong_params_for_create", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.FINE, "", cre);
            throw cre;
        }
        try {
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            InitialContext ic = new InitialContext();
            ic.unbind(jndiNameForPool);
        }
        catch (NamingException ne) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_remove_from_jndi", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(ne);
            _logger.log(Level.SEVERE, "rardeployment.connectionpool_removal_from_jndi_error", poolName);
            _logger.log(Level.FINE, "", cre);
            throw cre;
        }
    }

    public boolean testConnectionPool(String poolName) throws ResourceException {
        this.dump(poolName);
        Object con = null;
        try {
            DASResourcesUtil.setAdminConfigContext();
            con = this.getUnpooledConnection(poolName, null, false);
        }
        catch (Exception re) {
            _logger.log(Level.WARNING, re.getMessage());
            ResourceException e = new ResourceException(re.getMessage());
            e.initCause((Throwable)re);
            throw e;
        }
        finally {
            try {
                DASResourcesUtil.resetAdminConfigContext();
                ((ManagedConnection)con).destroy();
            }
            catch (Throwable e) {}
        }
        return true;
    }

    private ResourcePrincipal getDefaultResourcePrincipal(String poolName, ManagedConnectionFactory mcf) throws NamingException {
        ConnectorConnectionPool connectorConnectionPool = null;
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
        InitialContext ic = new InitialContext();
        connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
        ConnectorDescriptorInfo cdi = connectorConnectionPool.getConnectorDescriptorInfo();
        Set mcfConfigProperties = cdi.getMCFConfigProperties();
        Iterator mcfConfPropsIter = mcfConfigProperties.iterator();
        String userName = null;
        String password = null;
        while (mcfConfPropsIter.hasNext()) {
            EnvironmentProperty prop = (EnvironmentProperty)mcfConfPropsIter.next();
            if (prop.getName().toUpperCase().equals("USERNAME") || prop.getName().toUpperCase().equals("USER")) {
                userName = prop.getValue();
                continue;
            }
            if (!prop.getName().toUpperCase().equals("PASSWORD")) continue;
            password = prop.getValue();
            try {
                password = RelativePathResolver.getRealPasswordFromAlias(password);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "unable_to_get_password_from_alias", e);
            }
        }
        if (userName == null || userName.trim().equals("")) {
            userName = ConnectionPoolObjectsUtils.getValueFromMCF("UserName", poolName, mcf);
            if (userName.trim().equals("")) {
                userName = ConnectionPoolObjectsUtils.getValueFromMCF("User", poolName, mcf);
            }
            password = ConnectionPoolObjectsUtils.getValueFromMCF("Password", poolName, mcf);
        }
        return new ResourcePrincipal(userName, password);
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        return this.reconfigureConnectorConnectionPool(ccp, new HashSet());
    }

    public void switchOnMatching(String poolName) throws ConnectorRuntimeException {
        try {
            ConnectorConnectionPool origCcp = this.getOriginalConnectorConnectionPool(poolName);
            origCcp.setMatchConnections(true);
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            InitialContext ic = new InitialContext();
            ic.unbind(jndiNameForPool);
            Switch.getSwitch().getNamingManager().publishObject(jndiNameForPool, (Object)origCcp, true);
        }
        catch (NamingException e) {
            ConnectorRuntimeException ex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)ex.initCause(e);
        }
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp, Set excludedProps) throws ConnectorRuntimeException {
        this.logFine("ccp :\n" + (ccp != null ? ccp.toString() : "null"));
        String poolName = ccp.getName();
        ConnectorConnectionPool origCcp = null;
        try {
            origCcp = this.getOriginalConnectorConnectionPool(poolName);
        }
        catch (NamingException ne) {
            throw new ConnectorRuntimeException(ne.getMessage());
        }
        this.logFine("origCcp :\n" + (origCcp != null ? origCcp.toString() : "null"));
        ConnectionPoolReconfigHelper.ReconfigAction action = ConnectionPoolReconfigHelper.compare(origCcp, ccp, excludedProps);
        if (action == ConnectionPoolReconfigHelper.ReconfigAction.UPDATE_MCF_AND_ATTRIBUTES) {
            this.logFine("@@@@ action == " + (Object)((Object)action));
            this.updateMCFAndPoolAttributes(ccp);
        } else if (action == ConnectionPoolReconfigHelper.ReconfigAction.RECREATE_POOL) {
            this.logFine("@@@@ action == " + (Object)((Object)action));
            return true;
        }
        return false;
    }

    private ConnectorConnectionPool getOriginalConnectorConnectionPool(String poolName) throws NamingException {
        ConnectorConnectionPool ccpOrig = null;
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
        InitialContext ic = new InitialContext();
        try {
            ccpOrig = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
        }
        catch (NamingException ne) {
            if (this.checkAndLoadPoolResource(poolName)) {
                ccpOrig = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
            }
            throw ne;
        }
        return ccpOrig;
    }

    private void updateMCFAndPoolAttributes(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        String poolName = ccp.getName();
        try {
            ConnectorConnectionPool origCcp = this.getOriginalConnectorConnectionPool(poolName);
            origCcp.setSteadyPoolSize(ccp.getSteadyPoolSize());
            origCcp.setMaxPoolSize(ccp.getMaxPoolSize());
            origCcp.setMaxWaitTimeInMillis(ccp.getMaxWaitTimeInMillis());
            origCcp.setPoolResizeQuantity(ccp.getPoolResizeQuantity());
            origCcp.setIdleTimeoutInSeconds(ccp.getIdleTimeoutInSeconds());
            origCcp.setFailAllConnections(ccp.isFailAllConnections());
            origCcp.setMatchConnections(ccp.matchConnections());
            origCcp.setMaxConnectionUsage(ccp.getMaxConnectionUsage());
            origCcp.setNonComponent(ccp.isNonComponent());
            origCcp.setNonTransactional(ccp.isNonTransactional());
            origCcp.setConCreationRetryAttempts(ccp.getConCreationRetryAttempts());
            origCcp.setConCreationRetryInterval(ccp.getConCreationRetryInterval());
            origCcp.setValidateAtmostOncePeriod(ccp.getValidateAtmostOncePeriod());
            origCcp.setConnectionLeakTracingTimeout(ccp.getConnectionLeakTracingTimeout());
            origCcp.setConnectionReclaim(ccp.isConnectionReclaim());
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            InitialContext ic = new InitialContext();
            ic.unbind(jndiNameForPool);
            Switch.getSwitch().getNamingManager().publishObject(jndiNameForPool, (Object)origCcp, true);
        }
        catch (NamingException ne) {
            throw new ConnectorRuntimeException(ne.getMessage());
        }
        PoolManager poolMgr = Switch.getSwitch().getPoolManager();
        try {
            poolMgr.reconfigPoolProperties(ccp);
        }
        catch (PoolingException pe) {
            throw new ConnectorRuntimeException(pe.getMessage());
        }
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        ManagedConnectionFactory mcf = registry.getManagedConnectionFactory(poolName);
        SetMethodAction sma = new SetMethodAction(mcf, ccp.getConnectorDescriptorInfo().getMCFConfigProperties());
        try {
            sma.run();
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
        PoolMetaData pmd = registry.getPoolMetaData(poolName);
        pmd.setIsPM(ccp.isNonComponent());
        pmd.setIsNonTx(ccp.isNonTransactional());
        pmd.setLazyEnlistable(ccp.isLazyConnectionEnlist());
        pmd.setAuthCredentialsDefinedInPool(ccp.getAuthCredentialsDefinedInPool());
        this.logFine("Pool properties reconfiguration done");
    }

    public void recreateConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        if (registry == null) {
            throw new ConnectorRuntimeException("Cannot get ConnectorRegistry");
        }
        String poolName = ccp.getName();
        this.unloadAndKillPool(poolName);
        try {
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            Switch.getSwitch().getNamingManager().publishObject(jndiNameForPool, (Object)ccp, true);
            ManagedConnectionFactory mcf = null;
            mcf = this.obtainManagedConnectionFactory(poolName);
            if (mcf == null) {
                InitialContext ic = new InitialContext();
                ic.unbind(jndiNameForPool);
                _logger.log(Level.WARNING, "rardeployment.mcf_creation_failure", poolName);
                String i18nMsg = localStrings.getString("ccp_adm.failed_to_create_mcf", poolName);
                throw new ConnectorRuntimeException(i18nMsg);
            }
        }
        catch (NamingException ne) {
            _logger.log(Level.SEVERE, "rardeployment.pool_jndi_bind_failure", poolName);
            String i18nMsg = localStrings.getString("ccp_adm.could_not_recreate_pool", poolName);
            ConnectorRuntimeException crex = new ConnectorRuntimeException(i18nMsg);
            crex.initCause(ne);
            throw crex;
        }
    }

    private ConnectorConnectionPool getConnectorConnectionPool(String poolName) throws ConnectorRuntimeException, NamingException {
        InitialContext ic = new InitialContext();
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
        ConnectorConnectionPool connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
        if (connectorConnectionPool == null) {
            String i18nMsg = localStrings.getString("ccp_adm.null_pool", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.connectionpool_object_null", poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        return connectorConnectionPool;
    }

    private ActiveResourceAdapter getResourceAdapter(ConnectorConnectionPool connectorConnectionPool) throws ConnectorRuntimeException {
        String rarName = connectorConnectionPool.getConnectorDescriptorInfo().getRarName();
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(rarName);
        if (activeResourceAdapter == null) {
            this.ifSystemRarLoad(rarName);
            activeResourceAdapter = _registry.getActiveResourceAdapter(rarName);
        }
        if (activeResourceAdapter == null) {
            String i18nMsg = localStrings.getString("ccp_adm.active_ra_not_init", rarName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.resourceadapter_not_initialized", rarName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        return activeResourceAdapter;
    }

    public ManagedConnectionFactory[] obtainManagedConnectionFactories(String poolName) throws ConnectorRuntimeException {
        ManagedConnectionFactory[] mcfs = null;
        try {
            ConnectorConnectionPool conPool = this.getConnectorConnectionPool(poolName);
            ActiveResourceAdapter activeResourceAdapter = this.getResourceAdapter(conPool);
            mcfs = activeResourceAdapter.createManagedConnectionFactories(conPool, null);
        }
        catch (NamingException ne) {
            String i18nMsg = localStrings.getString("pingpool.name_not_bound", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(ne);
            _logger.log(Level.FINE, "rardeployment.jndi_lookup_failed", poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        catch (NullPointerException ne) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_register_mcf", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(ne);
            _logger.log(Level.SEVERE, "mcf_add_toregistry_failed", poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        return mcfs;
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(String poolName) throws ConnectorRuntimeException {
        try {
            if (_registry.isMCFCreated(poolName)) {
                return _registry.getManagedConnectionFactory(poolName);
            }
            ConnectorConnectionPool connectorConnectionPool = this.getConnectorConnectionPool(poolName);
            ActiveResourceAdapter activeResourceAdapter = this.getResourceAdapter(connectorConnectionPool);
            ManagedConnectionFactory mcf = activeResourceAdapter.createManagedConnectionFactory(connectorConnectionPool, null);
            if (mcf != null) {
                ResourcePrincipal prin = this.getDefaultResourcePrincipal(poolName, mcf);
                Subject s = ConnectionPoolObjectsUtils.createSubject(mcf, prin);
                int txSupport = connectorConnectionPool.getTransactionSupport();
                boolean isPM = connectorConnectionPool.isNonComponent();
                boolean isNonTx = connectorConnectionPool.isNonTransactional();
                ConnectorSecurityMap[] securityMaps = connectorConnectionPool.getSecurityMaps();
                RuntimeSecurityMap runtimeSecurityMap = SecurityMapUtils.processSecurityMaps(securityMaps);
                boolean lazyEnlistable = connectorConnectionPool.isLazyConnectionEnlist();
                boolean lazyAssoc = connectorConnectionPool.isLazyConnectionAssoc();
                if (isPM || isNonTx) {
                    lazyEnlistable = false;
                }
                if (isPM) {
                    String str = System.getProperty("com.sun.enterprise.resource.AllowLazyAssociationWithPM");
                    lazyAssoc = str != null && str.toUpperCase().trim().equals("TRUE") ? (lazyAssoc &= true) : false;
                }
                PoolMetaData pmd = new PoolMetaData(poolName, mcf, s, txSupport, prin, isPM, isNonTx, lazyEnlistable, runtimeSecurityMap, lazyAssoc);
                this.logFine(pmd.toString());
                _registry.addManagedConnectionFactory(poolName, pmd);
            }
            ConnectorConstants.PoolType pt = connectorConnectionPool.isAssociateWithThread() ? ConnectorConstants.PoolType.ASSOCIATE_WITH_THREAD_POOL : ConnectorConstants.PoolType.STANDARD_POOL;
            this.createAndAddPool(poolName, pt);
            return mcf;
        }
        catch (NamingException ne) {
            String i18nMsg = localStrings.getString("pingpool.name_not_bound", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(ne);
            _logger.log(Level.FINE, "rardeployment.jndi_lookup_failed", poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        catch (NullPointerException ne) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_register_mcf", poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(ne);
            _logger.log(Level.SEVERE, "mcf_add_toregistry_failed", poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
    }

    public void killAllPools(String moduleName) {
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        Object[] poolNamesArray = resUtil.getConnectorConnectionPoolNames(moduleName);
        String poolName = null;
        for (int i = 0; poolNamesArray != null && i < poolNamesArray.length; ++i) {
            poolName = (String)poolNamesArray[i];
            this.killPool(poolName);
        }
    }

    public void killPool(String poolName) {
        Switch.getSwitch().getPoolManager().killPool(poolName);
    }

    public static Set getConnectionDefinitionProperties(String connectionDefinitionClassName) {
        return ConnectionDefinitionUtils.getConnectionDefinitionProperties(connectionDefinitionClassName);
    }

    public static Map getConnectionDefinitionPropertiesAndDefaults(String connectionDefinitionClassName) {
        return ConnectionDefinitionUtils.getConnectionDefinitionPropertiesAndDefaults(connectionDefinitionClassName);
    }

    private Object getUnpooledConnection(String poolName, ResourcePrincipal prin, boolean returnConnectionHandle) throws ResourceException {
        ManagedConnectionFactory mcf = null;
        boolean needToUndeployPool = false;
        JdbcConnectionPool jdbcPoolToDeploy = null;
        com.sun.enterprise.config.serverbeans.ConnectorConnectionPool ccPoolToDeploy = null;
        try {
            mcf = this.obtainManagedConnectionFactory(poolName);
        }
        catch (ConnectorRuntimeException cre) {
            this.logFine("getUnpooledConnection :: obtainManagedConnectionFactory threw exception. SO doing checkAndLoadPoolResource");
            if (this.checkAndLoadPoolResource(poolName)) {
                this.logFine("getUnpooledConnection:: checkAndLoadPoolResource is true");
                try {
                    if (!this.isConnectorConnectionPoolDeployed(poolName)) {
                        this.logFine("getUnpooledConnection :: isConnectorConnectionPoolDeployed is false");
                        try {
                            jdbcPoolToDeploy = this.getJdbcConnectionPoolServerBean(poolName);
                            if (jdbcPoolToDeploy != null) {
                                new JdbcConnectionPoolDeployer().deployResource(jdbcPoolToDeploy);
                                this.logFine("getUnpooledConnection :: force deployed the JdbcConnectionPool : " + poolName);
                            } else {
                                ccPoolToDeploy = this.getConnectorConnectionPoolServerBean(poolName);
                                new ConnectorConnectionPoolDeployer().deployResource(ccPoolToDeploy);
                                this.logFine("getUnpooledConnection :: force deployed the ConnectorConnectionPool :" + poolName);
                            }
                            needToUndeployPool = true;
                        }
                        catch (Exception e) {
                            _logger.log(Level.SEVERE, "jdbc.could_not_do_actual_deploy for : ", poolName);
                            throw new ResourceException((Throwable)e);
                        }
                    }
                    this.logFine("getUnpooledConnection :: Now calling obtainManagedConnectionFactory again");
                    mcf = this.obtainManagedConnectionFactory(poolName);
                    this.logFine("getUnpooledConnection:: done obtainManagedConnectionFactory again");
                }
                catch (ConnectorRuntimeException creAgain) {
                    String l10nMsg = localStrings.getString("pingpool.cannot_obtain_mcf", poolName);
                    _logger.log(Level.WARNING, "jdbc.pool_not_reachable", l10nMsg);
                    ResourceException e = new ResourceException(l10nMsg);
                    e.initCause((Throwable)creAgain);
                    throw e;
                }
            }
            _logger.log(Level.WARNING, "jdbc.pool_not_reachable", cre.getMessage());
            String l10nMsg = localStrings.getString("pingpool.cannot_obtain_mcf", poolName);
            ResourceException e = new ResourceException(l10nMsg);
            e.initCause((Throwable)cre);
            throw e;
        }
        ResourcePrincipal resourcePrincipal = null;
        if (prin == null) {
            try {
                resourcePrincipal = this.getDefaultResourcePrincipal(poolName, mcf);
            }
            catch (NamingException ne) {
                _logger.log(Level.WARNING, "jdbc.pool_not_reachable", ne.getMessage());
                String l10nMsg = localStrings.getString("pingpool.name_not_bound", poolName);
                ResourceException e = new ResourceException(l10nMsg + poolName);
                e.initCause((Throwable)ne);
                throw e;
            }
        } else {
            resourcePrincipal = prin;
        }
        Subject defaultSubject = ConnectionPoolObjectsUtils.createSubject(mcf, resourcePrincipal);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("using subject: " + defaultSubject);
        }
        ManagedConnection mc = null;
        mc = mcf.createManagedConnection(defaultSubject, null);
        if (needToUndeployPool) {
            if (jdbcPoolToDeploy != null) {
                this.logFine("getUnpooledConnection :: need to force undeploy pool");
                try {
                    new JdbcConnectionPoolDeployer().undeployResource(jdbcPoolToDeploy);
                }
                catch (Exception e) {
                    _logger.fine("getUnpooledConnection: error undeploying pool");
                }
                this.logFine("getUnpooledConnection :: done.. force undeploy of pool");
            } else {
                try {
                    new ConnectorConnectionPoolDeployer().undeployResource(ccPoolToDeploy);
                }
                catch (Exception e) {
                    _logger.fine("getUnpooledConnection: error undeploying pool");
                }
                this.logFine("getUnpooledConnection :: done.. force undeploy of pool");
            }
        }
        mc.addConnectionEventListener((ConnectionEventListener)new UnpooledConnectionEventListener());
        return returnConnectionHandle ? mc.getConnection(defaultSubject, null) : mc;
    }

    public Connection getConnection(String jndiName, String user, String password) throws SQLException {
        Connection con = null;
        try {
            DASResourcesUtil.setAdminConfigContext();
            String poolName = this.getPoolNameFromResourceJndiName(jndiName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ConnectorRuntime.getConnection :: poolName : " + poolName);
            }
            String passwd = password == null ? "" : password;
            ResourcePrincipal prin = user == null ? null : new ResourcePrincipal(user, password);
            con = (Connection)this.getUnpooledConnection(poolName, prin, true);
            if (con == null) {
                String i18nMsg = localStrings.getString("ccp_adm.null_unpooled_connection");
                SQLException sqle = new SQLException(i18nMsg);
                throw sqle;
            }
        }
        catch (ResourceException re) {
            SQLException sqle = new SQLException(re.getMessage());
            sqle.initCause(re);
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" getConnection in ConnectorRuntime failed : " + (Object)((Object)re));
            }
            throw sqle;
        }
        catch (ConfigException ex) {
            SQLException sqle = new SQLException(ex.getMessage());
            sqle.initCause(ex);
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", ex.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" getConnection in ConnectorRuntime failed : " + ex);
            }
            throw sqle;
        }
        finally {
            block15: {
                try {
                    DASResourcesUtil.resetAdminConfigContext();
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINE)) break block15;
                    _logger.fine("caught exception while setting getConnectionFromConnectorRuntime to false");
                }
            }
        }
        return con;
    }

    public Connection getConnection(String jndiName) throws SQLException {
        Connection con = null;
        try {
            DASResourcesUtil.setAdminConfigContext();
            String poolName = this.getPoolNameFromResourceJndiName(jndiName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ConnectorRuntime.getConnection :: poolName : " + poolName);
            }
            if ((con = (Connection)this.getUnpooledConnection(poolName, null, true)) == null) {
                String i18nMsg = localStrings.getString("ccp_adm.null_unpooled_connection");
                SQLException sqle = new SQLException(i18nMsg);
                throw sqle;
            }
        }
        catch (ResourceException re) {
            SQLException sqle = new SQLException(re.getMessage());
            sqle.initCause(re);
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Exception : " + (Object)((Object)re));
            }
            throw sqle;
        }
        catch (ConfigException ex) {
            SQLException sqle = new SQLException(ex.getMessage());
            sqle.initCause(ex);
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", ex.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" getConnection in ConnectorRuntime failed : " + ex);
            }
            throw sqle;
        }
        finally {
            block15: {
                try {
                    DASResourcesUtil.resetAdminConfigContext();
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINE)) break block15;
                    _logger.fine("caught exception while setting getConnectionFromConnectorRuntime to false");
                }
            }
        }
        return con;
    }

    private String getPoolNameFromResourceJndiName(String jndiName) {
        Object poolName = null;
        JdbcResource jdbcRes = null;
        DASResourcesUtil resourcesUtil = (DASResourcesUtil)ResourcesUtil.createInstance();
        PersistenceManagerFactoryResource pmfRes = resourcesUtil.getPMFResourceByJndiName(jndiName);
        jdbcRes = pmfRes != null ? resourcesUtil.getJdbcResourceByJndiName(pmfRes.getJdbcResourceJndiName()) : resourcesUtil.getJdbcResourceByJndiName(jndiName);
        if (jdbcRes != null && _logger.isLoggable(Level.FINE)) {
            _logger.fine("jdbcRes is ---: " + jdbcRes.getJndiName());
            _logger.fine("poolName is ---: " + jdbcRes.getPoolName());
        }
        return jdbcRes == null ? null : jdbcRes.getPoolName();
    }

    public boolean isConnectorConnectionPoolDeployed(String poolName) {
        try {
            InitialContext ic = new InitialContext();
            String jndiName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            ic.lookup(jndiName);
            return true;
        }
        catch (NamingException e) {
            return false;
        }
    }

    private void dump(String poolName) {
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            Domain dom = ServerBeansFactory.getDomainBean(ctx);
            Resources res = dom.getResources();
            ConfigBean dasContextBean = null;
            JdbcConnectionPool jdbcPool = res.getJdbcConnectionPoolByName(poolName);
            if (jdbcPool != null) {
                dasContextBean = jdbcPool;
            } else {
                com.sun.enterprise.config.serverbeans.ConnectorConnectionPool ccPool = res.getConnectorConnectionPoolByName(poolName);
                if (ccPool != null) {
                    dasContextBean = ccPool;
                }
            }
            if (dasContextBean != null) {
                StringBuffer str = new StringBuffer();
                dasContextBean.dump(str, "\t\t");
                _logger.log(Level.FINE, "DAS CONTEXT IS : " + str);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception while dumping pool details ", e.fillInStackTrace());
        }
    }

    private JdbcConnectionPool getJdbcConnectionPoolServerBean(String poolName) throws ConfigException {
        if (poolName == null) {
            throw new ConfigException("null poolname");
        }
        ConfigContext ctxt = null;
        ctxt = ResourcesUtil.isDAS() ? AdminService.getAdminService().getAdminContext().getAdminConfigContext() : ApplicationServer.getServerContext().getConfigContext();
        Domain dom = ServerBeansFactory.getDomainBean(ctxt);
        Resources res = dom.getResources();
        return res.getJdbcConnectionPoolByName(poolName);
    }

    private com.sun.enterprise.config.serverbeans.ConnectorConnectionPool getConnectorConnectionPoolServerBean(String poolName) throws ConfigException {
        if (poolName == null) {
            throw new ConfigException("null poolname");
        }
        ConfigContext ctxt = null;
        ctxt = ResourcesUtil.isDAS() ? AdminService.getAdminService().getAdminContext().getAdminConfigContext() : ApplicationServer.getServerContext().getConfigContext();
        Domain dom = ServerBeansFactory.getDomainBean(ctxt);
        Resources res = dom.getResources();
        return res.getConnectorConnectionPoolByName(poolName);
    }

    private void logFine(String msg) {
        if (msg != null && _logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    private void createAndAddPool(String poolName, ConnectorConstants.PoolType pt) throws ConnectorRuntimeException {
        PoolManager poolMgr = Switch.getSwitch().getPoolManager();
        try {
            poolMgr.createEmptyConnectionPool(poolName, pt);
        }
        catch (PoolingException pe) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_create_pool_object");
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(pe);
            throw cre;
        }
    }

    private void initialize() {
        Switch sw = Switch.getSwitch();
        if (sw.getContainerType() == 0) {
            try {
                if (sw.getPoolManager() == null) {
                    sw.setPoolManager(new PoolManagerImpl());
                }
                if (sw.getNamingManager() == null) {
                    sw.setNamingManager(new NamingManagerImpl());
                }
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, e.getMessage());
            }
        }
    }
}

