/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.namespace.QName;

public class ServiceReferenceDescriptor
extends EnvironmentProperty
implements HandlerChainContainer {
    private String serviceInterface;
    private String mappedName;
    private String wsdlFileUri;
    private URL wsdlFileUrl;
    private String mappingFileUri;
    private File mappingFile;
    private String serviceNamespaceUri;
    private String serviceLocalPart;
    private String serviceNameNamespacePrefix;
    private Set portsInfo;
    private BundleDescriptor bundleDescriptor;
    private LinkedList handlers;
    private LinkedList handlerChain;
    private Set callProperties;
    private String serviceImplClassName;
    private URL wsdlOverride;
    private String injectionTargetType = null;

    public ServiceReferenceDescriptor(ServiceReferenceDescriptor other) {
        super(other);
        this.serviceInterface = other.serviceInterface;
        this.mappedName = other.mappedName;
        this.wsdlFileUri = other.wsdlFileUri;
        this.wsdlFileUrl = other.wsdlFileUrl;
        this.mappingFileUri = other.mappingFileUri;
        this.mappingFile = other.mappingFile;
        this.serviceNamespaceUri = other.serviceNamespaceUri;
        this.serviceLocalPart = other.serviceLocalPart;
        this.serviceNameNamespacePrefix = other.serviceNameNamespacePrefix;
        this.portsInfo = new HashSet();
        Iterator i = other.portsInfo.iterator();
        while (i.hasNext()) {
            ServiceRefPortInfo port = new ServiceRefPortInfo((ServiceRefPortInfo)i.next());
            port.setServiceReference(this);
            this.portsInfo.add(port);
        }
        this.handlers = new LinkedList();
        i = other.handlers.iterator();
        while (i.hasNext()) {
            this.handlers.add(new WebServiceHandler((WebServiceHandler)i.next()));
        }
        this.handlerChain = new LinkedList();
        i = other.handlerChain.iterator();
        while (i.hasNext()) {
            this.handlerChain.add(new WebServiceHandlerChain((WebServiceHandlerChain)i.next()));
        }
        this.callProperties = new HashSet();
        i = other.callProperties.iterator();
        while (i.hasNext()) {
            this.callProperties.add(new NameValuePairDescriptor((NameValuePairDescriptor)i.next()));
        }
        this.serviceImplClassName = other.serviceImplClassName;
    }

    public ServiceReferenceDescriptor(String name, String description, String service) {
        super(name, "", description);
        this.handlers = new LinkedList();
        this.handlerChain = new LinkedList();
        this.portsInfo = new HashSet();
        this.callProperties = new HashSet();
        this.serviceInterface = service;
    }

    public ServiceReferenceDescriptor() {
        this.handlers = new LinkedList();
        this.handlerChain = new LinkedList();
        this.portsInfo = new HashSet();
        this.callProperties = new HashSet();
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String value) {
        this.mappedName = value;
    }

    public void setBundleDescriptor(BundleDescriptor bundle) {
        this.bundleDescriptor = bundle;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public boolean hasGenericServiceInterface() {
        return this.serviceInterface.equals("javax.xml.rpc.Service");
    }

    public boolean hasGeneratedServiceInterface() {
        return !this.hasGenericServiceInterface();
    }

    public void setServiceInterface(String service) {
        this.serviceInterface = service;
        super.changed();
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public boolean hasWsdlFile() {
        return this.wsdlFileUri != null;
    }

    public void setWsdlFileUrl(URL url) {
        this.wsdlFileUrl = url;
        super.changed();
    }

    public URL getWsdlFileUrl() {
        return this.wsdlFileUrl;
    }

    public void setWsdlFileUri(String uri) {
        if (uri.startsWith("file:")) {
            uri = uri.substring(5);
        }
        this.wsdlFileUri = uri;
        super.changed();
    }

    public String getWsdlFileUri() {
        return this.wsdlFileUri;
    }

    public boolean hasMappingFile() {
        return this.mappingFileUri != null;
    }

    public void setMappingFile(File file) {
        this.mappingFile = file;
        super.changed();
    }

    public File getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFileUri(String uri) {
        this.mappingFileUri = uri;
        super.changed();
    }

    public String getMappingFileUri() {
        return this.mappingFileUri;
    }

    public void setServiceName(QName serviceName) {
        this.setServiceName(serviceName, null);
    }

    public void setServiceName(QName serviceName, String prefix) {
        this.serviceNamespaceUri = serviceName.getNamespaceURI();
        this.serviceLocalPart = serviceName.getLocalPart();
        this.serviceNameNamespacePrefix = prefix;
        super.changed();
    }

    public void setServiceNamespaceUri(String uri) {
        this.serviceNamespaceUri = uri;
        this.serviceNameNamespacePrefix = null;
        super.changed();
    }

    public String getServiceNamespaceUri() {
        return this.serviceNamespaceUri;
    }

    public void setServiceLocalPart(String localpart) {
        this.serviceLocalPart = localpart;
        this.serviceNameNamespacePrefix = null;
        super.changed();
    }

    public String getServiceLocalPart() {
        return this.serviceLocalPart;
    }

    public void setServiceNameNamespacePrefix(String prefix) {
        this.serviceNameNamespacePrefix = prefix;
        super.changed();
    }

    public String getServiceNameNamespacePrefix() {
        return this.serviceNameNamespacePrefix;
    }

    public boolean hasServiceName() {
        return this.serviceNamespaceUri != null && this.serviceLocalPart != null;
    }

    public QName getServiceName() {
        return this.hasServiceName() ? new QName(this.serviceNamespaceUri, this.serviceLocalPart) : null;
    }

    public Set getPortsInfo() {
        return this.portsInfo;
    }

    public void addPortInfo(ServiceRefPortInfo portInfo) {
        portInfo.setServiceReference(this);
        this.portsInfo.add(portInfo);
        super.changed();
    }

    public void removePortInfo(ServiceRefPortInfo portInfo) {
        this.portsInfo.remove(portInfo);
        super.changed();
    }

    public void addRuntimePortInfo(ServiceRefPortInfo runtimePortInfo) {
        ServiceRefPortInfo existing = null;
        if (runtimePortInfo.hasServiceEndpointInterface()) {
            existing = this.getPortInfoBySEI(runtimePortInfo.getServiceEndpointInterface());
        }
        if (existing == null && runtimePortInfo.hasWsdlPort()) {
            existing = this.getPortInfoByPort(runtimePortInfo.getWsdlPort());
        }
        if (existing == null) {
            if (this.portsInfo != null && this.portsInfo.size() > 0) {
                LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServiceReferenceDescriptor.class);
                DOLUtils.getDefaultLogger().warning(localStrings.getLocalString("enterprise.deployment.unknownportforruntimeinfo", "Runtime port info SEI {0} is not declared in standard service-ref deployment descriptors (under port-component-ref), is this intended ?", new Object[]{runtimePortInfo.getServiceEndpointInterface()}));
            }
            this.addPortInfo(runtimePortInfo);
        } else {
            if (!existing.hasServiceEndpointInterface()) {
                existing.setServiceEndpointInterface(runtimePortInfo.getServiceEndpointInterface());
            }
            if (!existing.hasWsdlPort()) {
                existing.setWsdlPort(runtimePortInfo.getWsdlPort());
            }
            for (NameValuePairDescriptor next : runtimePortInfo.getStubProperties()) {
                existing.addStubProperty(next);
            }
            for (NameValuePairDescriptor next : runtimePortInfo.getCallProperties()) {
                existing.addCallProperty(next);
            }
            if (runtimePortInfo.getMessageSecurityBinding() != null) {
                existing.setMessageSecurityBinding(runtimePortInfo.getMessageSecurityBinding());
            }
        }
    }

    public ServiceRefPortInfo addContainerManagedPort(String serviceEndpointInterface) {
        ServiceRefPortInfo info = new ServiceRefPortInfo();
        info.setServiceEndpointInterface(serviceEndpointInterface);
        info.setIsContainerManaged(true);
        info.setServiceReference(this);
        this.portsInfo.add(info);
        super.changed();
        return info;
    }

    public boolean hasContainerManagedPorts() {
        boolean containerManaged = false;
        for (ServiceRefPortInfo next : this.portsInfo) {
            if (!next.isContainerManaged()) continue;
            containerManaged = true;
            break;
        }
        return containerManaged;
    }

    public boolean hasClientManagedPorts() {
        boolean clientManaged = false;
        for (ServiceRefPortInfo next : this.portsInfo) {
            if (!next.isClientManaged()) continue;
            clientManaged = true;
            break;
        }
        return clientManaged;
    }

    public ServiceRefPortInfo getPortInfo(String serviceEndpointInterface) {
        return this.getPortInfoBySEI(serviceEndpointInterface);
    }

    public ServiceRefPortInfo getPortInfoBySEI(String serviceEndpointInterface) {
        for (ServiceRefPortInfo next : this.portsInfo) {
            if (!serviceEndpointInterface.equals(next.getServiceEndpointInterface())) continue;
            return next;
        }
        return null;
    }

    public ServiceRefPortInfo getPortInfoByPort(QName wsdlPort) {
        for (ServiceRefPortInfo next : this.portsInfo) {
            if (!next.hasWsdlPort() || !wsdlPort.equals(next.getWsdlPort())) continue;
            return next;
        }
        return null;
    }

    public void addHandler(WebServiceHandler handler) {
        this.handlers.addLast(handler);
        super.changed();
    }

    public void removeHandler(WebServiceHandler handler) {
        this.handlers.remove(handler);
        super.changed();
    }

    public void removeHandlerByName(String handlerName) {
        Iterator iter = this.handlers.iterator();
        while (iter.hasNext()) {
            WebServiceHandler next = (WebServiceHandler)iter.next();
            if (!next.getHandlerName().equals(handlerName)) continue;
            iter.remove();
            super.changed();
            break;
        }
    }

    public boolean hasHandlers() {
        return this.handlers.size() > 0;
    }

    public LinkedList getHandlers() {
        return this.handlers;
    }

    public void addHandlerChain(WebServiceHandlerChain handler) {
        this.handlerChain.addLast(handler);
        super.changed();
    }

    public void removeHandlerChain(WebServiceHandlerChain handler) {
        this.handlerChain.remove(handler);
        super.changed();
    }

    public boolean hasHandlerChain() {
        return this.handlerChain.size() > 0;
    }

    public LinkedList getHandlerChain() {
        return this.handlerChain;
    }

    public Set getCallProperties() {
        return this.callProperties;
    }

    public NameValuePairDescriptor getCallPropertyByName(String name) {
        NameValuePairDescriptor prop = null;
        for (NameValuePairDescriptor next : this.callProperties) {
            if (!next.getName().equals(name)) continue;
            prop = next;
            break;
        }
        return prop;
    }

    public void addCallProperty(NameValuePairDescriptor property) {
        NameValuePairDescriptor prop = this.getCallPropertyByName(property.getName());
        if (prop != null) {
            prop.setValue(property.getValue());
        } else {
            this.callProperties.add(property);
        }
    }

    public void removeCallProperty(NameValuePairDescriptor property) {
        NameValuePairDescriptor prop = this.getCallPropertyByName(property.getName());
        if (prop != null) {
            this.callProperties.remove(property);
        }
    }

    public boolean hasServiceImplClassName() {
        return this.serviceImplClassName != null;
    }

    public void setServiceImplClassName(String className) {
        this.serviceImplClassName = className;
    }

    public String getServiceImplClassName() {
        return this.serviceImplClassName;
    }

    public boolean hasWsdlOverride() {
        return this.wsdlOverride != null;
    }

    public void setWsdlOverride(URL override) {
        this.wsdlOverride = override;
    }

    public URL getWsdlOverride() {
        return this.wsdlOverride;
    }

    public void setInjectionTargetType(String type) {
        this.injectionTargetType = type;
    }

    public String getInjectionTargetType() {
        return this.injectionTargetType;
    }

    public boolean equals(Object object) {
        if (object instanceof ServiceReferenceDescriptor) {
            ServiceReferenceDescriptor thatReference = (ServiceReferenceDescriptor)object;
            return thatReference.getName().equals(this.getName());
        }
        return false;
    }
}

