/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.AppDeployerBase;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.logging.Level;

public class AppUnDeployer
extends AppDeployerBase {
    private String failureMessage = "Undeployment Failed -- rolled back undeployment";
    private String successMessage = "Undeployment Successful for ";
    private boolean isMaybeCMPDropTables = false;
    private Application applicationDD = null;
    private static StringManager localStrings = StringManager.getManager(AppUnDeployer.class);

    AppUnDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    public void doRequest() throws IASDeploymentException {
        this.doRequestPrepare();
        this.doRequestFinish();
    }

    public void doRequestPrepare() throws IASDeploymentException {
        try {
            this.begin();
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
            this.logger.log(Level.WARNING, msg, e);
            throw new IASDeploymentException(msg, e);
        }
    }

    public void doRequestFinish() throws IASDeploymentException {
        try {
            this.predeploy();
            this.localBegin();
            this.undeploy();
            this.removePolicy();
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
            this.logger.log(Level.WARNING, msg, e);
            throw new IASDeploymentException(msg, e);
        }
        finally {
            this.finish();
        }
    }

    public void cleanup_internal() {
        try {
            if (this.isMaybeCMPDropTables) {
                this.dropTables();
            }
            this.liquidate();
        }
        catch (Exception e) {
            this.logger.warning("Caught an Exception in cleanup_internal: " + e);
        }
    }

    protected final File setAppDir() throws IASDeploymentException {
        try {
            return new File(DeploymentServiceUtils.getLocation(this.getAppName(), this.request.getType()));
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_getting_app_directory", e);
            throw new IASDeploymentException(msg, e);
        }
    }

    private void undeploy() throws IASDeploymentException {
        try {
            this.getManager().unregisterDescriptor(this.getAppName());
            this.addToSummary(this.successMessage + this.getAppName());
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    private void localBegin() {
        try {
            if (this.getRequest().isMaybeCMPDropTables()) {
                this.isMaybeCMPDropTables = true;
                this.applicationDD = this.getManager().getRegisteredDescriptor(this.getAppName());
                if (this.applicationDD == null) {
                    this.applicationDD = this.request.getDescriptor();
                }
            }
        }
        catch (Exception e) {
            this.logger.warning("Caught an Exception in localBegin: " + e);
        }
    }

    private void dropTables() {
        assert (this.isMaybeCMPDropTables);
        try {
            DeploymentEventInfo info = new DeploymentEventInfo(this.getAppDir(), this.getStubsDir(), this.applicationDD, this.getRequest());
            DeploymentEvent ev = new DeploymentEvent(3, info);
            DeploymentEventManager.notifyDeploymentEvent(ev);
        }
        catch (Throwable t) {
            this.logger.warning("Caught a Throwable in dropTables: " + t);
        }
    }
}

