/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.backend.ClientJarMakerRegistry;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.PEDeploymentFactoryImpl;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.deployment.interfaces.ClientJarMaker;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class ClientJarMakerThread
extends Thread {
    private DeploymentRequest request;
    private File clientJar;
    private ZipItem[] clientStubs;
    private String clientJarChoice = null;
    private static StringManager localStrings = StringManager.getManager(Deployer.class);

    public ClientJarMakerThread(DeploymentRequest request, File clientJar, ZipItem[] clientStubs, String clientJarChoice) {
        this.request = request;
        this.clientJar = clientJar;
        this.clientStubs = clientStubs;
        this.clientJarChoice = clientJarChoice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ClientJarMakerRegistry registry = ClientJarMakerRegistry.getInstance();
        String moduleID = this.request.getName();
        registry.register(moduleID, this);
        try {
            ClientJarMakerThread.createClientJar(this.request, this.clientJar, this.clientStubs, this.clientJarChoice);
        }
        catch (IASDeploymentException e) {
            DeploymentLogger.get().log(Level.SEVERE, localStrings.getString("enterprise.deployment.error_creating_client_jar", e.getLocalizedMessage()), e);
        }
        finally {
            registry.unregister(moduleID);
        }
        DeploymentLogger.get().fine("Created client jar file for " + moduleID + " at " + this.clientJar.getAbsolutePath());
    }

    public static final void createClientJar(DeploymentRequest request, File clientJar, ZipItem[] clientStubs, String clientJarChoice) throws IASDeploymentException {
        try {
            OutputJarArchive target = new OutputJarArchive();
            target.create(clientJar.getAbsolutePath());
            RootDeploymentDescriptor descriptor = request.getDescriptor().isVirtual() ? request.getDescriptor().getStandaloneBundleDescriptor() : request.getDescriptor();
            FileArchive source = new FileArchive();
            source.open(request.getDeployedDirectory().getAbsolutePath());
            PEDeploymentFactoryImpl pe = new PEDeploymentFactoryImpl();
            Properties props = ClientJarMakerThread.getPropertiesForClientJarMaker(CLIENT_JAR_CHOICES.getClientJarChoice(clientJarChoice), request, descriptor);
            ClientJarMaker jarMaker = pe.getClientJarMaker(props);
            if (FileUtils.safeIsDirectory(request.getGeneratedXMLDirectory())) {
                FileArchive source2 = new FileArchive();
                source2.open(request.getGeneratedXMLDirectory().getAbsolutePath());
                jarMaker.create(descriptor, source, source2, target, clientStubs, null);
                source2.close();
            } else {
                jarMaker.create(descriptor, source, target, clientStubs, null);
            }
            source.close();
            target.close();
        }
        catch (Exception e) {
            IASDeploymentException newE = new IASDeploymentException();
            newE.initCause(e);
            throw newE;
        }
    }

    private static Properties getPropertiesForClientJarMaker(CLIENT_JAR_CHOICES choice, DeploymentRequest request, RootDeploymentDescriptor descriptor) {
        boolean qualify = ClientJarMakerThread.qualifyModuleClientFormat(request, descriptor);
        Properties props = null;
        Boolean propertySetting = choice.useModuleClientJarMaker(qualify);
        if (propertySetting != null) {
            props = new Properties();
            props.setProperty("use.module.client.jar.maker", propertySetting.toString());
        }
        return props;
    }

    private static boolean qualifyModuleClientFormat(DeploymentRequest request, RootDeploymentDescriptor descriptor) {
        if (request.getDescriptor().isVirtual()) {
            return true;
        }
        Application app = (Application)Application.class.cast(descriptor);
        Set appClients = app.getApplicationClientDescriptors();
        if (appClients != null) {
            if (appClients.size() > 1) {
                return false;
            }
            if (!appClients.isEmpty()) {
                ApplicationClientDescriptor ac = (ApplicationClientDescriptor)ApplicationClientDescriptor.class.cast(appClients.iterator().next());
                Set msgDestRefs = ac.getMessageDestinationReferenceDescriptors();
                if (msgDestRefs != null && !msgDestRefs.isEmpty()) {
                    return false;
                }
                Set<EntityManagerFactoryReferenceDescriptor> entityMgrFacRefs = ac.getEntityManagerFactoryReferenceDescriptors();
                if (entityMgrFacRefs != null && !entityMgrFacRefs.isEmpty()) {
                    return false;
                }
            }
        }
        Iterator modules = app.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)ModuleDescriptor.class.cast(modules.next());
            if (md.getAlternateDescriptor() == null) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CLIENT_JAR_CHOICES {
        USE_ORIGINAL_MAKER{

            public Boolean useModuleClientJarMaker(boolean qualify) {
                return null;
            }
        }
        ,
        USE_TRANSITION_MAKER{

            public Boolean useModuleClientJarMaker(boolean qualify) {
                return qualify ? Boolean.TRUE : null;
            }
        }
        ,
        USE_COMBO_MAKER{

            public Boolean useModuleClientJarMaker(boolean qualify) {
                return new Boolean(qualify);
            }
        }
        ,
        USE_EAR_MAKER{

            public Boolean useModuleClientJarMaker(boolean qualify) {
                return Boolean.FALSE;
            }
        };

        public static CLIENT_JAR_CHOICES DEFAULT_CHOICE;

        public abstract Boolean useModuleClientJarMaker(boolean var1);

        public static CLIENT_JAR_CHOICES getClientJarChoice(String choice) {
            try {
                if (choice == null) {
                    return DEFAULT_CHOICE;
                }
                return CLIENT_JAR_CHOICES.valueOf(choice);
            }
            catch (IllegalArgumentException iae) {
                return DEFAULT_CHOICE;
            }
        }

        static {
            DEFAULT_CHOICE = USE_EAR_MAKER;
        }
    }
}

