/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.backend.ClientJarMakerRegistry;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentRequestRegistry;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.phasing.ApplicationStartPhase;
import com.sun.enterprise.deployment.phasing.ApplicationStopPhase;
import com.sun.enterprise.deployment.phasing.AssociationPhase;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentService;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DisassociationPhase;
import com.sun.enterprise.deployment.phasing.J2EECPhase;
import com.sun.enterprise.deployment.phasing.PostResCreationPhase;
import com.sun.enterprise.deployment.phasing.PostResDeletionPhase;
import com.sun.enterprise.deployment.phasing.PreResCreationPhase;
import com.sun.enterprise.deployment.phasing.PreResDeletionPhase;
import com.sun.enterprise.deployment.phasing.ResourceAdapterStartPhase;
import com.sun.enterprise.deployment.phasing.ResourceAdapterStopPhase;
import com.sun.enterprise.deployment.phasing.UndeployFromDomainPhase;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.management.deploy.DeploymentCallback;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class PEDeploymentService
extends DeploymentService {
    public static final Logger sLogger = DeploymentLogger.get();
    private static final Logger auditLogger = LogDomains.getLogger("javax.enterprise.system.tools.deployment.audit");
    private static final ResourceBundle auditBundle = auditLogger.getResourceBundle();
    private static StringManager localStrings = StringManager.getManager(PEDeploymentService.class);
    protected DeploymentContext deploymentContext = new DeploymentContext();
    private List deployToDomainPhaseList = null;
    private List undeployFromDomainPhaseList = null;
    private List deployPhaseList = null;
    private List undeployPhaseList = null;
    private List associatePhaseList = null;
    private List disassociatePhaseList = null;
    private List stopPhaseList = null;
    private List startPhaseList = null;
    static final String DISASSOCIATE_ACTION = localStrings.getString("enterprise.deployment.phasing.action.disassociate");
    static final String REDEPLOY_ACTION = localStrings.getString("enterprise.deployment.phasing.action.redeploy");
    static final String STOP_ACTION = localStrings.getString("enterprise.deployment.phasing.action.stop");
    static final String UNDEPLOY_ACTION = localStrings.getString("enterprise.deployment.phasing.action.undeploy");

    public PEDeploymentService(ConfigContext configContext) {
        this.deploymentContext.setConfigContext(configContext);
        this.initializePhases();
    }

    protected List getDeployPhaseListForTarget(DeploymentRequest req) {
        if (this.deployPhaseList != null) {
            return this.deployPhaseList;
        }
        J2EECPhase j2eec = new J2EECPhase(this.deploymentContext);
        AssociationPhase associate = new AssociationPhase(this.deploymentContext);
        ResourceAdapterStartPhase raStart = new ResourceAdapterStartPhase(this.deploymentContext);
        ApplicationStartPhase appStart = new ApplicationStartPhase(this.deploymentContext);
        PreResCreationPhase preResCreation = new PreResCreationPhase(this.deploymentContext);
        PostResCreationPhase postResCreation = new PostResCreationPhase(this.deploymentContext);
        this.deployPhaseList = new ArrayList();
        this.deployPhaseList.add(j2eec);
        this.deployPhaseList.add(associate);
        this.deployPhaseList.add(preResCreation);
        this.deployPhaseList.add(raStart);
        this.deployPhaseList.add(postResCreation);
        this.deployPhaseList.add(appStart);
        return this.deployPhaseList;
    }

    private void initializePhases() {
        J2EECPhase j2eec = new J2EECPhase(this.deploymentContext);
        AssociationPhase associate = new AssociationPhase(this.deploymentContext);
        DisassociationPhase disassociate = new DisassociationPhase(this.deploymentContext);
        UndeployFromDomainPhase undeploy = new UndeployFromDomainPhase(this.deploymentContext);
        ResourceAdapterStartPhase raStart = new ResourceAdapterStartPhase(this.deploymentContext);
        ApplicationStartPhase appStart = new ApplicationStartPhase(this.deploymentContext);
        PreResCreationPhase preResCreation = new PreResCreationPhase(this.deploymentContext);
        PostResCreationPhase postResCreation = new PostResCreationPhase(this.deploymentContext);
        ResourceAdapterStopPhase raStop = new ResourceAdapterStopPhase(this.deploymentContext);
        ApplicationStopPhase appStop = new ApplicationStopPhase(this.deploymentContext);
        PreResDeletionPhase preResDeletion = new PreResDeletionPhase(this.deploymentContext);
        PostResDeletionPhase postResDeletion = new PostResDeletionPhase(this.deploymentContext);
        this.deployToDomainPhaseList = new ArrayList();
        this.deployToDomainPhaseList.add(preResDeletion);
        this.deployToDomainPhaseList.add(postResDeletion);
        this.deployToDomainPhaseList.add(j2eec);
        this.deployToDomainPhaseList.add(preResCreation);
        this.deployToDomainPhaseList.add(postResCreation);
        this.associatePhaseList = new ArrayList();
        this.associatePhaseList.add(associate);
        this.disassociatePhaseList = new ArrayList();
        this.disassociatePhaseList.add(disassociate);
        this.undeployPhaseList = new ArrayList();
        this.undeployPhaseList.add(appStop);
        this.undeployPhaseList.add(preResDeletion);
        this.undeployPhaseList.add(raStop);
        this.undeployPhaseList.add(postResDeletion);
        this.undeployPhaseList.add(disassociate);
        this.undeployPhaseList.add(undeploy);
        this.undeployFromDomainPhaseList = new ArrayList();
        this.undeployFromDomainPhaseList.add(preResDeletion);
        this.undeployFromDomainPhaseList.add(postResDeletion);
        this.undeployFromDomainPhaseList.add(undeploy);
        this.startPhaseList = new ArrayList();
        this.startPhaseList.add(preResCreation);
        this.startPhaseList.add(raStart);
        this.startPhaseList.add(postResCreation);
        this.startPhaseList.add(appStart);
        this.stopPhaseList = new ArrayList();
        this.stopPhaseList.add(appStop);
        this.stopPhaseList.add(preResDeletion);
        this.stopPhaseList.add(raStop);
        this.stopPhaseList.add(postResDeletion);
    }

    private DeploymentStatus deploy(DeploymentRequest req, AuditInfo auditInfo) throws IASDeploymentException {
        DeploymentStatus result = null;
        result = req.getTarget() != null && !req.getTarget().getName().equals("domain") ? this.executePhases(req, this.getDeployPhaseListForTarget(req)) : this.executePhases(req, this.deployToDomainPhaseList);
        if (auditInfo != null) {
            auditInfo.reportEnd(result.getStatus());
        }
        return result;
    }

    public DeploymentStatus deploy(DeploymentRequest req) throws IASDeploymentException {
        return this.deploy(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.deploy));
    }

    public DeploymentStatus undeploy(DeploymentRequest req) throws IASDeploymentException {
        return this.undeploy(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.undeploy));
    }

    private DeploymentStatus undeploy(DeploymentRequest req, AuditInfo auditInfo) throws IASDeploymentException {
        DeploymentStatus result = null;
        if (AppVerification.doInstrument()) {
            AppVerification.getInstrumentLogger().handleChangeInDeployment();
        }
        String moduleID = req.getName();
        DeployableObjectType type = req.getType();
        DeploymentServiceUtils.validate(moduleID, type, UNDEPLOY_ACTION, req);
        result = req.getTarget() != null ? this.executePhases(req, this.undeployPhaseList) : this.executePhases(req, this.undeployFromDomainPhaseList);
        if (auditInfo != null) {
            auditInfo.reportEnd(result.getStatus());
        }
        return result;
    }

    private DeploymentStatus associate(DeploymentRequest req, AuditInfo auditInfo) {
        DeploymentStatus result = this.executePhases(req, this.associatePhaseList);
        if (auditInfo != null) {
            auditInfo.reportEnd(result.getStatus());
        }
        return result;
    }

    public DeploymentStatus associate(DeploymentRequest req) throws IASDeploymentException {
        return this.associate(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.associate));
    }

    public DeploymentStatus associate(String targetName, boolean enabled, String virtualServers, String referenceName) throws IASDeploymentException {
        try {
            long startTime = System.currentTimeMillis();
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(referenceName);
            DeploymentTarget target = DeploymentServiceUtils.getAndValidateDeploymentTarget(targetName, referenceName, false);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.DEPLOY);
            enabled = enabled || type.isCAR();
            req.setName(referenceName);
            req.setStartOnDeploy(enabled);
            req.setTarget(target);
            Properties optionalAttributes = new Properties();
            if (virtualServers != null) {
                optionalAttributes.put("virtual-servers", virtualServers);
            }
            req.setOptionalAttributes(optionalAttributes);
            return this.associate(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.associate, startTime));
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public DeploymentStatus associate(String targetName, String referenceName, Map options) throws IASDeploymentException {
        try {
            long startTime = System.currentTimeMillis();
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(referenceName);
            DeploymentProperties dProps = new DeploymentProperties(options);
            boolean enforceValidation = true;
            if (dProps.getRedeploy()) {
                DeploymentContext.SavedApplicationRefInfo info = this.deploymentContext.getSavedAppRef(referenceName, targetName);
                boolean bl = enforceValidation = info == null;
            }
            if (type.isCAR()) {
                dProps.setEnable(true);
            }
            DeploymentTarget target = enforceValidation ? DeploymentServiceUtils.getAndValidateDeploymentTarget(targetName, referenceName, false) : DeploymentServiceUtils.getDeploymentTarget(targetName);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.DEPLOY);
            String virtualServers = dProps.getVirtualServers();
            boolean enabled = dProps.getEnable();
            req.setName(referenceName);
            req.setStartOnDeploy(enabled);
            req.setTarget(target);
            req.setIsRedeployInProgress(dProps.getRedeploy());
            DeploymentServiceUtils.setResourceOptionsInRequest(req, dProps);
            Properties optionalAttributes = new Properties();
            if (virtualServers != null) {
                optionalAttributes.put("virtual-servers", virtualServers);
            }
            req.setOptionalAttributes(optionalAttributes);
            return this.associate(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.associate, startTime));
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    private DeploymentStatus disassociate(DeploymentRequest req, AuditInfo auditInfo) throws IASDeploymentException {
        String moduleID = req.getName();
        DeployableObjectType type = req.getType();
        DeploymentServiceUtils.validate(moduleID, type, DISASSOCIATE_ACTION, req);
        DeploymentStatus result = this.executePhases(req, this.disassociatePhaseList);
        if (auditInfo != null) {
            auditInfo.reportEnd(result.getStatus());
        }
        return result;
    }

    public DeploymentStatus disassociate(DeploymentRequest req) throws IASDeploymentException {
        return this.disassociate(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.disassociate));
    }

    public DeploymentStatus disassociate(String targetName, String referenceName) throws IASDeploymentException {
        try {
            long startTime = System.currentTimeMillis();
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(referenceName);
            DeploymentTarget target = DeploymentServiceUtils.getAndValidateDeploymentTarget(targetName, referenceName, true);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.UNDEPLOY);
            req.setName(referenceName);
            req.setTarget(target);
            return this.disassociate(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.disassociate, startTime));
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public DeploymentStatus disassociate(String targetName, String referenceName, Map options) throws IASDeploymentException {
        try {
            long startTime = System.currentTimeMillis();
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(referenceName);
            DeploymentTarget target = DeploymentServiceUtils.getAndValidateDeploymentTarget(targetName, referenceName, true);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.UNDEPLOY);
            req.setName(referenceName);
            req.setTarget(target);
            DeploymentProperties dProps = new DeploymentProperties(options);
            req.setCascade(dProps.getCascade());
            req.setForced(dProps.getForce());
            req.setExternallyManagedPath(dProps.getExternallyManaged());
            req.setIsRedeployInProgress(dProps.getRedeploy());
            DeploymentServiceUtils.setResourceOptionsInRequest(req, dProps);
            return this.disassociate(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.disassociate, startTime));
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    private DeploymentStatus start(DeploymentRequest req, AuditInfo auditInfo) {
        DeploymentStatus result = this.executePhases(req, this.startPhaseList);
        if (auditInfo != null) {
            auditInfo.reportEnd(result.getStatus());
        }
        return result;
    }

    public DeploymentStatus start(DeploymentRequest req) {
        return this.start(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.start));
    }

    public DeploymentStatus start(String moduleID, String targetName, Map options) throws IASDeploymentException {
        try {
            long startTime = System.currentTimeMillis();
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(moduleID);
            DeploymentTarget target = DeploymentServiceUtils.getDeploymentTarget(targetName);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.DEPLOY);
            int actionCode = type.isAPP() ? 1 : 4;
            req.setName(moduleID);
            req.setActionCode(actionCode);
            req.setTarget(target);
            DeploymentProperties dProps = new DeploymentProperties(options);
            req.setForced(dProps.getForce());
            DeploymentServiceUtils.setResourceOptionsInRequest(req, dProps);
            return this.start(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.start, startTime));
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    private DeploymentStatus stop(DeploymentRequest req, AuditInfo auditInfo) throws IASDeploymentException {
        String moduleID = req.getName();
        DeployableObjectType type = req.getType();
        DeploymentServiceUtils.validate(moduleID, type, STOP_ACTION, req);
        DeploymentStatus result = this.executePhases(req, this.stopPhaseList);
        if (auditInfo != null) {
            auditInfo.reportEnd(result.getStatus());
        }
        return result;
    }

    public DeploymentStatus stop(DeploymentRequest req) throws IASDeploymentException {
        return this.stop(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.stop));
    }

    public DeploymentStatus stop(String moduleID, String targetName, Map options) throws IASDeploymentException {
        try {
            long startTime = System.currentTimeMillis();
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(moduleID);
            DeploymentTarget target = DeploymentServiceUtils.getDeploymentTarget(targetName);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.UNDEPLOY);
            int actionCode = type.isAPP() ? 2 : 5;
            req.setName(moduleID);
            req.setActionCode(actionCode);
            req.setTarget(target);
            DeploymentProperties dProps = new DeploymentProperties(options);
            req.setCascade(dProps.getCascade());
            req.setForced(dProps.getForce());
            req.setExternallyManagedPath(dProps.getExternallyManaged());
            DeploymentServiceUtils.setResourceOptionsInRequest(req, dProps);
            return this.stop(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.stop, startTime));
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public DeploymentStatus deploy(File deployFile, File planFile, String archiveName, String moduleID, DeploymentProperties dProps, DeploymentCallback callback) throws IASDeploymentException {
        try {
            if (deployFile == null) {
                throw new IASDeploymentException(localStrings.getString("deployfile_not_specified"));
            }
            long startTime = System.currentTimeMillis();
            sLogger.log(Level.FINE, "mbean.begin_deploy", moduleID);
            DeployableObjectType type = null;
            type = dProps.getType() != null ? DeploymentServiceUtils.getDeployableObjectType(dProps.getType()) : DeploymentServiceUtils.getTypeFromFile(moduleID, deployFile.getAbsolutePath());
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.DEPLOY);
            DeploymentRequestRegistry.getRegistry().addDeploymentRequest(moduleID, req);
            req.setName(moduleID);
            boolean isRegistered = false;
            isRegistered = DeploymentServiceUtils.isRegistered(moduleID, type);
            if (isRegistered) {
                DeploymentServiceUtils.validate(moduleID, type, REDEPLOY_ACTION, req);
            }
            req.setFileSource(deployFile);
            req.setDeploymentPlan(planFile);
            req.setForced(dProps.getForce());
            if (type.isWEB()) {
                req.setDefaultContextRoot(dProps.getDefaultContextRoot(archiveName));
                req.setContextRoot(dProps.getContextRoot());
            }
            req.setVerifying(dProps.getVerify());
            req.setPrecompileJSP(dProps.getPrecompileJSP());
            req.setGenerateRMIStubs(dProps.getGenerateRMIStubs());
            req.setAvailabilityEnabled(dProps.getAvailabilityEnabled());
            req.setStartOnDeploy(dProps.getEnable());
            req.setDescription(dProps.getDescription());
            req.setLibraries(dProps.getLibraries());
            req.setJavaWebStartEnabled(dProps.getJavaWebStartEnabled());
            req.setExternallyManagedPath(dProps.getExternallyManaged());
            req.setDeploymentCallback(callback);
            req.setIsRedeployInProgress(dProps.getRedeploy());
            DeploymentServiceUtils.setResourceOptionsInRequest(req, dProps);
            Properties optionalAttributes = new Properties();
            String virtualServers = dProps.getVirtualServers();
            if (virtualServers != null) {
                optionalAttributes.put("virtual-servers", virtualServers);
            }
            req.setOptionalAttributes(optionalAttributes);
            req.addOptionalArguments(dProps.prune());
            DeploymentServiceUtils.setHostAndPort(req);
            return this.deploy(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.deploy, startTime));
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.deploy_failed", e);
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public DeploymentStatus undeploy(String mModuleID, Map mParams) throws IASDeploymentException {
        sLogger.log(Level.FINE, "mbean.begin_undeploy", mModuleID);
        try {
            long startTime = System.currentTimeMillis();
            DeployableObjectType objectType = DeploymentServiceUtils.getRegisteredType(mModuleID);
            DeploymentServiceUtils.checkAppReferencesBeforeUndeployFromDomain(mModuleID);
            if (objectType.isWEB()) {
                DeploymentServiceUtils.checkWebModuleReferences(mModuleID);
            }
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, objectType, DeploymentCommand.UNDEPLOY);
            DeploymentRequestRegistry.getRegistry().addDeploymentRequest(mModuleID, req);
            DeploymentProperties dProps = new DeploymentProperties(mParams);
            req.setName(mModuleID);
            req.setCascade(dProps.getCascade());
            req.setExternallyManagedPath(dProps.getExternallyManaged());
            DeploymentServiceUtils.setResourceOptionsInRequest(req, dProps);
            req.addOptionalArguments(dProps.prune());
            return this.undeploy(req, this.createAuditInfoIfOn(req, AuditInfo.Operation.undeploy, startTime));
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.phasing.deploymentservice.undeploy.failed", mModuleID, e.getLocalizedMessage());
            sLogger.log(Level.WARNING, msg);
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            IASDeploymentException ias = new IASDeploymentException(e.getLocalizedMessage());
            ias.initCause(e);
            throw ias;
        }
    }

    public boolean quit(String moduleID) {
        DeploymentRequest request = DeploymentRequestRegistry.getRegistry().getDeploymentRequest(moduleID);
        if (request != null) {
            request.setAbort(true);
            return true;
        }
        return false;
    }

    public static String getClientJarPath(String moduleID) {
        ClientJarMakerRegistry registry = ClientJarMakerRegistry.getInstance();
        if (registry.isRegistered(moduleID)) {
            registry.waitForCompletion(moduleID);
        }
        return moduleID + "Client.jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeploymentStatus executePhases(DeploymentRequest req, List phases) {
        try {
            Descriptor.setBoundsChecking(true);
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageDescription("Deployment");
            req.setCurrentDeploymentStatus(ds);
            DeploymentPhaseContext[] phaseCtx = new DeploymentPhaseContext[phases.size()];
            for (int i = 0; i < phases.size(); ++i) {
                try {
                    DeploymentStatus phaseDs = new DeploymentStatus(ds);
                    phaseCtx[i] = ((DeploymentPhase)phases.get(i)).executePhase(req, phaseDs);
                    if (phaseDs.getStageStatus() >= 1) continue;
                    this.rollbackPhases(phases, phaseCtx, i - 1);
                    DeploymentStatus deploymentStatus = ds;
                    return deploymentStatus;
                }
                catch (Throwable dpe) {
                    String msg = localStrings.getString("enterprise.deployment.phasing.deploymentservice.exception");
                    sLogger.log(Level.SEVERE, msg, dpe);
                    this.rollbackPhases(phases, phaseCtx, i - 1);
                    ds.setStageStatus(0);
                    if (dpe instanceof Serializable) {
                        ds.setStageException(dpe);
                    } else {
                        sLogger.severe(localStrings.getString("enterprise.deployment.phasing.exception_notserializable", dpe.getClass()));
                        sLogger.severe(localStrings.getString("enterprise.deployment.phasing.exception_notforwarded", dpe.getMessage()));
                    }
                    ds.setStageException(dpe);
                    ds.setStageStatusMessage(dpe.getMessage());
                    DeploymentStatus deploymentStatus = ds;
                    return deploymentStatus;
                }
            }
            DeploymentStatus deploymentStatus = ds;
            return deploymentStatus;
        }
        finally {
            req.done();
        }
    }

    private void rollbackPhases(List phases, DeploymentPhaseContext[] phaseCtx, int index) {
        for (int j = index; j >= 0; --j) {
            try {
                ((DeploymentPhase)phases.get(j)).rollback(phaseCtx[j]);
                continue;
            }
            catch (Exception rollbackException) {
                String msg = localStrings.getString("enterprise.deployment.phasing.deploymentservice.rollbackexception");
                sLogger.log(Level.INFO, msg, rollbackException);
            }
        }
    }

    public String getModuleIDFromDD(File file) throws Exception {
        Archivist source = ArchivistFactory.getArchivistForArchive(file);
        InputJarArchive archive = new InputJarArchive();
        archive.open(file.getAbsolutePath());
        Descriptor descriptor = null;
        String moduleID = null;
        String displayName = null;
        try {
            descriptor = source.readStandardDeploymentDescriptor(archive);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (descriptor != null) {
            displayName = descriptor.getDisplayName();
        }
        moduleID = displayName != null && displayName.length() > 0 ? displayName : new DeploymentProperties().getName(file.getAbsolutePath());
        moduleID = moduleID.replace(' ', '_');
        moduleID = moduleID.replace('\\', '_').replace('/', '_');
        moduleID = moduleID.replace(':', '_').replace('*', '_');
        moduleID = moduleID.replace('?', '_').replace('\"', '_');
        moduleID = moduleID.replace('<', '_').replace('>', '_');
        moduleID = moduleID.replace('|', '_');
        moduleID = moduleID.replace(',', '_').replace('=', '_');
        return moduleID;
    }

    private AuditInfo createAuditInfoIfOn(DeploymentRequest req, AuditInfo.Operation operation) {
        return auditLogger.isLoggable(Level.INFO) ? new AuditInfo(req, operation, System.currentTimeMillis()) : null;
    }

    private AuditInfo createAuditInfoIfOn(DeploymentRequest req, AuditInfo.Operation operation, long startTime) {
        return auditLogger.isLoggable(Level.INFO) ? new AuditInfo(req, operation, startTime) : null;
    }

    private static class AuditInfo {
        private static final String START_MESSAGE_KEY = "audit.start.message";
        private static final String END_MESSAGE_KEY = "audit.end.message";
        private long startTime;
        private String principal;
        private DeploymentRequest request;
        private Operation operation;

        private AuditInfo(DeploymentRequest req, Operation operation, long startTime) {
            Iterator<Principal> iter;
            this.request = req;
            this.startTime = startTime;
            this.operation = operation;
            this.principal = "Unknown";
            AccessControlContext acc = AccessController.getContext();
            Subject subject = Subject.getSubject(acc);
            if (subject != null && (iter = subject.getPrincipals().iterator()).hasNext()) {
                Principal p = iter.next();
                this.principal = p.getName();
            }
            auditLogger.log(Level.INFO, START_MESSAGE_KEY, new String[]{this.principal, operation.getAuditMessage(), this.request.getName(), this.request.getType().toString()});
        }

        private void reportEnd(int deploymentStatus) {
            auditLogger.log(Level.INFO, END_MESSAGE_KEY, this.computeEndParameters(this.findOutcome(deploymentStatus)));
        }

        private Outcome findOutcome(int deploymentStatus) {
            Outcome result = null;
            for (Outcome outcome : Outcome.values()) {
                if (!outcome.matches(deploymentStatus)) continue;
                result = outcome;
                break;
            }
            if (result == null) {
                throw new IllegalArgumentException("Deployment status value of " + deploymentStatus + " could not be mapped to an audit outcome");
            }
            return result;
        }

        private String[] computeEndParameters(Outcome outcome) {
            String[] result = new String[]{this.principal, this.operation.getAuditMessage(), outcome.getAuditMessage(), this.request.getName(), this.request.getType().toString(), String.valueOf(System.currentTimeMillis() - this.startTime)};
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Operation {
            deploy,
            undeploy,
            associate,
            disassociate,
            start,
            stop;


            private String getAuditMessage() {
                return auditBundle.getString("audit.operation." + this.toString());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Outcome {
            end(2),
            warning(1),
            fail(0);

            private int deploymentStatus;

            private Outcome(int deploymentStatus) {
                this.deploymentStatus = deploymentStatus;
            }

            private boolean matches(int deploymentStatus) {
                return deploymentStatus == this.deploymentStatus;
            }

            private String getAuditMessage() {
                return auditBundle.getString("audit.outcome." + this.toString());
            }
        }
    }
}

