/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Constants;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.diagnostics.collect.WritableDataImpl;
import com.sun.enterprise.diagnostics.util.DiagnosticServiceHelper;
import com.sun.enterprise.diagnostics.util.FileUtils;
import com.sun.enterprise.diagnostics.util.XmlUtils;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConfigCollector
implements Collector {
    private static final String PASSWORD_REPLACEMENT = "****";
    private static final String PASSWORD = "password";
    private String repositoryDir;
    private String reportDir;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public ConfigCollector(String repositoryDir, String reportDir) {
        this.repositoryDir = repositoryDir;
        this.reportDir = reportDir;
    }

    public Data capture() throws DiagnosticException {
        WritableDataImpl dataImpl = new WritableDataImpl("config details");
        dataImpl.addChild(this.captureXMLFile(Constants.DOMAIN_XML));
        dataImpl.addChild(this.captureFile(Constants.SERVER_POLICY));
        dataImpl.addChild(this.captureFile(Constants.LOGIN_CONF));
        dataImpl.addChild(this.captureFile(Constants.SUN_ACC));
        return dataImpl;
    }

    public Data captureXMLFile(String fileName) throws DiagnosticException {
        try {
            String xmlFileToModify = this.repositoryDir + fileName;
            String destFile = this.reportDir + fileName;
            String domainXMLDTD = DiagnosticServiceHelper.getInstallationRoot() + Constants.DOMAIN_XML_DTD;
            Document serverXml = XmlUtils.loadXML(xmlFileToModify, domainXMLDTD);
            XmlUtils.attrSearchReplace(serverXml.getDocumentElement(), PASSWORD, PASSWORD_REPLACEMENT);
            XmlUtils.copyXMLFile(serverXml, destFile);
            return new FileData(destFile, "config details");
        }
        catch (SAXException se) {
            logger.log(Level.WARNING, se.getMessage());
        }
        catch (IOException ie) {
            logger.log(Level.WARNING, ie.getMessage());
        }
        catch (TransformerConfigurationException tce) {
            logger.log(Level.WARNING, tce.getMessage());
        }
        catch (TransformerException te) {
            logger.log(Level.WARNING, te.getMessage());
        }
        catch (ParserConfigurationException pce) {
            logger.log(Level.WARNING, pce.getMessage());
        }
        return null;
    }

    public Data captureFile(String fileName) throws DiagnosticException {
        try {
            FileUtils.copyFile(this.repositoryDir + fileName, this.reportDir + fileName);
            return new FileData(this.reportDir + fileName, "config details");
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage());
            return null;
        }
    }
}

