/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.enterprise.deploy.shared.ModuleType;

public class DescriptorArchivist {
    public void write(Application application, AbstractArchive in, AbstractArchive out) throws IOException {
        if (application.isVirtual()) {
            ModuleDescriptor aModule = (ModuleDescriptor)application.getModules().next();
            Archivist moduleArchivist = ArchivistFactory.getArchivistForType(aModule.getModuleType());
            this.write(aModule.getDescriptor(), moduleArchivist, in, out);
        } else {
            Iterator modules = application.getModules();
            while (modules.hasNext()) {
                AbstractArchive moduleArchive;
                ModuleDescriptor aModule = (ModuleDescriptor)modules.next();
                Archivist moduleArchivist = ArchivistFactory.getArchivistForType(aModule.getModuleType());
                if (aModule.getAlternateDescriptor() != null) {
                    String ddPath = aModule.getAlternateDescriptor();
                    DeploymentDescriptorFile ddFile = moduleArchivist.getStandardDDFile();
                    BundleDescriptor bundle = aModule.getDescriptor();
                    if (!bundle.isFullFlag()) {
                        if (ddFile != null) {
                            OutputStream os = out.putNextEntry(ddPath);
                            ddFile.write((Descriptor)bundle, os);
                            out.closeEntry();
                        }
                    } else if (aModule.getModuleType().equals(ModuleType.WAR)) {
                        WebBundleDescriptor webBundle = (WebBundleDescriptor)aModule.getDescriptor();
                        if (webBundle.hasWebServices()) {
                            if (ddFile != null) {
                                OutputStream os = out.putNextEntry(ddPath);
                                ddFile.write((Descriptor)webBundle, os);
                                out.closeEntry();
                            }
                        } else {
                            Archivist.copyAnEntry(in, out, ddPath);
                        }
                    } else {
                        Archivist.copyAnEntry(in, out, ddPath);
                    }
                    String runtimeDDPath = "sun-" + ddPath;
                    DeploymentDescriptorFile confDDFile = moduleArchivist.getConfigurationDDFile();
                    if (confDDFile == null) continue;
                    OutputStream os = out.putNextEntry(runtimeDDPath);
                    confDDFile.write((Descriptor)aModule.getDescriptor(), os);
                    out.closeEntry();
                    continue;
                }
                String archiveUri = in.getArchiveUri();
                String moduleUri = aModule.getArchiveUri();
                AbstractArchive moduleArchive2 = in.getEmbeddedArchive(archiveUri);
                if (new File(archiveUri).isDirectory() && archiveUri.endsWith(".ear") && new File(archiveUri, moduleUri).isDirectory() && (moduleUri.endsWith(".war") || moduleUri.endsWith(".rar") || moduleUri.endsWith(".jar"))) {
                    File subDir = new File(out.getArchiveUri(), moduleUri);
                    if (!subDir.exists()) {
                        subDir.mkdirs();
                    }
                    moduleArchive = new FileArchive();
                    ((FileArchive)moduleArchive).open(subDir.getPath());
                } else {
                    moduleArchive = out.getEmbeddedArchive(moduleUri);
                }
                this.write(aModule.getDescriptor(), moduleArchivist, moduleArchive2, moduleArchive);
            }
            ApplicationArchivist archivist = new ApplicationArchivist();
            archivist.setDescriptor(application);
            archivist.writeRuntimeDeploymentDescriptors(out);
            if (application.isLoadedFromApplicationXml()) {
                archivist.copyStandardDeploymentDescriptors(in, out);
            } else {
                archivist.writeStandardDeploymentDescriptors(out);
            }
        }
    }

    public void write(BundleDescriptor bundle, AbstractArchive in, AbstractArchive out) throws IOException {
        Archivist archivist = ArchivistFactory.getArchivistForArchive(out);
        this.write(bundle, archivist, in, out);
    }

    protected void write(BundleDescriptor bundle, Archivist archivist, AbstractArchive in, AbstractArchive out) throws IOException {
        archivist.setDescriptor(bundle);
        archivist.writeRuntimeDeploymentDescriptors(out);
        if (!bundle.isFullFlag()) {
            archivist.writeStandardDeploymentDescriptors(out);
        } else if (bundle.getModuleType().equals(ModuleType.WAR)) {
            WebBundleDescriptor webBundle = (WebBundleDescriptor)bundle;
            if (webBundle.hasWebServices()) {
                archivist.writeStandardDeploymentDescriptors(out);
            } else {
                archivist.copyStandardDeploymentDescriptors(in, out);
            }
        } else {
            archivist.copyStandardDeploymentDescriptors(in, out);
        }
        if (bundle.hasWebServices()) {
            WebServicesDescriptor webServices = bundle.getWebServices();
            for (WebService webService : webServices.getWebServices()) {
                if (!webService.hasMappingFile() || webService.getMappingFileUri().endsWith(".xml")) continue;
                Archivist.copyAnEntry(in, out, webService.getMappingFileUri());
            }
        }
    }
}

