/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceAdapterConfigDeployer
implements ResourceDeployer {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public synchronized void deployResource(Object resource) throws Exception {
        ResourceAdapterConfig domainConfig = (ResourceAdapterConfig)resource;
        String rarName = domainConfig.getResourceAdapterName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        _logger.log(Level.FINE, "Calling backend to add resource adapterConfig ", rarName);
        crt.addResourceAdapterConfig(rarName, domainConfig);
        _logger.log(Level.FINE, "Added resource adapterConfig in backend", rarName);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        ResourceAdapterConfig domainConfig = (ResourceAdapterConfig)resource;
        String rarName = domainConfig.getResourceAdapterName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        crt.deleteResourceAdapterConfig(rarName);
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
    }

    public synchronized void enableResource(Object resource) throws Exception {
    }

    public Object getResource(String name, Resources rbeans) throws Exception {
        ResourceAdapterConfig res = rbeans.getResourceAdapterConfigByResourceAdapterName(name);
        if (res == null) {
            Exception ex = new Exception("No such resource");
            _logger.log(Level.SEVERE, "no_resource", name);
            _logger.log(Level.SEVERE, "", ex);
            throw ex;
        }
        return res;
    }
}

